/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.worldgen.generators.block;

import com.matez.wildnature.Main;
import com.matez.wildnature.init.ModBlocks;
import com.matez.wildnature.worldgen.generators.block.Fossil;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class WorldGenOres
implements IWorldGenerator {
    private Block[] defaultRocks = new Block[]{Blocks.field_150348_b, ModBlocks.FROZEN_STONE, ModBlocks.HARDENED_SANDSTONE, ModBlocks.RED_HARDENED_SANDSTONE};
    private Block[] defaultGround = new Block[]{Blocks.field_150349_c, ModBlocks.BROWN_GRASS_BLOCK, ModBlocks.DESERT_GRASS_BLOCK, ModBlocks.DRIED_GRASS_BLOCK, ModBlocks.MOLD_GRASS_BLOCK, Blocks.field_150346_d, ModBlocks.ZIEMA_BRUNATNA, ModBlocks.ZIEMA_CZARNOZIEM, ModBlocks.ZIEMA_PUSTYNNA, ModBlocks.ZIEMA_SUCHA};
    private Fossil AMBER_GEN = new Fossil(ModBlocks.AMBER_ORE.func_176223_P(), 3, 2, 50, 64, new Block[]{Blocks.field_150354_m});
    private Fossil AMETHYST_GEN = new Fossil(ModBlocks.AMETHYST_ORE.func_176223_P(), 3, 3, 15, 30, this.defaultRocks);
    private Fossil RUBY_GEN;
    private Fossil SILVER_GEN;
    private Fossil MALACHITE_GEN = new Fossil(ModBlocks.MALACHITE_ORE.func_176223_P(), 3, 3, 15, 30, this.defaultRocks);
    private Fossil SAPPHIRE_GEN = new Fossil(ModBlocks.SAPPHIRE_ORE.func_176223_P(), 3, 2, 15, 30, this.defaultRocks);

    public WorldGenOres() {
        this.SILVER_GEN = new Fossil(ModBlocks.SILVER_ORE.func_176223_P(), 3, 1, 20, 35, this.defaultRocks);
        this.RUBY_GEN = new Fossil(ModBlocks.RUBY_ORE.func_176223_P(), 3, 1, 10, 16, this.defaultRocks);
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        int dim = world.field_73011_w.getDimension();
        if (dim == 0) {
            this.runGenerator(this.AMBER_GEN, world, random, chunkX, chunkZ);
            this.runGenerator(this.AMETHYST_GEN, world, random, chunkX, chunkZ);
            this.runGenerator(this.RUBY_GEN, world, random, chunkX, chunkZ);
            this.runGenerator(this.SILVER_GEN, world, random, chunkX, chunkZ);
            this.runGenerator(this.MALACHITE_GEN, world, random, chunkX, chunkZ);
            this.runGenerator(this.SAPPHIRE_GEN, world, random, chunkX, chunkZ);
        }
    }

    private void runGenerator(Fossil fossil, World world, Random rand, int chunkX, int chunkZ) {
        int minHeight = fossil.getMinY(world);
        int maxHeight = fossil.getMaxY(world);
        int chance = fossil.getChance();
        int fossilSize = fossil.getSize();
        int maxDistance = 0;
        if (minHeight > maxHeight || minHeight < 0 || maxHeight > world.func_72800_K()) {
            throw new IllegalArgumentException("While generating " + fossil.getFossil().func_177230_c().func_149732_F() + " something went wrong.");
        }
        int heightDiff = maxHeight - minHeight + 1;
        for (int i = 0; i < chance; ++i) {
            int a;
            if (fossil.isWaterRequired()) {
                maxDistance = Main.generateRandomInt(4, 6, rand);
            }
            int x = chunkX * 16 + rand.nextInt(16);
            int y = minHeight + rand.nextInt(heightDiff);
            int z = chunkZ * 16 + rand.nextInt(16);
            boolean canSpawn = true;
            if (!canSpawn) continue;
            if (fossil.canSpawnOnAllBiomes()) {
                if (fossil.isWaterRequired()) {
                    if (!this.isWaterNear(new BlockPos(x, y, z), world, maxDistance)) continue;
                    for (a = 0; a < fossil.getFossilGens().size(); ++a) {
                        fossil.getFossilGens().get(a).func_180709_b(world, rand, new BlockPos(x, y, z));
                    }
                    continue;
                }
                while (a < fossil.getFossilGens().size()) {
                    fossil.getFossilGens().get(a).func_180709_b(world, rand, new BlockPos(x, y, z));
                    ++a;
                }
                continue;
            }
            for (int b = 0; b < fossil.getAllowedBiomes().size(); ++b) {
                if (!fossil.getAllowedBiomes().contains(world.func_180494_b(new BlockPos(x, y, z)))) continue;
                if (fossil.isWaterRequired()) {
                    if (!this.isWaterNear(new BlockPos(x, y, z), world, maxDistance)) continue;
                    while (a < fossil.getFossilGens().size()) {
                        fossil.getFossilGens().get(a).func_180709_b(world, rand, new BlockPos(x, y, z));
                        ++a;
                    }
                    continue;
                }
                while (a < fossil.getFossilGens().size()) {
                    fossil.getFossilGens().get(a).func_180709_b(world, rand, new BlockPos(x, y, z));
                    ++a;
                }
            }
        }
    }

    public boolean isWaterNear(BlockPos pos, World world, int maxDistance) {
        boolean near = false;
        for (int x = 1; !near && x < maxDistance; ++x) {
            near = this.checkWater(pos.func_177965_g(x), world);
            if (near || (near = this.checkWater(pos.func_177985_f(x), world)) || (near = this.checkWater(pos.func_177965_g(x), world)) || (near = this.checkWater(pos.func_177964_d(x), world))) continue;
            near = this.checkWater(pos.func_177981_b(x), world);
        }
        return near;
    }

    private boolean checkWater(BlockPos pos, World world) {
        return world.func_180495_p(pos).func_177230_c().equals(Blocks.field_150355_j) || world.func_180495_p(pos).func_177230_c().equals(Blocks.field_150358_i);
    }
}

