/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.worldgen.biomes;

import com.matez.wildnature.entity.EntityDuckChild;
import com.matez.wildnature.entity.EntityDuckFemale;
import com.matez.wildnature.entity.EntityDuckMale;
import com.matez.wildnature.init.ModBlocks;
import com.matez.wildnature.worldgen.biomes.BiomeDecorator1;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.BlockSand;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenBigTree;

public class BiomeTropicalCavern
extends Biome {
    protected static final WorldGenAbstractTree TREE = new WorldGenBigTree(true);
    private ArrayList<BlockPos> toReplace = new ArrayList();

    public BiomeTropicalCavern() {
        super(new Biome.BiomeProperties("Tropical Cavern").func_185398_c(0.3f).func_185400_d(0.05f).func_185410_a(0.7f).func_185395_b(0.7f));
    }

    public int func_180627_b(BlockPos pos) {
        return 11720457;
    }

    public WorldGenAbstractTree func_150567_a(Random rand) {
        return TREE;
    }

    public void plantFlower(World world, Random rand, BlockPos pos) {
    }

    public BiomeDecorator func_76729_a() {
        BiomeDecorator1 decorator = new BiomeDecorator1();
        this.field_76752_A = Blocks.field_150349_c.func_176223_P();
        this.field_76753_B = Blocks.field_150346_d.func_176223_P();
        decorator.field_76832_z = 0;
        decorator.field_76803_B = 20;
        decorator.field_76805_H = 0;
        decorator.field_76806_I = 0;
        decorator.mushrooms.add(ModBlocks.BOROWIK_SZLACHETNY.func_176223_P());
        decorator.mushrooms.add(ModBlocks.BOROWIK_WYSMUKLY.func_176223_P());
        decorator.mushrooms.add(ModBlocks.KOZLARZ_CZERWONY.func_176223_P());
        decorator.mushrooms.add(ModBlocks.MASLAK_ZWYCZAJNY.func_176223_P());
        decorator.mushrooms.add(ModBlocks.MLECZAJ_RYDZ.func_176223_P());
        decorator.mushrooms.add(ModBlocks.MUCHOMOR_SROMOTNIKOWY.func_176223_P());
        decorator.mushrooms.add(ModBlocks.MUCHOMOR_JADOWITY.func_176223_P());
        decorator.mushrooms.add(ModBlocks.PIEPRZNIK_JADALNY.func_176223_P());
        decorator.field_76808_K = false;
        decorator.field_76802_A = 20;
        return this.getModdedBiomeDecorator(decorator);
    }

    public void addDefaultFlowers() {
        this.field_76762_K.clear();
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityPig.class, 10, 4, 4));
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityChicken.class, 7, 3, 4));
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityDuckMale.class, 3, 1, 2));
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityDuckFemale.class, 3, 1, 2));
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityDuckChild.class, 1, 1, 2));
    }

    public void func_180622_a(World worldIn, Random rand, ChunkPrimer chunkPrimerIn, int x, int z, double noiseVal) {
        this.field_76752_A = Blocks.field_150349_c.func_176223_P();
        this.field_76753_B = Blocks.field_150346_d.func_176223_P();
        if (!(noiseVal > 1.75) && noiseVal > -0.95) {
            this.field_76752_A = ModBlocks.WHITE_SAND.func_176223_P();
            this.field_76753_B = Blocks.field_150343_Z.func_176223_P();
        }
        this.generateTerrain(worldIn, rand, chunkPrimerIn, x, z, noiseVal);
    }

    public final void generateTerrain(World worldIn, Random rand, ChunkPrimer chunkPrimerIn, int x, int z, double noiseVal) {
        int i = worldIn.func_181545_F();
        IBlockState iblockstate = this.field_76752_A;
        IBlockState iblockstate1 = this.field_76753_B;
        int j = -1;
        int k = (int)(noiseVal / 3.0 + 3.0 + rand.nextDouble() * 0.25);
        int l = x & 0xF;
        int i1 = z & 0xF;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int j1 = 255; j1 >= 0; --j1) {
            if (j1 <= rand.nextInt(5)) {
                chunkPrimerIn.func_177855_a(i1, j1, l, field_185367_c);
                continue;
            }
            IBlockState iblockstate2 = chunkPrimerIn.func_177856_a(i1, j1, l);
            if (iblockstate2.func_185904_a() == Material.field_151579_a) {
                j = -1;
                continue;
            }
            if (iblockstate2.func_177230_c() != Blocks.field_150348_b) continue;
            if (j == -1) {
                if (k <= 0) {
                    iblockstate = field_185366_b;
                    iblockstate1 = field_185365_a;
                } else if (j1 >= i - 4 && j1 <= i + 1) {
                    iblockstate = this.field_76752_A;
                    iblockstate1 = this.field_76753_B;
                }
                if (j1 < i && (iblockstate == null || iblockstate.func_185904_a() == Material.field_151579_a)) {
                    iblockstate = this.func_180626_a((BlockPos)blockpos$mutableblockpos.func_181079_c(x, j1, z)) < 0.15f ? field_185371_g : field_185372_h;
                }
                j = k;
                if (j1 >= i - 1) {
                    this.setBlockState(chunkPrimerIn, i1, j1, l, iblockstate);
                    continue;
                }
                if (j1 < i - 7 - k) {
                    iblockstate = field_185366_b;
                    iblockstate1 = field_185365_a;
                    this.setBlockState(chunkPrimerIn, i1, j1, l, field_185368_d);
                    continue;
                }
                this.setBlockState(chunkPrimerIn, i1, j1, l, iblockstate1);
                continue;
            }
            if (j <= 0) continue;
            this.setBlockState(chunkPrimerIn, i1, j1, l, iblockstate1);
            if (--j != 0 || iblockstate1.func_177230_c() != Blocks.field_150354_m || k <= 1) continue;
            j = rand.nextInt(4) + Math.max(0, j1 - 63);
            iblockstate1 = iblockstate1.func_177229_b((IProperty)BlockSand.field_176504_a) == BlockSand.EnumType.RED_SAND ? field_185369_e : field_185370_f;
        }
        this.replaceBlocks(chunkPrimerIn, worldIn);
    }

    private void setBlockState(ChunkPrimer chunkPrimer, int x, int y, int z, IBlockState state) {
        if (state.func_177230_c() == Blocks.field_150343_Z) {
            this.toReplace.add(new BlockPos(x, y, z));
        }
        chunkPrimer.func_177855_a(x, y, z, state);
    }

    private void replaceBlocks(ChunkPrimer primer, World world) {
        int x = 0;
        int dig = 4;
        IBlockState GROUND = ModBlocks.WHITE_SAND.func_176223_P();
        while (x < this.toReplace.size()) {
            int i;
            int y;
            BlockPos pos = this.toReplace.get(x);
            if (primer.func_177856_a(pos.func_177958_n(), pos.func_177956_o() - 1, pos.func_177952_p()).func_177230_c() == Blocks.field_150343_Z) {
                ++x;
                continue;
            }
            for (y = 0; y <= dig; ++y) {
                i = pos.func_177956_o() - 1 - y;
                IBlockState b = Blocks.field_150350_a.func_176223_P();
                if (i < world.func_181545_F()) {
                    b = Blocks.field_150358_i.func_176223_P();
                }
                primer.func_177855_a(pos.func_177958_n(), i, pos.func_177952_p(), b);
            }
            i = pos.func_177956_o() - 2 - y;
            primer.func_177855_a(pos.func_177958_n(), i, pos.func_177952_p(), GROUND);
            ++x;
        }
    }
}

