/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.worldgen.biomes;

import com.matez.wildnature.worldgen.world.MBBiome;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockStone;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.ChunkGeneratorSettings;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenBigMushroom;
import net.minecraft.world.gen.feature.WorldGenBush;
import net.minecraft.world.gen.feature.WorldGenCactus;
import net.minecraft.world.gen.feature.WorldGenClay;
import net.minecraft.world.gen.feature.WorldGenDeadBush;
import net.minecraft.world.gen.feature.WorldGenFlowers;
import net.minecraft.world.gen.feature.WorldGenLiquids;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenPumpkin;
import net.minecraft.world.gen.feature.WorldGenReed;
import net.minecraft.world.gen.feature.WorldGenSand;
import net.minecraft.world.gen.feature.WorldGenWaterlily;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.common.eventhandler.Event;

public class BiomeDecorator {
    public boolean decorating;
    public BlockPos chunkPos;
    public ChunkGeneratorSettings chunkProviderSettings;
    public WorldGenerator clayGen = new WorldGenClay(4);
    public WorldGenerator sandGen = new WorldGenSand((Block)Blocks.field_150354_m, 7);
    public WorldGenerator gravelGen = new WorldGenSand(Blocks.field_150351_n, 6);
    public WorldGenerator dirtGen;
    public WorldGenerator gravelOreGen;
    public WorldGenerator graniteGen;
    public WorldGenerator dioriteGen;
    public WorldGenerator andesiteGen;
    public WorldGenerator coalGen;
    public WorldGenerator ironGen;
    public WorldGenerator goldGen;
    public WorldGenerator redstoneGen;
    public WorldGenerator diamondGen;
    public WorldGenerator lapisGen;
    public WorldGenFlowers flowerGen = new WorldGenFlowers(Blocks.field_150327_N, BlockFlower.EnumFlowerType.DANDELION);
    public WorldGenerator mushroomBrownGen = new WorldGenBush(Blocks.field_150338_P);
    public WorldGenerator mushroomRedGen = new WorldGenBush(Blocks.field_150337_Q);
    public WorldGenerator bigMushroomGen = new WorldGenBigMushroom();
    public WorldGenerator reedGen = new WorldGenReed();
    public WorldGenerator cactusGen = new WorldGenCactus();
    public WorldGenerator waterlilyGen = new WorldGenWaterlily();
    public int waterlilyPerChunk;
    public int treesPerChunk;
    public float extraTreeChance = 0.1f;
    public int flowersPerChunk = 2;
    public int grassPerChunk = 1;
    public int deadBushPerChunk;
    public int mushroomsPerChunk;
    public int reedsPerChunk;
    public int cactiPerChunk;
    public int gravelPatchesPerChunk = 1;
    public int sandPatchesPerChunk = 3;
    public int clayPerChunk = 1;
    public int bigMushroomsPerChunk;
    public boolean generateFalls = true;

    public void decorate(World worldIn, Random random, MBBiome biome, BlockPos pos) {
        if (this.decorating) {
            throw new RuntimeException("Already decorating");
        }
        this.chunkProviderSettings = ChunkGeneratorSettings.Factory.func_177865_a((String)worldIn.func_72912_H().func_82571_y()).func_177864_b();
        this.chunkPos = pos;
        this.dirtGen = new WorldGenMinable(Blocks.field_150346_d.func_176223_P(), this.chunkProviderSettings.field_177789_I);
        this.gravelOreGen = new WorldGenMinable(Blocks.field_150351_n.func_176223_P(), this.chunkProviderSettings.field_177785_M);
        this.graniteGen = new WorldGenMinable(Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.GRANITE), this.chunkProviderSettings.field_177796_Q);
        this.dioriteGen = new WorldGenMinable(Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.DIORITE), this.chunkProviderSettings.field_177792_U);
        this.andesiteGen = new WorldGenMinable(Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.ANDESITE), this.chunkProviderSettings.field_177800_Y);
        this.coalGen = new WorldGenMinable(Blocks.field_150365_q.func_176223_P(), this.chunkProviderSettings.field_177844_ac);
        this.ironGen = new WorldGenMinable(Blocks.field_150366_p.func_176223_P(), this.chunkProviderSettings.field_177848_ag);
        this.goldGen = new WorldGenMinable(Blocks.field_150352_o.func_176223_P(), this.chunkProviderSettings.field_177828_ak);
        this.redstoneGen = new WorldGenMinable(Blocks.field_150450_ax.func_176223_P(), this.chunkProviderSettings.field_177836_ao);
        this.diamondGen = new WorldGenMinable(Blocks.field_150482_ag.func_176223_P(), this.chunkProviderSettings.field_177814_as);
        this.lapisGen = new WorldGenMinable(Blocks.field_150369_x.func_176223_P(), this.chunkProviderSettings.field_177822_aw);
        this.genDecorations(biome, worldIn, random);
        this.decorating = false;
    }

    protected void genDecorations(MBBiome biomeIn, World worldIn, Random random) {
        int k9;
        int i5;
        int j13;
        ChunkPos forgeChunkPos = new ChunkPos(this.chunkPos);
        MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Pre(worldIn, random, forgeChunkPos));
        this.generateOres(worldIn, random);
        if (TerrainGen.decorate((World)worldIn, (Random)random, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.SAND)) {
            for (int i = 0; i < this.sandPatchesPerChunk; ++i) {
                int j = random.nextInt(16) + 8;
                int k = random.nextInt(16) + 8;
                this.sandGen.func_180709_b(worldIn, random, worldIn.func_175672_r(this.chunkPos.func_177982_a(j, 0, k)));
            }
        }
        if (TerrainGen.decorate((World)worldIn, (Random)random, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.CLAY)) {
            for (int i1 = 0; i1 < this.clayPerChunk; ++i1) {
                int l1 = random.nextInt(16) + 8;
                int i6 = random.nextInt(16) + 8;
                this.clayGen.func_180709_b(worldIn, random, worldIn.func_175672_r(this.chunkPos.func_177982_a(l1, 0, i6)));
            }
        }
        if (TerrainGen.decorate((World)worldIn, (Random)random, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.SAND_PASS2)) {
            for (int j1 = 0; j1 < this.gravelPatchesPerChunk; ++j1) {
                int i2 = random.nextInt(16) + 8;
                int j6 = random.nextInt(16) + 8;
                this.gravelGen.func_180709_b(worldIn, random, worldIn.func_175672_r(this.chunkPos.func_177982_a(i2, 0, j6)));
            }
        }
        int k1 = this.treesPerChunk;
        if (random.nextFloat() < this.extraTreeChance) {
            ++k1;
        }
        if (TerrainGen.decorate((World)worldIn, (Random)random, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.TREE)) {
            for (int j2 = 0; j2 < k1; ++j2) {
                int k6 = random.nextInt(16) + 8;
                int l = random.nextInt(16) + 8;
                WorldGenAbstractTree worldgenabstracttree = biomeIn.func_150567_a(random);
                worldgenabstracttree.func_175904_e();
                BlockPos blockpos = worldIn.func_175645_m(this.chunkPos.func_177982_a(k6, 0, l));
                if (!worldgenabstracttree.func_180709_b(worldIn, random, blockpos)) continue;
                worldgenabstracttree.func_180711_a(worldIn, random, blockpos);
            }
        }
        if (TerrainGen.decorate((World)worldIn, (Random)random, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.BIG_SHROOM)) {
            for (int k2 = 0; k2 < this.bigMushroomsPerChunk; ++k2) {
                int l6 = random.nextInt(16) + 8;
                int k10 = random.nextInt(16) + 8;
                this.bigMushroomGen.func_180709_b(worldIn, random, worldIn.func_175645_m(this.chunkPos.func_177982_a(l6, 0, k10)));
            }
        }
        if (TerrainGen.decorate((World)worldIn, (Random)random, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.FLOWERS)) {
            for (int l2 = 0; l2 < this.flowersPerChunk; ++l2) {
                int k17;
                BlockPos blockpos1;
                BlockFlower.EnumFlowerType blockflower$enumflowertype;
                BlockFlower blockflower;
                int l10;
                int i7 = random.nextInt(16) + 8;
                int j14 = worldIn.func_175645_m(this.chunkPos.func_177982_a(i7, 0, l10 = random.nextInt(16) + 8)).func_177956_o() + 32;
                if (j14 <= 0 || (blockflower = (blockflower$enumflowertype = biomeIn.func_180623_a(random, blockpos1 = this.chunkPos.func_177982_a(i7, k17 = random.nextInt(j14), l10))).func_176964_a().func_180346_a()).func_176223_P().func_185904_a() == Material.field_151579_a) continue;
                this.flowerGen.func_175914_a(blockflower, blockflower$enumflowertype);
                this.flowerGen.func_180709_b(worldIn, random, blockpos1);
            }
        }
        if (TerrainGen.decorate((World)worldIn, (Random)random, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.GRASS)) {
            for (int i3 = 0; i3 < this.grassPerChunk; ++i3) {
                int i11;
                int j7 = random.nextInt(16) + 8;
                int k14 = worldIn.func_175645_m(this.chunkPos.func_177982_a(j7, 0, i11 = random.nextInt(16) + 8)).func_177956_o() * 2;
                if (k14 <= 0) continue;
                int l17 = random.nextInt(k14);
                biomeIn.func_76730_b(random).func_180709_b(worldIn, random, this.chunkPos.func_177982_a(j7, l17, i11));
            }
        }
        if (TerrainGen.decorate((World)worldIn, (Random)random, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.DEAD_BUSH)) {
            for (int j3 = 0; j3 < this.deadBushPerChunk; ++j3) {
                int j11;
                int k7 = random.nextInt(16) + 8;
                int l14 = worldIn.func_175645_m(this.chunkPos.func_177982_a(k7, 0, j11 = random.nextInt(16) + 8)).func_177956_o() * 2;
                if (l14 <= 0) continue;
                int i18 = random.nextInt(l14);
                new WorldGenDeadBush().func_180709_b(worldIn, random, this.chunkPos.func_177982_a(k7, i18, j11));
            }
        }
        if (TerrainGen.decorate((World)worldIn, (Random)random, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.LILYPAD)) {
            for (int k3 = 0; k3 < this.waterlilyPerChunk; ++k3) {
                BlockPos blockpos7;
                int k11;
                int l7 = random.nextInt(16) + 8;
                int i15 = worldIn.func_175645_m(this.chunkPos.func_177982_a(l7, 0, k11 = random.nextInt(16) + 8)).func_177956_o() * 2;
                if (i15 <= 0) continue;
                int j18 = random.nextInt(i15);
                BlockPos blockpos4 = this.chunkPos.func_177982_a(l7, j18, k11);
                while (blockpos4.func_177956_o() > 0 && worldIn.func_175623_d(blockpos7 = blockpos4.func_177977_b())) {
                    blockpos4 = blockpos7;
                }
                this.waterlilyGen.func_180709_b(worldIn, random, blockpos4);
            }
        }
        if (TerrainGen.decorate((World)worldIn, (Random)random, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.SHROOM)) {
            int l8;
            int j4;
            int k12;
            int k8;
            int i4;
            int j12;
            for (int l3 = 0; l3 < this.mushroomsPerChunk; ++l3) {
                int i12;
                int j8;
                int j15;
                if (random.nextInt(4) == 0) {
                    int i8 = random.nextInt(16) + 8;
                    int l11 = random.nextInt(16) + 8;
                    BlockPos blockpos2 = worldIn.func_175645_m(this.chunkPos.func_177982_a(i8, 0, l11));
                    this.mushroomBrownGen.func_180709_b(worldIn, random, blockpos2);
                }
                if (random.nextInt(8) != 0 || (j15 = worldIn.func_175645_m(this.chunkPos.func_177982_a(j8 = random.nextInt(16) + 8, 0, i12 = random.nextInt(16) + 8)).func_177956_o() * 2) <= 0) continue;
                int k18 = random.nextInt(j15);
                BlockPos blockpos5 = this.chunkPos.func_177982_a(j8, k18, i12);
                this.mushroomRedGen.func_180709_b(worldIn, random, blockpos5);
            }
            if (random.nextInt(4) == 0 && (j12 = worldIn.func_175645_m(this.chunkPos.func_177982_a(i4 = random.nextInt(16) + 8, 0, k8 = random.nextInt(16) + 8)).func_177956_o() * 2) > 0) {
                int k15 = random.nextInt(j12);
                this.mushroomBrownGen.func_180709_b(worldIn, random, this.chunkPos.func_177982_a(i4, k15, k8));
            }
            if (random.nextInt(8) == 0 && (k12 = worldIn.func_175645_m(this.chunkPos.func_177982_a(j4 = random.nextInt(16) + 8, 0, l8 = random.nextInt(16) + 8)).func_177956_o() * 2) > 0) {
                int l15 = random.nextInt(k12);
                this.mushroomRedGen.func_180709_b(worldIn, random, this.chunkPos.func_177982_a(j4, l15, l8));
            }
        }
        if (TerrainGen.decorate((World)worldIn, (Random)random, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.REED)) {
            for (int k4 = 0; k4 < this.reedsPerChunk; ++k4) {
                int l12;
                int i9 = random.nextInt(16) + 8;
                int i16 = worldIn.func_175645_m(this.chunkPos.func_177982_a(i9, 0, l12 = random.nextInt(16) + 8)).func_177956_o() * 2;
                if (i16 <= 0) continue;
                int l18 = random.nextInt(i16);
                this.reedGen.func_180709_b(worldIn, random, this.chunkPos.func_177982_a(i9, l18, l12));
            }
            for (int l4 = 0; l4 < 10; ++l4) {
                int i13;
                int j9 = random.nextInt(16) + 8;
                int j16 = worldIn.func_175645_m(this.chunkPos.func_177982_a(j9, 0, i13 = random.nextInt(16) + 8)).func_177956_o() * 2;
                if (j16 <= 0) continue;
                int i19 = random.nextInt(j16);
                this.reedGen.func_180709_b(worldIn, random, this.chunkPos.func_177982_a(j9, i19, i13));
            }
        }
        if (TerrainGen.decorate((World)worldIn, (Random)random, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.PUMPKIN) && random.nextInt(32) == 0 && (j13 = worldIn.func_175645_m(this.chunkPos.func_177982_a(i5 = random.nextInt(16) + 8, 0, k9 = random.nextInt(16) + 8)).func_177956_o() * 2) > 0) {
            int k16 = random.nextInt(j13);
            new WorldGenPumpkin().func_180709_b(worldIn, random, this.chunkPos.func_177982_a(i5, k16, k9));
        }
        if (TerrainGen.decorate((World)worldIn, (Random)random, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.CACTUS)) {
            for (int j5 = 0; j5 < this.cactiPerChunk; ++j5) {
                int k13;
                int l9 = random.nextInt(16) + 8;
                int l16 = worldIn.func_175645_m(this.chunkPos.func_177982_a(l9, 0, k13 = random.nextInt(16) + 8)).func_177956_o() * 2;
                if (l16 <= 0) continue;
                int j19 = random.nextInt(l16);
                this.cactusGen.func_180709_b(worldIn, random, this.chunkPos.func_177982_a(l9, j19, k13));
            }
        }
        if (this.generateFalls) {
            if (TerrainGen.decorate((World)worldIn, (Random)random, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.LAKE_WATER)) {
                for (int k5 = 0; k5 < 50; ++k5) {
                    int i10 = random.nextInt(16) + 8;
                    int l13 = random.nextInt(16) + 8;
                    int i17 = random.nextInt(248) + 8;
                    if (i17 <= 0) continue;
                    int k19 = random.nextInt(i17);
                    BlockPos blockpos6 = this.chunkPos.func_177982_a(i10, k19, l13);
                    new WorldGenLiquids((Block)Blocks.field_150358_i).func_180709_b(worldIn, random, blockpos6);
                }
            }
            if (TerrainGen.decorate((World)worldIn, (Random)random, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.LAKE_LAVA)) {
                for (int l5 = 0; l5 < 20; ++l5) {
                    int j10 = random.nextInt(16) + 8;
                    int i14 = random.nextInt(16) + 8;
                    int j17 = random.nextInt(random.nextInt(random.nextInt(240) + 8) + 8);
                    BlockPos blockpos3 = this.chunkPos.func_177982_a(j10, j17, i14);
                    new WorldGenLiquids((Block)Blocks.field_150356_k).func_180709_b(worldIn, random, blockpos3);
                }
            }
        }
        MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Post(worldIn, random, forgeChunkPos));
    }

    protected void generateOres(World worldIn, Random random) {
        MinecraftForge.ORE_GEN_BUS.post((Event)new OreGenEvent.Pre(worldIn, random, this.chunkPos));
        if (TerrainGen.generateOre((World)worldIn, (Random)random, (WorldGenerator)this.dirtGen, (BlockPos)this.chunkPos, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.DIRT)) {
            this.genStandardOre1(worldIn, random, this.chunkProviderSettings.field_177790_J, this.dirtGen, this.chunkProviderSettings.field_177791_K, this.chunkProviderSettings.field_177784_L);
        }
        if (TerrainGen.generateOre((World)worldIn, (Random)random, (WorldGenerator)this.gravelOreGen, (BlockPos)this.chunkPos, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.GRAVEL)) {
            this.genStandardOre1(worldIn, random, this.chunkProviderSettings.field_177786_N, this.gravelOreGen, this.chunkProviderSettings.field_177787_O, this.chunkProviderSettings.field_177797_P);
        }
        if (TerrainGen.generateOre((World)worldIn, (Random)random, (WorldGenerator)this.dioriteGen, (BlockPos)this.chunkPos, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.DIORITE)) {
            this.genStandardOre1(worldIn, random, this.chunkProviderSettings.field_177795_V, this.dioriteGen, this.chunkProviderSettings.field_177794_W, this.chunkProviderSettings.field_177801_X);
        }
        if (TerrainGen.generateOre((World)worldIn, (Random)random, (WorldGenerator)this.graniteGen, (BlockPos)this.chunkPos, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.GRANITE)) {
            this.genStandardOre1(worldIn, random, this.chunkProviderSettings.field_177799_R, this.graniteGen, this.chunkProviderSettings.field_177798_S, this.chunkProviderSettings.field_177793_T);
        }
        if (TerrainGen.generateOre((World)worldIn, (Random)random, (WorldGenerator)this.andesiteGen, (BlockPos)this.chunkPos, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.ANDESITE)) {
            this.genStandardOre1(worldIn, random, this.chunkProviderSettings.field_177802_Z, this.andesiteGen, this.chunkProviderSettings.field_177846_aa, this.chunkProviderSettings.field_177847_ab);
        }
        if (TerrainGen.generateOre((World)worldIn, (Random)random, (WorldGenerator)this.coalGen, (BlockPos)this.chunkPos, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.COAL)) {
            this.genStandardOre1(worldIn, random, this.chunkProviderSettings.field_177845_ad, this.coalGen, this.chunkProviderSettings.field_177851_ae, this.chunkProviderSettings.field_177853_af);
        }
        if (TerrainGen.generateOre((World)worldIn, (Random)random, (WorldGenerator)this.ironGen, (BlockPos)this.chunkPos, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.IRON)) {
            this.genStandardOre1(worldIn, random, this.chunkProviderSettings.field_177849_ah, this.ironGen, this.chunkProviderSettings.field_177832_ai, this.chunkProviderSettings.field_177834_aj);
        }
        if (TerrainGen.generateOre((World)worldIn, (Random)random, (WorldGenerator)this.goldGen, (BlockPos)this.chunkPos, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.GOLD)) {
            this.genStandardOre1(worldIn, random, this.chunkProviderSettings.field_177830_al, this.goldGen, this.chunkProviderSettings.field_177840_am, this.chunkProviderSettings.field_177842_an);
        }
        if (TerrainGen.generateOre((World)worldIn, (Random)random, (WorldGenerator)this.redstoneGen, (BlockPos)this.chunkPos, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.REDSTONE)) {
            this.genStandardOre1(worldIn, random, this.chunkProviderSettings.field_177838_ap, this.redstoneGen, this.chunkProviderSettings.field_177818_aq, this.chunkProviderSettings.field_177816_ar);
        }
        if (TerrainGen.generateOre((World)worldIn, (Random)random, (WorldGenerator)this.diamondGen, (BlockPos)this.chunkPos, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.DIAMOND)) {
            this.genStandardOre1(worldIn, random, this.chunkProviderSettings.field_177812_at, this.diamondGen, this.chunkProviderSettings.field_177826_au, this.chunkProviderSettings.field_177824_av);
        }
        if (TerrainGen.generateOre((World)worldIn, (Random)random, (WorldGenerator)this.lapisGen, (BlockPos)this.chunkPos, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.LAPIS)) {
            this.genStandardOre2(worldIn, random, this.chunkProviderSettings.field_177820_ax, this.lapisGen, this.chunkProviderSettings.field_177807_ay, this.chunkProviderSettings.field_177805_az);
        }
        MinecraftForge.ORE_GEN_BUS.post((Event)new OreGenEvent.Post(worldIn, random, this.chunkPos));
    }

    protected void genStandardOre1(World worldIn, Random random, int blockCount, WorldGenerator generator, int minHeight, int maxHeight) {
        if (maxHeight < minHeight) {
            int i = minHeight;
            minHeight = maxHeight;
            maxHeight = i;
        } else if (maxHeight == minHeight) {
            if (minHeight < 255) {
                ++maxHeight;
            } else {
                --minHeight;
            }
        }
        for (int j = 0; j < blockCount; ++j) {
            BlockPos blockpos = this.chunkPos.func_177982_a(random.nextInt(16), random.nextInt(maxHeight - minHeight) + minHeight, random.nextInt(16));
            generator.func_180709_b(worldIn, random, blockpos);
        }
    }

    protected void genStandardOre2(World worldIn, Random random, int blockCount, WorldGenerator generator, int centerHeight, int spread) {
        for (int i = 0; i < blockCount; ++i) {
            BlockPos blockpos = this.chunkPos.func_177982_a(random.nextInt(16), random.nextInt(spread) + random.nextInt(spread) + centerHeight - spread, random.nextInt(16));
            generator.func_180709_b(worldIn, random, blockpos);
        }
    }
}

