/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.worldgen;

import com.matez.wildnature.Main;
import com.matez.wildnature.init.ModBlocks;
import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.common.IPlantable;

public class WorldGenSchematicTree
extends WorldGenAbstractTree {
    public IBlockState LOG = ModBlocks.FIR_LOG.func_176223_P();
    public IBlockState DIRT = Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.PODZOL);
    public IBlockState LEAVES = ModBlocks.FIR_LEAVES.func_176223_P().func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)BlockLeaves.field_176237_a, (Comparable)Boolean.valueOf(false));
    public IBlockState FLOOR = Blocks.field_150346_d.func_176223_P();
    private final int minTreeHeight = 15;
    World world;
    BlockPos pos;
    int rotate;
    ArrayList<BlockPos> addedBlocks = new ArrayList();
    ArrayList<BlockPos> bottomBlocks = new ArrayList();
    int doneBlocks = 0;

    public WorldGenSchematicTree(boolean parShouldNotify, @Nullable IBlockState logState, @Nullable IBlockState leavesState) {
        super(parShouldNotify);
        if (logState != null) {
            this.LOG = logState;
        }
        if (leavesState != null) {
            this.LEAVES = leavesState;
        }
        this.FLOOR = this.LOG;
    }

    public WorldGenSchematicTree(boolean parShouldNotify, @Nullable IBlockState logState, @Nullable IBlockState leavesState, @Nullable IBlockState floorState) {
        super(parShouldNotify);
        if (logState != null) {
            this.LOG = logState;
        }
        if (leavesState != null) {
            this.LEAVES = leavesState;
        }
        this.FLOOR = floorState != null ? floorState : this.LOG;
    }

    public boolean func_180709_b(World parWorld, Random parRandom, BlockPos parBlockPos) {
        this.world = parWorld;
        this.pos = parBlockPos;
        int minHeight = Main.generateRandomInt(-8, 8) + 15;
        if (parBlockPos.func_177956_o() >= 1 && parBlockPos.func_177956_o() + minHeight + 1 <= parWorld.func_72800_K()) {
            if (!this.isSuitableLocation(parWorld, parBlockPos, (BlockBush)Blocks.field_150345_g, minHeight)) {
                return false;
            }
            IBlockState state = parWorld.func_180495_p(parBlockPos.func_177977_b());
            if (state.func_177230_c().canSustainPlant(state, (IBlockAccess)parWorld, parBlockPos.func_177977_b(), EnumFacing.UP, (IPlantable)Blocks.field_150345_g) && parBlockPos.func_177956_o() < parWorld.func_72800_K() - minHeight - 1) {
                if (!(state.func_177230_c() instanceof BlockLeaves)) {
                    state.func_177230_c().onPlantGrow(state, parWorld, parBlockPos.func_177977_b(), parBlockPos);
                    this.rotate = Main.generateRandomInt(1, 4);
                    this.generateBlocks(parWorld, parBlockPos, minHeight, parRandom);
                    this.generatePlatform(parWorld);
                    return true;
                }
                return false;
            }
            return false;
        }
        return false;
    }

    public void generatePlatform(World world) {
        int x;
        if (this.bottomBlocks == null) {
            return;
        }
        BlockPos down = null;
        for (x = 0; x < this.addedBlocks.size(); ++x) {
            if (down == null) {
                down = this.addedBlocks.get(x);
            }
            if (this.addedBlocks.get(x).func_177956_o() >= down.func_177956_o()) continue;
            down = this.addedBlocks.get(x);
        }
        for (x = 0; x < this.addedBlocks.size(); ++x) {
            if (this.addedBlocks.get(x).func_177956_o() != down.func_177956_o() + 1) continue;
            this.bottomBlocks.add(this.downBlock(this.addedBlocks.get(x), 1));
        }
        x = 0;
        int loop = 0;
        int done = 0;
        while (true) {
            if (world.func_175623_d(this.downBlock(this.bottomBlocks.get(x), loop)) || !world.func_180495_p(this.downBlock(this.bottomBlocks.get(x), loop)).func_185913_b()) {
                this.func_175903_a(world, this.downBlock(this.bottomBlocks.get(x), loop), this.FLOOR);
            } else {
                ++done;
            }
            if (this.bottomBlocks.size() - 1 == x) {
                x = 0;
                ++loop;
                done = 0;
            }
            if (loop == 10) break;
            ++x;
        }
        this.addedBlocks.clear();
        this.bottomBlocks.clear();
    }

    private BlockPos downBlock(BlockPos blockPos, int down) {
        return new BlockPos(blockPos.func_177958_n(), blockPos.func_177956_o() - down, blockPos.func_177952_p());
    }

    public void generateBlocks(World parWorld, BlockPos parBlockPos, int height, Random parRandom) {
        System.out.println("Nothing happens");
    }

    public void Block(int x, int y, int z, IBlockState blockState) {
        --y;
        BlockPos posx = null;
        if (this.rotate == 1) {
            posx = new BlockPos(this.pos.func_177958_n() + x, this.pos.func_177956_o() + y, this.pos.func_177952_p() + z);
        } else if (this.rotate == 2) {
            posx = new BlockPos(this.pos.func_177958_n() - x, this.pos.func_177956_o() + y, this.pos.func_177952_p() - z);
        } else if (this.rotate == 3) {
            posx = new BlockPos(this.pos.func_177958_n() - x, this.pos.func_177956_o() + y, this.pos.func_177952_p() + z);
        } else if (this.rotate == 4) {
            posx = new BlockPos(this.pos.func_177958_n() + x, this.pos.func_177956_o() + y, this.pos.func_177952_p() - z);
        } else {
            throw new NullPointerException("Rotation is " + this.rotate + ", but allowed is from 1 to 4");
        }
        this.func_175903_a(this.world, posx, blockState);
        this.addedBlocks.add(posx);
    }

    private boolean isSuitableLocation(World parWorld, BlockPos parBlockPos, BlockBush block, int minHeight) {
        return block.func_176196_c(parWorld, parBlockPos);
    }
}

