/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.worldgen;

import java.util.Random;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.IPlantable;

public class WorldGenFlower
extends WorldGenerator {
    private IBlockState block;

    public WorldGenFlower(IBlockState blockIn) {
        this.block = blockIn;
    }

    private boolean canBlockStay(World worldIn, BlockPos pos, IBlockState state) {
        if (state.func_185913_b()) {
            return worldIn.func_180495_p(pos.func_177977_b()).func_185913_b();
        }
        try {
            IBlockState soil = worldIn.func_180495_p(pos.func_177977_b());
            return soil.func_177230_c().canSustainPlant(soil, (IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP, (IPlantable)state.func_177230_c());
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        for (int i = 0; i < 64; ++i) {
            BlockPos blockpos = position.func_177982_a(rand.nextInt(8) - rand.nextInt(8), rand.nextInt(4) - rand.nextInt(4), rand.nextInt(8) - rand.nextInt(8));
            if (!worldIn.func_175623_d(blockpos) || worldIn.field_73011_w.func_177495_o() && blockpos.func_177956_o() >= worldIn.func_72800_K() - 1 || !this.canBlockStay(worldIn, blockpos, this.block)) continue;
            worldIn.func_180501_a(blockpos, this.block, 2);
        }
        return true;
    }

    public boolean generateDoublePlant(World worldIn, Random rand, BlockPos position) {
        for (int i = 0; i < 64; ++i) {
            BlockPos blockpos = position.func_177982_a(rand.nextInt(8) - rand.nextInt(8), rand.nextInt(4) - rand.nextInt(4), rand.nextInt(8) - rand.nextInt(8));
            if (!worldIn.func_175623_d(blockpos) || worldIn.field_73011_w.func_177495_o() && blockpos.func_177956_o() >= worldIn.func_72800_K() - 1 || !this.canBlockStay(worldIn, blockpos, this.block)) continue;
            worldIn.func_180501_a(blockpos, this.block.func_177226_a((IProperty)BlockDoublePlant.field_176492_b, (Comparable)BlockDoublePlant.EnumBlockHalf.LOWER), 2);
            worldIn.func_180501_a(blockpos.func_177984_a(), this.block.func_177226_a((IProperty)BlockDoublePlant.field_176492_b, (Comparable)BlockDoublePlant.EnumBlockHalf.UPPER), 2);
        }
        return true;
    }

    public void setGeneratedBlock(IBlockState blockbush) {
        this.block = blockbush;
    }
}

