/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.worldgen;

import com.matez.wildnature.Main;
import com.matez.wildnature.blocks.CornBush;
import com.matez.wildnature.init.ModBlocks;
import java.util.Random;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenCornGrass
extends WorldGenerator {
    private IBlockState block;

    public WorldGenCornGrass(IBlockState blockIn) {
        this.block = blockIn;
    }

    private boolean canBlockStay(World worldIn, BlockPos pos, IBlockState state) {
        if (state.func_185913_b()) {
            return worldIn.func_180495_p(pos.func_177977_b()).func_185913_b();
        }
        try {
            IBlockState soil = worldIn.func_180495_p(pos.func_177977_b());
            return ModBlocks.CORN_BUSH.func_176196_c(worldIn, pos);
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        IBlockState iblockstate = worldIn.func_180495_p(position);
        while ((iblockstate.func_177230_c().isAir(iblockstate, (IBlockAccess)worldIn, position) || iblockstate.func_177230_c().isLeaves(iblockstate, (IBlockAccess)worldIn, position)) && position.func_177956_o() > 0) {
            position = position.func_177977_b();
            iblockstate = worldIn.func_180495_p(position);
        }
        for (int i = 0; i < 128; ++i) {
            BlockPos blockpos = position.func_177982_a(rand.nextInt(8) - rand.nextInt(8), rand.nextInt(4) - rand.nextInt(4), rand.nextInt(8) - rand.nextInt(8));
            if (!worldIn.func_175623_d(blockpos) || worldIn.field_73011_w.func_177495_o() && blockpos.func_177956_o() >= worldIn.func_72800_K() - 1 || !this.canBlockStay(worldIn, blockpos, this.block)) continue;
            this.setBlockCorn(worldIn, blockpos, rand);
        }
        return true;
    }

    public boolean setBlockCorn(World world, BlockPos pos, Random rand) {
        try {
            int x = 0;
            int max = Main.generateRandomInt(4, 5, rand);
            boolean isGrown = false;
            switch (Main.generateRandomInt(0, 12)) {
                case 0: {
                    isGrown = true;
                }
            }
            while (x < max) {
                CornBush bush = (CornBush)ModBlocks.CORN_BUSH;
                bush.setHeight(x + 1);
                bush.canGrow = false;
                if (x + 1 == max) {
                    world.func_180501_a(pos.func_177981_b(x), bush.func_176223_P().func_177226_a((IProperty)CornBush.STAGE, (Comparable)Integer.valueOf(0)), 2);
                    if (isGrown) {
                        bush.makeGrown(world, pos.func_177977_b());
                    }
                } else {
                    world.func_180501_a(pos.func_177981_b(x), bush.func_176223_P().func_177226_a((IProperty)CornBush.STAGE, (Comparable)Integer.valueOf(1)), 2);
                }
                ++x;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

