/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.entity;

import com.google.common.collect.Sets;
import com.matez.wildnature.entity.AI.EntityAIAdvancedFollowParent;
import com.matez.wildnature.entity.AI.EntityAIAdvancedMate;
import com.matez.wildnature.entity.AI.EntityAIEatItem;
import com.matez.wildnature.entity.AI.EntityAIMountainClimb;
import com.matez.wildnature.entity.EntityGoatChild;
import com.matez.wildnature.entity.EntityGoatFemale;
import com.matez.wildnature.entity.EntityGoatMale;
import com.matez.wildnature.util.handlers.LootTableHandler;
import com.matez.wildnature.util.handlers.SoundHandler;
import java.util.ArrayList;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIEatGrass;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class EntityGoat
extends EntityAnimal {
    private static final DataParameter<Integer> BOOST_TIME = EntityDataManager.func_187226_a(EntityGoat.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final Set<Item> TEMPTATION_ITEMS = Sets.newHashSet((Object[])new Item[]{Items.field_151172_bF, Items.field_151174_bG, Items.field_185164_cV, Items.field_151015_O, Items.field_151025_P});
    private boolean boosting;
    private int boostTime;
    private int totalBoostTime;
    public int type = 0;
    private ArrayList<Item> eatableItems;

    public EntityGoat(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.0f, 1.0f);
    }

    public void setType(int type) {
        this.type = type;
    }

    protected void func_184651_r() {
        this.eatableItems = new ArrayList(ForgeRegistries.ITEMS.getValuesCollection());
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.mateAI();
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIEatGrass((EntityLiving)this));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAIMountainClimb((EntityCreature)this, 15, 0.5f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIEatItem((EntityCreature)this, 0.7, 4.0, this.eatableItems));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 1.1));
    }

    protected void mateAI() {
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAdvancedMate(this, EntityGoatMale.class, EntityGoatFemale.class, 1.0, EntityGoatChild.class));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAdvancedFollowParent(this, EntityGoatFemale.class, 1.1));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        if (this.func_70631_g_()) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
        }
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.4);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(3.0);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_188790_f).func_111128_a(3.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(3.0);
    }

    public boolean func_82171_bF() {
        return false;
    }

    public boolean func_70686_a(Class<? extends EntityLivingBase> cls) {
        return true;
    }

    public int func_70641_bl() {
        return 7;
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
        if (flag) {
            this.func_174815_a((EntityLivingBase)this, entityIn);
        }
        return flag;
    }

    public void func_184206_a(DataParameter<?> key) {
        if (BOOST_TIME.equals(key) && this.field_70170_p.field_72995_K) {
            this.boosting = true;
            this.boostTime = 0;
            this.totalBoostTime = (Integer)this.field_70180_af.func_187225_a(BOOST_TIME);
        }
        super.func_184206_a(key);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(BOOST_TIME, (Object)0);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
    }

    protected SoundEvent func_184639_G() {
        if (this.func_70631_g_()) {
            return SoundHandler.ENTITY_GOAT_BEE_BABY;
        }
        return SoundHandler.ENTITY_GOAT_BEE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundHandler.ENTITY_GOAT_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SoundHandler.ENTITY_GOAT_DEATH;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187765_eK, 0.25f, 0.6f);
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (itemstack.func_77973_b() == Items.field_151133_ar && !player.field_71075_bZ.field_75098_d && !this.func_70631_g_()) {
            player.func_184185_a(SoundEvents.field_187564_an, 1.0f, 1.0f);
            itemstack.func_190918_g(1);
            if (itemstack.func_190926_b()) {
                player.func_184611_a(hand, new ItemStack(Items.field_151117_aB));
            } else if (!player.field_71071_by.func_70441_a(new ItemStack(Items.field_151117_aB))) {
                player.func_71019_a(new ItemStack(Items.field_151117_aB), false);
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K && this.getSaddled()) {
            this.func_145779_a(Items.field_151141_av, 1);
        }
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableHandler.GOAT_LOOT;
    }

    public boolean getSaddled() {
        return false;
    }

    public void func_70077_a(EntityLightningBolt lightningBolt) {
    }

    public void func_191986_a(float strafe, float vertical, float forward) {
        Entity entity;
        Entity entity2 = entity = this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
        if (this.func_184207_aI() && this.func_82171_bF()) {
            this.field_70126_B = this.field_70177_z = entity.field_70177_z;
            this.field_70125_A = entity.field_70125_A * 0.5f;
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            this.field_70761_aq = this.field_70177_z;
            this.field_70759_as = this.field_70177_z;
            this.field_70138_W = 1.0f;
            this.field_70747_aH = this.func_70689_ay() * 0.1f;
            if (this.boosting && this.boostTime++ > this.totalBoostTime) {
                this.boosting = false;
            }
            if (this.func_184186_bw()) {
                float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e() * 0.225f;
                if (this.boosting) {
                    f += f * 1.15f * MathHelper.func_76126_a((float)((float)this.boostTime / (float)this.totalBoostTime * (float)Math.PI));
                }
                this.func_70659_e(f);
                super.func_191986_a(0.0f, 0.0f, 1.0f);
            } else {
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
            }
            this.field_184618_aE = this.field_70721_aZ;
            double d1 = this.field_70165_t - this.field_70169_q;
            double d0 = this.field_70161_v - this.field_70166_s;
            float f1 = MathHelper.func_76133_a((double)(d1 * d1 + d0 * d0)) * 4.0f;
            if (f1 > 1.0f) {
                f1 = 1.0f;
            }
            this.field_70721_aZ += (f1 - this.field_70721_aZ) * 0.4f;
            this.field_184619_aG += this.field_70721_aZ;
        } else {
            this.field_70138_W = 0.5f;
            this.field_70747_aH = 0.02f;
            super.func_191986_a(strafe, vertical, forward);
        }
    }

    public boolean boost() {
        if (this.boosting) {
            return false;
        }
        this.boosting = true;
        this.boostTime = 0;
        this.totalBoostTime = this.func_70681_au().nextInt(841) + 140;
        this.func_184212_Q().func_187227_b(BOOST_TIME, (Object)this.totalBoostTime);
        return true;
    }

    public EntityGoat createChild(EntityAgeable ageable) {
        EntityGoatChild child = new EntityGoatChild(this.field_70170_p);
        child.setType(2);
        return child;
    }

    public boolean func_70877_b(ItemStack stack) {
        return TEMPTATION_ITEMS.contains(stack.func_77973_b());
    }

    public int getType() {
        return this.type;
    }

    public boolean func_70878_b(EntityAnimal otherAnimal) {
        if (otherAnimal instanceof EntityGoat && ((EntityGoat)otherAnimal).getType() != this.getType() && ((EntityGoat)otherAnimal).getType() != 2 && this.getType() != 2) {
            return this.func_70880_s() && otherAnimal.func_70880_s();
        }
        return false;
    }
}

