/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.blocks.TileEntities;

import com.matez.wildnature.blocks.BlockIronworks;
import com.matez.wildnature.blocks.recipes.IronworksRecipes;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityIronworks
extends TileEntity
implements ITickable {
    public ItemStackHandler handler = new ItemStackHandler(7);
    private String customName;
    private ItemStack smelting = ItemStack.field_190927_a;
    private ItemStack smeltingTrash = ItemStack.field_190927_a;
    private int burnTime;
    private int currentBurnTime;
    private int cookTime;
    private int totalCookTime = 400;

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.handler;
        }
        return (T)super.getCapability(capability, facing);
    }

    public String getName() {
        return this.hasCustomName() ? this.customName : "container.ironworks";
    }

    public boolean hasCustomName() {
        return this.customName != null && !this.customName.isEmpty();
    }

    public void setCustomInventoryName(String p_145951_1_) {
        this.customName = p_145951_1_;
    }

    public void setCustomName(String customName) {
        this.customName = customName;
    }

    public ITextComponent func_145748_c_() {
        return this.hasCustomName() ? new TextComponentString(this.customName) : new TextComponentTranslation("container.ironworks", new Object[0]);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.handler.deserializeNBT(compound.func_74775_l("Inventory"));
        this.burnTime = compound.func_74762_e("BurnTime");
        this.cookTime = compound.func_74762_e("CookTime");
        this.totalCookTime = compound.func_74762_e("CookTimeTotal");
        this.currentBurnTime = TileEntityIronworks.getItemBurnTime(this.handler.getStackInSlot(2));
        if (compound.func_150297_b("CustomName", 8)) {
            this.setCustomName(compound.func_74779_i("CustomName"));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("BurnTime", (int)((short)this.burnTime));
        compound.func_74768_a("CookTime", (int)((short)this.cookTime));
        compound.func_74768_a("CookTimeTotal", (int)((short)this.totalCookTime));
        compound.func_74782_a("Inventory", (NBTBase)this.handler.serializeNBT());
        if (this.hasCustomName()) {
            compound.func_74778_a("CustomName", this.customName);
        }
        return compound;
    }

    public boolean isBurning() {
        return this.burnTime > 0;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isBurning(TileEntityIronworks te) {
        return te.getField(0) > 0;
    }

    public void func_73660_a() {
        boolean flag = this.isBurning();
        boolean flag1 = false;
        if (this.isBurning()) {
            --this.burnTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            ItemStack fuel = this.handler.getStackInSlot(4);
            if (!(!this.isBurning() && (fuel.func_190926_b() || this.handler.getStackInSlot(0).func_190926_b() && this.handler.getStackInSlot(1).func_190926_b() && this.handler.getStackInSlot(2).func_190926_b() && this.handler.getStackInSlot(3).func_190926_b()))) {
                if (!this.isBurning() && this.canSmelt()) {
                    this.currentBurnTime = this.burnTime = TileEntityIronworks.getItemBurnTime(fuel);
                    if (this.isBurning()) {
                        flag1 = true;
                        if (!fuel.func_190926_b()) {
                            Item item = fuel.func_77973_b();
                            fuel.func_190918_g(1);
                            if (fuel.func_190926_b()) {
                                ItemStack item1 = item.getContainerItem(fuel);
                                this.handler.setStackInSlot(4, item1);
                            }
                        }
                    }
                }
                if (this.isBurning() && this.canSmelt()) {
                    ++this.cookTime;
                    if (this.cookTime == this.totalCookTime) {
                        this.cookTime = 0;
                        this.totalCookTime = 400;
                        this.smeltItem();
                        flag1 = true;
                    }
                } else {
                    this.cookTime = 0;
                }
            } else if (!this.isBurning() && this.cookTime > 0) {
                this.cookTime = MathHelper.func_76125_a((int)(this.cookTime - 2), (int)0, (int)this.totalCookTime);
            }
            if (flag != this.isBurning()) {
                flag1 = true;
                BlockIronworks.setState(this.isBurning(), this.field_145850_b, this.field_174879_c);
            }
        }
        if (flag1) {
            this.func_70296_d();
        }
    }

    private void smeltItem() {
        if (this.canSmelt()) {
            ItemStack[] inputs = new ItemStack[]{this.handler.getStackInSlot(0), this.handler.getStackInSlot(1), this.handler.getStackInSlot(2), this.handler.getStackInSlot(3)};
            ItemStack output = IronworksRecipes.getIronworksResult(inputs[0], inputs[1], inputs[2], inputs[3]);
            ItemStack trashOutput = IronworksRecipes.getIronworksResultTrash(inputs[0], inputs[1], inputs[2], inputs[3]);
            if (this.handler.getStackInSlot(5).func_190916_E() > 0 && !this.handler.getStackInSlot(5).func_190926_b()) {
                this.handler.getStackInSlot(5).func_190917_f(1);
            } else {
                this.handler.setStackInSlot(5, trashOutput);
            }
            if (this.handler.getStackInSlot(6).func_190916_E() > 0 && !this.handler.getStackInSlot(6).func_190926_b()) {
                this.handler.getStackInSlot(6).func_190917_f(1);
            } else {
                this.handler.setStackInSlot(6, output);
            }
            inputs[0].func_190918_g(1);
            inputs[1].func_190918_g(1);
            inputs[2].func_190918_g(1);
            inputs[3].func_190918_g(1);
            this.handler.setStackInSlot(0, inputs[0]);
            this.handler.setStackInSlot(1, inputs[1]);
            this.handler.setStackInSlot(2, inputs[2]);
            this.handler.setStackInSlot(3, inputs[3]);
        }
    }

    private boolean canSmelt() {
        int res;
        ItemStack output;
        if (this.handler.getStackInSlot(0).func_190926_b() || this.handler.getStackInSlot(1).func_190926_b() || this.handler.getStackInSlot(2).func_190926_b() || this.handler.getStackInSlot(3).func_190926_b()) {
            return false;
        }
        ItemStack result = IronworksRecipes.getIronworksResult(this.handler.getStackInSlot(0), this.handler.getStackInSlot(1), this.handler.getStackInSlot(2), this.handler.getStackInSlot(3));
        ItemStack resultTrash = IronworksRecipes.getIronworksResultTrash(this.handler.getStackInSlot(0), this.handler.getStackInSlot(1), this.handler.getStackInSlot(2), this.handler.getStackInSlot(3));
        boolean boolResult = false;
        boolean boolTrash = false;
        if (result.func_190926_b()) {
            boolResult = false;
        } else {
            output = this.handler.getStackInSlot(6);
            if (output.func_190926_b()) {
                boolResult = true;
            } else if (!output.func_77969_a(result)) {
                boolResult = false;
            } else {
                res = output.func_190916_E() + result.func_190916_E();
                boolean bl = boolResult = res <= 64 && res <= output.func_77976_d();
            }
        }
        boolTrash = resultTrash.func_190926_b() ? true : ((output = this.handler.getStackInSlot(5)).func_190926_b() ? true : (!output.func_77969_a(resultTrash) ? false : (res = output.func_190916_E() + resultTrash.func_190916_E()) <= 64 && res <= output.func_77976_d()));
        return boolTrash && boolResult;
    }

    public static int getItemBurnTime(ItemStack fuel) {
        if (fuel.func_190926_b()) {
            return 0;
        }
        Item item = fuel.func_77973_b();
        if (item instanceof ItemBlock && Block.func_149634_a((Item)item) != Blocks.field_150350_a) {
            Block block = Block.func_149634_a((Item)item);
            if (block == Blocks.field_150376_bx) {
                return 150;
            }
            if (block.func_176223_P().func_185904_a() == Material.field_151575_d) {
                return 300;
            }
            if (block == Blocks.field_150402_ci) {
                return 16000;
            }
        }
        if (item instanceof ItemTool && "WOOD".equals(((ItemTool)item).func_77861_e())) {
            return 200;
        }
        if (item instanceof ItemSword && "WOOD".equals(((ItemSword)item).func_150932_j())) {
            return 200;
        }
        if (item instanceof ItemHoe && "WOOD".equals(((ItemHoe)item).func_77842_f())) {
            return 200;
        }
        if (item == Items.field_151055_y) {
            return 100;
        }
        if (item == Items.field_151044_h) {
            return 1600;
        }
        if (item == Items.field_151129_at) {
            return 20000;
        }
        if (item == Item.func_150898_a((Block)Blocks.field_150345_g)) {
            return 100;
        }
        if (item == Items.field_151072_bj) {
            return 2400;
        }
        return GameRegistry.getFuelValue((ItemStack)fuel);
    }

    public static boolean isItemFuel(ItemStack fuel) {
        return TileEntityIronworks.getItemBurnTime(fuel) > 0;
    }

    public boolean isUsableByPlayer(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) != this ? false : player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public int getField(int id) {
        switch (id) {
            case 0: {
                return this.burnTime;
            }
            case 1: {
                return this.currentBurnTime;
            }
            case 2: {
                return this.cookTime;
            }
            case 3: {
                return this.totalCookTime;
            }
        }
        return 0;
    }

    public void setField(int id, int value) {
        switch (id) {
            case 0: {
                this.burnTime = value;
                break;
            }
            case 1: {
                this.currentBurnTime = value;
                break;
            }
            case 2: {
                this.cookTime = value;
                break;
            }
            case 3: {
                this.totalCookTime = value;
            }
        }
    }

    public boolean canInsertItem(int index, ItemStack itemStackIn, EnumFacing direction) {
        return this.isItemValidForSlot(index, itemStackIn);
    }

    private boolean isItemValidForSlot(int index, ItemStack stack) {
        return index != 5 && index != 6;
    }
}

