/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.blocks;

import com.matez.wildnature.Main;
import com.matez.wildnature.init.ModBlocks;
import com.matez.wildnature.init.ModItems;
import com.matez.wildnature.util.IHasModel;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CornBush
extends Block
implements IHasModel,
IGrowable {
    public static final PropertyInteger STAGE = PropertyInteger.func_177719_a((String)"stage", (int)0, (int)2);
    private int growChance = 30;
    private int height = 1;
    private boolean grown = false;
    private boolean wild = false;
    private NBTTagCompound tag;
    public boolean canGrow = true;
    private World cornWorld;

    public CornBush(String name) {
        super(Material.field_151585_k);
        this.func_149663_c(name);
        this.setRegistryName(name);
        this.func_149647_a(Main.mbtab);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(0)));
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149675_a(true);
        this.func_149713_g(0);
        this.grown = false;
        if (this.tag == null) {
            this.tag = new NBTTagCompound();
        }
        ModBlocks.BLOCKS.add(this);
        ModItems.ITEMS.add((Item)new ItemBlock((Block)this).setRegistryName(this.getRegistryName()));
    }

    public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
        if ((Integer)blockState.func_177229_b((IProperty)STAGE) == 0) {
            this.func_149711_c(0.1f);
            return 0.1f;
        }
        this.func_149711_c(0.5f);
        return 0.5f;
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        if (this.tag == null) {
            this.tag = new NBTTagCompound();
        } else {
            this.height = this.tag.func_74762_e("height");
            this.grown = this.tag.func_74767_n("grown");
            this.wild = this.tag.func_74767_n("wild");
        }
    }

    @Override
    public void registerModels() {
        Main.proxy.registerItemRenderer(Item.func_150898_a((Block)this), 0, "inventory");
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if ((Integer)state.func_177229_b((IProperty)STAGE) > 0) {
            return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        }
        return new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.4000000357627869, 0.9375);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{STAGE});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)STAGE);
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        BlockPos down = pos.func_177977_b();
        if (worldIn.func_180495_p(down).func_177230_c() instanceof CornBush) {
            return (Integer)worldIn.func_180495_p(down).func_177229_b((IProperty)STAGE) != 0;
        }
        if (worldIn.func_180495_p(down).func_177230_c() == this) {
            return (Integer)worldIn.func_180495_p(down).func_177229_b((IProperty)STAGE) != 0;
        }
        return this.isSuitableLocation(worldIn, pos, (BlockBush)Blocks.field_150345_g);
    }

    private boolean isSuitableLocation(World parWorld, BlockPos parBlockPos, BlockBush block) {
        return parWorld.func_180495_p(parBlockPos.func_177977_b()).equals(Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.COARSE_DIRT));
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!this.func_176196_c(worldIn, pos)) {
            this.destroy(worldIn, pos);
        }
    }

    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        return !this.grown && this.canGrow;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return !this.grown && this.canSustainPlant(worldIn.func_180495_p(pos.func_177977_b()), (IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP, (IPlantable)Blocks.field_150345_g);
    }

    public void func_176206_d(World worldIn, BlockPos pos, IBlockState state) {
        this.destroy(worldIn, pos);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public boolean canBlockStay(World worldIn, BlockPos pos) {
        return this.func_176196_c(worldIn, pos);
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        this.grown = false;
        this.height = 1;
        this.tag.func_74757_a("grown", false);
        if (this.getCornHeight(worldIn, pos.func_177977_b()) == -1) {
            this.setHeight(1);
        } else {
            this.setHeight(this.getCornHeight(worldIn, pos.func_177977_b()) + 1);
        }
        this.tag.func_74768_a("height", this.getHeight());
        this.tag.func_74757_a("wild", true);
        if (worldIn.field_72995_K && placer.equals((Object)Minecraft.func_71410_x().field_71439_g)) {
            this.tag.func_74757_a("wild", false);
        }
    }

    public void func_180653_a(World worldIn, BlockPos pos, IBlockState state, float chance, int fortune) {
        this.dropCorn(worldIn, pos, state, this.wild);
    }

    public void dropCorn(World worldIn, BlockPos pos, IBlockState state, boolean isWild) {
        if ((Integer)state.func_177229_b((IProperty)STAGE) == 2) {
            if (!isWild) {
                switch (Main.generateRandomInt(0, 1)) {
                    case 0: {
                        CornBush.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack(ModItems.CORN));
                    }
                    case 1: {
                        CornBush.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack(ModItems.CORN));
                        CornBush.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack(ModItems.CORN));
                    }
                }
            } else {
                CornBush.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack(ModItems.CORN));
            }
        }
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        int x;
        int currentState = (Integer)state.func_177229_b((IProperty)STAGE);
        if (this.height < 5) {
            if (this.getCornHeight(worldIn, pos.func_177977_b()) == -1) {
                this.setHeight(1);
            } else {
                this.setHeight(this.getCornHeight(worldIn, pos.func_177977_b()) + 1);
            }
            BlockPos upper = pos.func_177984_a();
            if (currentState == 0) {
                this.setCornState(worldIn, pos, 1, this.getCornHeight(worldIn, pos));
            } else if (currentState == 1) {
                if (worldIn.func_175623_d(upper)) {
                    this.setCornState(worldIn, upper, 0, this.getCornHeight(worldIn, pos) + 1);
                } else if (worldIn.func_180495_p(upper).func_177230_c() instanceof CornBush) {
                    CornBush bush = (CornBush)worldIn.func_180495_p(upper).func_177230_c();
                    bush.func_176474_b(worldIn, rand, upper, worldIn.func_180495_p(upper));
                }
                this.setCornState(worldIn, pos, 1, this.getCornHeight(worldIn, pos));
            }
        } else if (!this.grown && (x = Main.generateRandomInt(0, 20, rand)) == 0) {
            this.makeGrown(worldIn, pos);
        }
    }

    public void setHeight(int newHeight) {
        this.height = newHeight;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean setCornState(World world, BlockPos pos, int stage, int height) {
        CornBush cornBush = (CornBush)ModBlocks.CORN_BUSH;
        cornBush.setHeight(height);
        IBlockState cornState = cornBush.func_176223_P().func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(stage));
        world.func_175656_a(pos, cornState);
        return world.func_180495_p(pos).equals(cornState) && ((CornBush)world.func_180495_p(pos).func_177230_c()).getHeight() == height;
    }

    public int getCornHeight(World world, BlockPos pos) {
        if (world.func_180495_p(pos).func_177230_c() instanceof CornBush) {
            CornBush bush = (CornBush)world.func_180495_p(pos).func_177230_c();
            return bush.getHeight();
        }
        return -1;
    }

    public boolean setCornHeight(World world, BlockPos pos, int height) {
        if (world.func_180495_p(pos).func_177230_c() instanceof CornBush) {
            CornBush bush = (CornBush)world.func_180495_p(pos).func_177230_c();
            bush.setHeight(height);
            world.func_175656_a(pos, bush.func_176223_P().func_177226_a((IProperty)STAGE, world.func_180495_p(pos).func_177229_b((IProperty)STAGE)));
            bush = (CornBush)world.func_180495_p(pos).func_177230_c();
            return bush.getHeight() == height;
        }
        return false;
    }

    public boolean hasGrown(BlockPos pos, World world) {
        if (this.height == 1) {
            int blocks = 1;
            for (int a = 0; a < 4; ++a) {
                if (world.func_180495_p(pos.func_177981_b(a)).func_177230_c() != Blocks.field_150350_a && !(world.func_180495_p(pos.func_177981_b(a)).func_177230_c() instanceof CornBush)) {
                    this.destroy(world, pos);
                    return false;
                }
                if (world.func_180495_p(pos.func_177981_b(a)) != this.func_176223_P().func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(1))) continue;
                ++blocks;
            }
            return blocks == 4;
        }
        return false;
    }

    public void destroy(World worldIn, BlockPos pos) {
        this.grown = false;
        for (int a = -4; a < 8; ++a) {
            try {
                if ((Integer)worldIn.func_180495_p(new BlockPos(pos.func_177958_n(), pos.func_177956_o() + a, pos.func_177952_p())).func_177229_b((IProperty)STAGE) == 2) {
                    this.dropCorn(worldIn, new BlockPos(pos.func_177958_n(), pos.func_177956_o() + a, pos.func_177952_p()), worldIn.func_180495_p(new BlockPos(pos.func_177958_n(), pos.func_177956_o() + a, pos.func_177952_p())), this.wild);
                }
                worldIn.func_175698_g(new BlockPos(pos.func_177958_n(), pos.func_177956_o() + a, pos.func_177952_p()));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void makeGrown(World worldIn, BlockPos pos) {
        if (!this.grown) {
            for (int a = -4; a < 8; ++a) {
                try {
                    if (this.getCornHeight(worldIn, new BlockPos(pos.func_177958_n(), pos.func_177956_o() + a, pos.func_177952_p())) <= 0 || this.getCornHeight(worldIn, new BlockPos(pos.func_177958_n(), pos.func_177956_o() + a, pos.func_177952_p())) > 5 || (Integer)worldIn.func_180495_p(new BlockPos(pos.func_177958_n(), pos.func_177956_o() + a, pos.func_177952_p())).func_177229_b((IProperty)STAGE) == 0) continue;
                    this.setCornState(worldIn, new BlockPos(pos.func_177958_n(), pos.func_177956_o() + a, pos.func_177952_p()), 2, this.getCornHeight(worldIn, new BlockPos(pos.func_177958_n(), pos.func_177956_o() + a, pos.func_177952_p())));
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.grown = true;
            this.tag.func_74757_a("grown", true);
            this.tag.func_74768_a("height", this.height);
        }
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        entityIn.field_70159_w *= 0.6;
        entityIn.field_70179_y *= 0.6;
    }
}

