/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature;

import com.matez.wildnature.blocks.recipes.IronworksRecipeAdd;
import com.matez.wildnature.commands.WildNatureCommand;
import com.matez.wildnature.event.ChunkReplaceableBlocks;
import com.matez.wildnature.event.FogBiome;
import com.matez.wildnature.event.ReplaceBase;
import com.matez.wildnature.event.entityJoinEvent;
import com.matez.wildnature.event.playerJoinEvent;
import com.matez.wildnature.event.worldGenProgress;
import com.matez.wildnature.gui.tabs.wntab;
import com.matez.wildnature.gui.tabs.wntabunderground;
import com.matez.wildnature.init.BiomeInit;
import com.matez.wildnature.init.CraftingDictionary;
import com.matez.wildnature.init.FluidInit;
import com.matez.wildnature.init.ModBlocks;
import com.matez.wildnature.init.ModEntities;
import com.matez.wildnature.init.ModItems;
import com.matez.wildnature.util.IProxy;
import com.matez.wildnature.util.handlers.GuiHandler;
import com.matez.wildnature.util.handlers.SoundHandler;
import com.matez.wildnature.util.handlers.TileEntityHandler;
import com.matez.wildnature.worldgen.WorldGenSchematicTree;
import com.matez.wildnature.worldgen.generators.block.WorldGenBlocks;
import com.matez.wildnature.worldgen.generators.block.WorldGenOres;
import com.matez.wildnature.worldgen.schematics.trees.listAdapter;
import com.matez.wildnature.worldgen.type.WildNatureEXWorldType;
import com.matez.wildnature.worldgen.type.WildNatureWorldType;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketTitle;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;

@Mod(modid="wildnature", name="WildNature Mod", version="1.2", acceptedMinecraftVersions="[1.12.2]")
public class Main {
    public static String megaPrefix = TextFormatting.GREEN + "" + TextFormatting.BOLD + "[WildNature] " + TextFormatting.RESET + "" + TextFormatting.AQUA;
    public static WorldType WildNatureWORLDTYPE;
    public static WorldType ExperimentalWORLDTYPE;
    public static ArrayList<WorldGenSchematicTree> generatorList;
    public static ArrayList<Biome> biomeList;
    public static ArrayList<FogBiome> fogBiomeList;
    public static ArrayList<Biome> BiomesICY;
    public static ArrayList<Biome> BiomesWARM;
    public static ArrayList<Biome> BiomesCOOL;
    public static ArrayList<Biome> BiomesDESERT;
    public static ArrayList<ChunkReplaceableBlocks> replaceableBlocks;
    public static worldGenProgress worldGenProgress;
    public static ArrayList<Biome> mesaBiomes;
    public static ArrayList<Biome> mistyMountainsBiomes;
    public static ArrayList<Biome> volcanoBiomes;
    @Mod.Instance
    public static Main instance;
    @SidedProxy(clientSide="com.matez.wildnature.proxy.ClientProxy", serverSide="com.matez.wildnature.proxy.ServerProxy")
    public static IProxy proxy;
    public static final CreativeTabs mbtab;
    public static final CreativeTabs wnTabUnderground;

    @Mod.EventHandler
    public static void PreInit(FMLPreInitializationEvent event) {
        FMLCommonHandler.instance().bus().register((Object)new playerJoinEvent());
        FluidInit.registerFluid();
        proxy.preInit(event);
    }

    @Mod.EventHandler
    public static void init(FMLInitializationEvent event) {
        new listAdapter();
        SoundHandler.registerSounds();
        ModEntities.registerEntities();
        BiomeInit.registerBiomes();
        Main.addBiomeCategories();
        GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenOres(), (int)0);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenBlocks(), (int)1);
        TileEntityHandler.registerTileEntities();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new GuiHandler());
        GameRegistry.addSmelting((Item)ModItems.RAW_BOAR, (ItemStack)new ItemStack(ModItems.COOKED_BOAR), (float)2.0f);
        GameRegistry.addSmelting((Item)ModItems.RAW_GOAT, (ItemStack)new ItemStack(ModItems.COOKED_GOAT), (float)3.0f);
        GameRegistry.addSmelting((Item)ModItems.RAW_CAMEL, (ItemStack)new ItemStack(ModItems.COOKED_CAMEL), (float)4.0f);
        GameRegistry.addSmelting((Item)ModItems.RAW_BISON, (ItemStack)new ItemStack(ModItems.COOKED_BISON), (float)5.0f);
        GameRegistry.addSmelting((Block)Blocks.field_150322_A, (ItemStack)new ItemStack(ModBlocks.HARDENED_SANDSTONE), (float)1.0f);
        GameRegistry.addSmelting((Block)Blocks.field_180395_cM, (ItemStack)new ItemStack(ModBlocks.RED_HARDENED_SANDSTONE), (float)1.0f);
        GameRegistry.addSmelting((Block)ModBlocks.FROZEN_COBBLESTONE, (ItemStack)new ItemStack(ModBlocks.FROZEN_STONE), (float)1.0f);
        GameRegistry.addSmelting((Block)ModBlocks.SILVER_ORE, (ItemStack)new ItemStack(ModItems.SILVER_INGOT), (float)7.0f);
        new CraftingDictionary().registerAll();
        new IronworksRecipeAdd();
        proxy.init(event);
    }

    @Mod.EventHandler
    public static void PostInit(FMLPostInitializationEvent event) {
        WildNatureWORLDTYPE = new WildNatureWorldType("WildNature");
        ExperimentalWORLDTYPE = new WildNatureEXWorldType("WildNature EX");
        FMLCommonHandler.instance().bus().register((Object)new entityJoinEvent());
        proxy.postInit(event);
    }

    private static void addBiomeCategories() {
        Main.addBiomeList(BiomesICY, BiomeManager.BiomeType.ICY);
        Main.addBiomeList(BiomesCOOL, BiomeManager.BiomeType.COOL);
        Main.addBiomeList(BiomesWARM, BiomeManager.BiomeType.WARM);
        Main.addBiomeList(BiomesDESERT, BiomeManager.BiomeType.DESERT);
        BiomesICY.remove(BiomeInit.ROCKY_MOUNTAINS);
        BiomesDESERT.remove(BiomeInit.VOLCANO);
        BiomesDESERT.remove(BiomeInit.GRAND_CANYON);
        BiomesDESERT.remove(BiomeInit.LIGHT_MESA);
        BiomesDESERT.add(Main.getBiomeByName("desert"));
        BiomesDESERT.add(Main.getBiomeByName("desert_hills"));
        BiomesDESERT.add(Main.getBiomeByName("mutated_desert"));
        volcanoBiomes.add(BiomeInit.VOLCANO);
        mistyMountainsBiomes.add(BiomeInit.MISTY_MOUNTAINS);
        mesaBiomes.add(BiomeInit.LIGHT_MESA);
        mesaBiomes.add(BiomeInit.GRAND_CANYON);
        mesaBiomes.add(Main.getBiomeByName("mesa"));
        mesaBiomes.add(Main.getBiomeByName("mesa_rock"));
        mesaBiomes.add(Main.getBiomeByName("mesa_clear_rock"));
        mesaBiomes.add(Main.getBiomeByName("mutated_mesa"));
        mesaBiomes.add(Main.getBiomeByName("mutated_mesa_rock"));
        mesaBiomes.add(Main.getBiomeByName("mutated_mesa_clear_rock"));
        ArrayList<ReplaceBase> icyReplace = new ArrayList<ReplaceBase>();
        ArrayList<ReplaceBase> desertReplace = new ArrayList<ReplaceBase>();
        ArrayList<ReplaceBase> volcanoReplace = new ArrayList<ReplaceBase>();
        ArrayList<ReplaceBase> mistyMountainsReplace = new ArrayList<ReplaceBase>();
        ArrayList<ReplaceBase> mesaReplace = new ArrayList<ReplaceBase>();
        icyReplace.add(new ReplaceBase(Blocks.field_150348_b.func_176223_P(), ModBlocks.FROZEN_STONE.func_176223_P()));
        icyReplace.add(new ReplaceBase(Blocks.field_150346_d.func_176223_P(), ModBlocks.FROZEN_DIRT.func_176223_P()));
        desertReplace.add(new ReplaceBase(Blocks.field_150348_b.func_176223_P(), ModBlocks.HARDENED_SANDSTONE.func_176223_P()));
        desertReplace.add(new ReplaceBase(Blocks.field_150346_d.func_176223_P(), ModBlocks.ZIEMA_PUSTYNNA.func_176223_P()));
        mesaReplace.add(new ReplaceBase(Blocks.field_150348_b.func_176223_P(), ModBlocks.RED_HARDENED_SANDSTONE.func_176223_P()));
        volcanoReplace.add(new ReplaceBase(Blocks.field_150348_b.func_176223_P(), ModBlocks.ASH_BLOCK.func_176223_P()));
        mistyMountainsReplace.add(new ReplaceBase(Blocks.field_150348_b.func_176223_P(), ModBlocks.DARK_STONE.func_176223_P()));
        replaceableBlocks.add(new ChunkReplaceableBlocks(icyReplace, BiomesICY));
        replaceableBlocks.add(new ChunkReplaceableBlocks(desertReplace, BiomesDESERT));
        replaceableBlocks.add(new ChunkReplaceableBlocks(volcanoReplace, volcanoBiomes));
        replaceableBlocks.add(new ChunkReplaceableBlocks(mistyMountainsReplace, mistyMountainsBiomes));
        replaceableBlocks.add(new ChunkReplaceableBlocks(mesaReplace, mesaBiomes));
    }

    public static void sendMessage(EntityPlayer player, String message) {
        TextComponentString msg = new TextComponentString(message);
        player.func_145747_a((ITextComponent)msg);
    }

    public static void sendActionBar(EntityPlayer player, int ticks, String message) {
        TextComponentString msg = new TextComponentString(message);
        SPacketTitle title = new SPacketTitle(SPacketTitle.Type.ACTIONBAR, (ITextComponent)msg, 20, ticks, 70);
        EntityPlayerMP mp = (EntityPlayerMP)player;
        mp.field_71135_a.func_147359_a((Packet)title);
    }

    private static void addBiomeList(ArrayList<Biome> list, BiomeManager.BiomeType type) {
        for (int idk = 0; idk < BiomeManager.getBiomes((BiomeManager.BiomeType)type).size(); ++idk) {
            list.add(((BiomeManager.BiomeEntry)BiomeManager.getBiomes((BiomeManager.BiomeType)type).get((int)idk)).biome);
        }
    }

    @Nullable
    public static Biome getBiomeByName(String name) {
        List values = ForgeRegistries.BIOMES.getValues();
        for (int idk = 0; idk < values.size(); ++idk) {
            if (!((Biome)values.get(idk)).getRegistryName().func_110623_a().equals(name)) continue;
            return (Biome)values.get(idk);
        }
        return null;
    }

    @Mod.EventHandler
    public void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new WildNatureCommand());
    }

    public static int generateRandomInt(int min, int max) {
        if (min >= max) {
            throw new IllegalArgumentException("max must be greater than min");
        }
        Random r = new Random();
        return r.nextInt(max - min + 1) + min;
    }

    public static int generateRandomInt(int min, int max, Random rand) {
        if (min >= max) {
            throw new IllegalArgumentException("max must be greater than min");
        }
        return rand.nextInt(max - min + 1) + min;
    }

    public static List<Block> getNearBlockName(World world, BlockPos pos) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        ArrayList<Block> list = new ArrayList<Block>();
        list.add(world.func_180495_p(new BlockPos(x + 1, y, z)).func_177230_c());
        list.add(world.func_180495_p(new BlockPos(x - 1, y, z)).func_177230_c());
        list.add(world.func_180495_p(new BlockPos(x, y, z + 1)).func_177230_c());
        list.add(world.func_180495_p(new BlockPos(x, y, z - 1)).func_177230_c());
        list.add(world.func_180495_p(new BlockPos(x, y + 1, z)).func_177230_c());
        list.add(world.func_180495_p(new BlockPos(x, y - 1, z)).func_177230_c());
        return list;
    }

    public static List getNearBlockState(World world, BlockPos pos) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        ArrayList<IBlockState> list = new ArrayList<IBlockState>();
        list.add(world.func_180495_p(new BlockPos(x + 1, y, z)));
        list.add(world.func_180495_p(new BlockPos(x - 1, y, z)));
        list.add(world.func_180495_p(new BlockPos(x, y, z + 1)));
        list.add(world.func_180495_p(new BlockPos(x, y, z - 1)));
        list.add(world.func_180495_p(new BlockPos(x, y + 1, z)));
        list.add(world.func_180495_p(new BlockPos(x, y - 1, z)));
        return list;
    }

    public static List getNearBlockStateUpDown(World world, BlockPos pos) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        ArrayList<IBlockState> list = new ArrayList<IBlockState>();
        list.add(world.func_180495_p(new BlockPos(x, y + 1, z)));
        list.add(world.func_180495_p(new BlockPos(x, y - 1, z)));
        return list;
    }

    public static boolean isTheSameBlockNear(World world, BlockPos pos, boolean withState) {
        List<Block> listBlock = Main.getNearBlockName(world, pos);
        List listState = Main.getNearBlockState(world, pos);
        Block thisBlock = world.func_180495_p(pos).func_177230_c();
        IBlockState thisState = world.func_180495_p(pos);
        IBlockState thisBlockState = world.func_180495_p(pos);
        boolean sameBlockEIsNear = false;
        for (int listLoop = 0; listLoop < listBlock.size() && !sameBlockEIsNear; ++listLoop) {
            if (listBlock.get(listLoop) != thisBlock) continue;
            if (withState) {
                if (listState.get(listLoop) != thisState) continue;
                sameBlockEIsNear = true;
                break;
            }
            sameBlockEIsNear = true;
            break;
        }
        return sameBlockEIsNear;
    }

    public static String stringToRainbow(String parString, boolean parReturnToBlack) {
        int stringLength = parString.length();
        if (stringLength < 1) {
            return "";
        }
        String outputString = "";
        TextFormatting[] colorChar = new TextFormatting[]{TextFormatting.RED, TextFormatting.GOLD, TextFormatting.YELLOW, TextFormatting.GREEN, TextFormatting.AQUA, TextFormatting.BLUE, TextFormatting.LIGHT_PURPLE, TextFormatting.DARK_PURPLE};
        for (int i = 0; i < stringLength; ++i) {
            outputString = outputString + colorChar[i % 8] + parString.substring(i, i + 1);
        }
        if (parReturnToBlack) {
            return outputString + TextFormatting.BLACK;
        }
        return outputString + TextFormatting.WHITE;
    }

    public static String stringToGolden(String parString, int parShineLocation, boolean parReturnToBlack) {
        int stringLength = parString.length();
        if (stringLength < 1) {
            return "";
        }
        String outputString = "";
        for (int i = 0; i < stringLength; ++i) {
            outputString = ((long)(i + parShineLocation) + Minecraft.func_71386_F() / 20L) % 88L == 0L ? outputString + TextFormatting.WHITE + parString.substring(i, i + 1) : (((long)(i + parShineLocation) + Minecraft.func_71386_F() / 20L) % 88L == 1L ? outputString + TextFormatting.YELLOW + parString.substring(i, i + 1) : (((long)(i + parShineLocation) + Minecraft.func_71386_F() / 20L) % 88L == 87L ? outputString + TextFormatting.YELLOW + parString.substring(i, i + 1) : outputString + TextFormatting.GOLD + parString.substring(i, i + 1)));
        }
        if (parReturnToBlack) {
            return outputString + TextFormatting.BLACK;
        }
        return outputString + TextFormatting.WHITE;
    }

    public static boolean isTheSameBlockNear(IBlockState thisBlock, World world, BlockPos pos, boolean withState) {
        List<Block> listBlock = Main.getNearBlockName(world, pos);
        List listState = Main.getNearBlockState(world, pos);
        IBlockState thisState = world.func_180495_p(pos);
        IBlockState thisBlockState = world.func_180495_p(pos);
        boolean sameBlockEIsNear = false;
        for (int listLoop = 0; listLoop < listBlock.size() && !sameBlockEIsNear; ++listLoop) {
            if (listBlock.get(listLoop) != thisBlock) continue;
            if (withState) {
                if (listState.get(listLoop) != thisState) continue;
                sameBlockEIsNear = true;
                break;
            }
            sameBlockEIsNear = true;
            break;
        }
        return sameBlockEIsNear;
    }

    public static boolean isWaterCorrect(BlockPos waterBlock, World worldIn, ChunkPrimer chunkPrimer, IBlockState replace, IBlockState riverBottom) {
        try {
            int a;
            boolean does;
            boolean toReturn = true;
            ArrayList<EnumFacing> facings = new ArrayList<EnumFacing>();
            if (worldIn.func_180495_p(waterBlock.func_177984_a()).func_177230_c().equals(Blocks.field_150350_a)) {
                if (worldIn.func_180495_p(waterBlock.func_177968_d()).func_177230_c().equals(Blocks.field_150350_a)) {
                    facings.add(EnumFacing.SOUTH);
                }
                if (worldIn.func_180495_p(waterBlock.func_177978_c()).func_177230_c().equals(Blocks.field_150350_a)) {
                    facings.add(EnumFacing.NORTH);
                }
                if (worldIn.func_180495_p(waterBlock.func_177974_f()).func_177230_c().equals(Blocks.field_150350_a)) {
                    facings.add(EnumFacing.EAST);
                }
                if (worldIn.func_180495_p(waterBlock.func_177976_e()).func_177230_c().equals(Blocks.field_150350_a)) {
                    facings.add(EnumFacing.WEST);
                }
            }
            if (worldIn.func_180495_p((waterBlock = waterBlock.func_177977_b()).func_177968_d()).func_177230_c().equals(Blocks.field_150355_j) || worldIn.func_180495_p(waterBlock.func_177968_d()).func_177230_c().equals(Blocks.field_150358_i)) {
                facings.remove(EnumFacing.SOUTH);
            }
            if (worldIn.func_180495_p(waterBlock.func_177978_c()).func_177230_c().equals(Blocks.field_150355_j) || worldIn.func_180495_p(waterBlock.func_177968_d()).func_177230_c().equals(Blocks.field_150358_i)) {
                facings.remove(EnumFacing.NORTH);
            }
            if (worldIn.func_180495_p(waterBlock.func_177974_f()).func_177230_c().equals(Blocks.field_150355_j) || worldIn.func_180495_p(waterBlock.func_177968_d()).func_177230_c().equals(Blocks.field_150358_i)) {
                facings.remove(EnumFacing.EAST);
            }
            if (worldIn.func_180495_p(waterBlock.func_177976_e()).func_177230_c().equals(Blocks.field_150355_j) || worldIn.func_180495_p(waterBlock.func_177968_d()).func_177230_c().equals(Blocks.field_150358_i)) {
                facings.remove(EnumFacing.WEST);
            }
            if (facings.contains(EnumFacing.NORTH)) {
                does = false;
                for (a = 0; a < 8; ++a) {
                    if (worldIn.func_180495_p(waterBlock.func_177978_c().func_177979_c(a)).func_177230_c().equals(Blocks.field_150355_j) || worldIn.func_180495_p(waterBlock.func_177978_c().func_177979_c(a)).func_177230_c().equals(Blocks.field_150358_i)) continue;
                    does = true;
                    toReturn = false;
                }
                if (does) {
                    chunkPrimer.func_177855_a(waterBlock.func_177978_c().func_177958_n(), waterBlock.func_177978_c().func_177956_o(), waterBlock.func_177978_c().func_177952_p(), replace);
                }
            }
            if (facings.contains(EnumFacing.SOUTH)) {
                does = false;
                for (a = 0; a < 8; ++a) {
                    if (worldIn.func_180495_p(waterBlock.func_177968_d().func_177979_c(a)).func_177230_c().equals(Blocks.field_150355_j) || worldIn.func_180495_p(waterBlock.func_177968_d().func_177979_c(a)).func_177230_c().equals(Blocks.field_150358_i)) continue;
                    does = true;
                    toReturn = false;
                }
                if (does) {
                    chunkPrimer.func_177855_a(waterBlock.func_177968_d().func_177958_n(), waterBlock.func_177968_d().func_177956_o(), waterBlock.func_177968_d().func_177952_p(), replace);
                }
            }
            if (facings.contains(EnumFacing.EAST)) {
                does = false;
                for (a = 0; a < 8; ++a) {
                    if (worldIn.func_180495_p(waterBlock.func_177974_f().func_177979_c(a)).func_177230_c().equals(Blocks.field_150355_j) || worldIn.func_180495_p(waterBlock.func_177974_f().func_177979_c(a)).func_177230_c().equals(Blocks.field_150358_i)) continue;
                    does = true;
                    toReturn = false;
                }
                if (does) {
                    chunkPrimer.func_177855_a(waterBlock.func_177974_f().func_177958_n(), waterBlock.func_177974_f().func_177956_o(), waterBlock.func_177974_f().func_177952_p(), replace);
                }
            }
            if (facings.contains(EnumFacing.WEST)) {
                does = false;
                for (a = 0; a < 8; ++a) {
                    if (worldIn.func_180495_p(waterBlock.func_177976_e().func_177979_c(a)).func_177230_c().equals(Blocks.field_150355_j) || worldIn.func_180495_p(waterBlock.func_177976_e().func_177979_c(a)).func_177230_c().equals(Blocks.field_150358_i)) continue;
                    does = true;
                    toReturn = false;
                }
                if (does) {
                    chunkPrimer.func_177855_a(waterBlock.func_177976_e().func_177958_n(), waterBlock.func_177976_e().func_177956_o(), waterBlock.func_177976_e().func_177952_p(), replace);
                }
            }
            return toReturn;
        }
        catch (Exception e) {
            return true;
        }
    }

    public static boolean isTheSameBlockNearUpDown(IBlockState thisBlock, World world, BlockPos pos) {
        IBlockState UP = world.func_180495_p(pos.func_177984_a());
        IBlockState DOWN = world.func_180495_p(pos.func_177977_b());
        boolean isNearUP = false;
        boolean isNearDOWN = false;
        isNearUP = UP.equals(thisBlock);
        isNearDOWN = DOWN.equals(thisBlock);
        if (isNearUP) {
            return true;
        }
        return isNearDOWN;
    }

    public static IBlockState getStateForSameNearBlock(World world, BlockPos pos) {
        List<Block> listBlock = Main.getNearBlockName(world, pos);
        List listState = Main.getNearBlockState(world, pos);
        Block thisBlock = world.func_180495_p(pos).func_177230_c();
        IBlockState thisState = world.func_180495_p(pos);
        IBlockState thisBlockState = world.func_180495_p(pos);
        for (int listLoop = 0; listLoop < listBlock.size(); ++listLoop) {
            if (listBlock.get(listLoop) != thisBlock) continue;
            return (IBlockState)listState.get(listLoop);
        }
        return null;
    }

    public static Block getBlockAt(World world, BlockPos pos) {
        Block thisBlock = world.func_180495_p(pos).func_177230_c();
        return thisBlock;
    }

    public static ArrayList<BlockPos> generateNaturalLeaves(BlockPos startPos, int X, int Y, int Z, IBlockState blockstate) {
        ArrayList<BlockPos> posList = new ArrayList<BlockPos>();
        boolean whileCounter = false;
        posList.add(new BlockPos((Vec3i)startPos));
        return posList;
    }

    static {
        generatorList = new ArrayList();
        biomeList = new ArrayList();
        fogBiomeList = new ArrayList();
        BiomesICY = new ArrayList();
        BiomesWARM = new ArrayList();
        BiomesCOOL = new ArrayList();
        BiomesDESERT = new ArrayList();
        replaceableBlocks = new ArrayList();
        mesaBiomes = new ArrayList();
        mistyMountainsBiomes = new ArrayList();
        volcanoBiomes = new ArrayList();
        FluidRegistry.enableUniversalBucket();
        mbtab = new wntab("WildNature");
        wnTabUnderground = new wntabunderground("WildNature Underground");
    }
}

