/*
 * Decompiled with CFR 0.152.
 */
package com.trforcex.mods.wallpapercraft.util;

import com.trforcex.mods.wallpapercraft.blocks.base.BaseModBlock;
import com.trforcex.mods.wallpapercraft.blocks.base.ScrollingType;
import com.trforcex.mods.wallpapercraft.items.MetaItemBlock;
import net.minecraft.block.Block;
import net.minecraft.item.Item;

public class ModHelper {
    public static String makeUnlocalizedName(Item item) {
        return "wallpapercraft." + item.getRegistryName().func_110623_a();
    }

    public static String makeUnlocalizedName(Block block) {
        return "wallpapercraft." + block.getRegistryName().func_110623_a();
    }

    public static int getMetaItemBlockMaxMeta(Item item) {
        if (item instanceof MetaItemBlock) {
            return ((MetaItemBlock)item).getMaxMeta();
        }
        throw new IllegalArgumentException("Cannot get maxMeta for non-MetaItemBlock item " + item.func_77658_a());
    }

    public static ForestryCheckResult checkIfForestryBlock(Item item) {
        String domain = item.getRegistryName().func_110624_b();
        String path = item.getRegistryName().func_110623_a();
        if ("forestry".equals(domain)) {
            if ("planks.1".equals(path)) {
                return ForestryCheckResult.ForestryPlanks1;
            }
            if ("planks.0".equals(path)) {
                return ForestryCheckResult.ForestryPlanks0;
            }
            if ("planks.fireproof.0".equals(path)) {
                return ForestryCheckResult.ForestryFireproofPlanks0;
            }
            if ("planks.fireproof.1".equals(path)) {
                return ForestryCheckResult.ForestryFireproofPlanks1;
            }
        }
        return ForestryCheckResult.NonForestry;
    }

    public static ForestryCheckResult checkIfForestryBlock(Block block) {
        String domain = block.getRegistryName().func_110624_b();
        String path = block.getRegistryName().func_110623_a();
        if ("forestry".equals(domain)) {
            if ("planks.1".equals(path)) {
                return ForestryCheckResult.ForestryPlanks1;
            }
            if ("planks.0".equals(path)) {
                return ForestryCheckResult.ForestryPlanks0;
            }
            if ("planks.fireproof.0".equals(path)) {
                return ForestryCheckResult.ForestryFireproofPlanks0;
            }
            if ("planks.fireproof.1".equals(path)) {
                return ForestryCheckResult.ForestryFireproofPlanks1;
            }
        }
        return ForestryCheckResult.NonForestry;
    }

    public static int getGroupOfFcBlock(Block block) {
        if (block instanceof BaseModBlock && ((BaseModBlock)block).getScrollingType() == ScrollingType.ForestryCompatible) {
            String path = block.getRegistryName().func_110623_a();
            String[] parts = path.split("_");
            return Integer.parseInt(parts[parts.length - 1]);
        }
        throw new IllegalArgumentException("Given block is not a FC block!");
    }

    public static enum ForestryCheckResult {
        ForestryPlanks0,
        ForestryPlanks1,
        ForestryFireproofPlanks0,
        ForestryFireproofPlanks1,
        NonForestry;

    }
}

