/*
 * Decompiled with CFR 0.152.
 */
package com.trforcex.mods.wallpapercraft.util;

import com.trforcex.mods.wallpapercraft.ModClass;
import net.minecraft.item.ItemStack;

public class Logger {
    private static int maxLogLevel = 0;
    private static boolean useInfoInsteadOfDebug = false;

    public static void setMaxLogLevel(int newLogLevel) {
        if (maxLogLevel == 1 || maxLogLevel == 2 || maxLogLevel == 0) {
            maxLogLevel = newLogLevel;
        }
    }

    public static int getMaxLogLevel() {
        return maxLogLevel;
    }

    public static boolean getUseInfoInsteadOfDebug() {
        return useInfoInsteadOfDebug;
    }

    public static void setUseInfoInsteadOfDebug(boolean useInfoInsteadOfDebug) {
        Logger.useInfoInsteadOfDebug = useInfoInsteadOfDebug;
    }

    public static void logDebug(String message) {
        Logger.log(1, message);
    }

    public static void logVerbose(String message) {
        Logger.log(2, message);
    }

    private static void log(int level, String message) {
        if (maxLogLevel != 0) {
            if (level == 1 && maxLogLevel > 0) {
                if (useInfoInsteadOfDebug) {
                    ModClass.logger.info("[debug]: " + message);
                } else {
                    ModClass.logger.debug(": " + message);
                }
            } else if (level == 2 && maxLogLevel > 1) {
                if (useInfoInsteadOfDebug) {
                    ModClass.logger.info("[verbose]: " + message);
                } else {
                    ModClass.logger.debug("[verbose]: " + message);
                }
            }
        }
    }

    public static void logDev(int level, int type, String message) {
    }

    public static String getStackInfo(ItemStack stack) {
        return "x" + stack.func_190916_E() + " of " + stack.func_82833_r() + "[" + stack.func_77973_b().getRegistryName() + "], meta: " + stack.func_77960_j() + " (damage: " + stack.func_77952_i() + ");";
    }

    public static void stubMethod() {
    }
}

