/*
 * Decompiled with CFR 0.152.
 */
package com.trforcex.mods.wallpapercraft.network;

import com.trforcex.mods.wallpapercraft.network.BaseMetaScrollingMessage;
import com.trforcex.mods.wallpapercraft.util.ModHelper;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class ForestryPlanksScrollingMessage
extends BaseMetaScrollingMessage {
    public ForestryPlanksScrollingMessage() {
    }

    public ForestryPlanksScrollingMessage(boolean shouldIncreaseMeta) {
        super(shouldIncreaseMeta);
    }

    public static class Handler
    implements IMessageHandler<ForestryPlanksScrollingMessage, IMessage> {
        public IMessage onMessage(ForestryPlanksScrollingMessage message, MessageContext ctx) {
            EntityPlayerMP serverPlayer = ctx.getServerHandler().field_147369_b;
            ItemStack heldStack = serverPlayer.func_184614_ca();
            ModHelper.ForestryCheckResult checkResult = ModHelper.checkIfForestryBlock(heldStack.func_77973_b());
            if (!heldStack.func_190926_b() && checkResult != ModHelper.ForestryCheckResult.NonForestry) {
                serverPlayer.func_184611_a(EnumHand.MAIN_HAND, Handler.getOutputStack(message, heldStack, checkResult));
            }
            return null;
        }

        private static ItemStack getOutputStack(ForestryPlanksScrollingMessage message, ItemStack heldStack, ModHelper.ForestryCheckResult result) {
            int stackMeta = heldStack.func_77960_j();
            int maxMeta = result == ModHelper.ForestryCheckResult.ForestryPlanks0 || result == ModHelper.ForestryCheckResult.ForestryFireproofPlanks0 ? 15 : 12;
            int newMeta = MathHelper.func_76125_a((int)(stackMeta + (message.shouldIncreaseMeta ? 1 : -1)), (int)0, (int)maxMeta);
            Block outBlock = null;
            if (stackMeta == newMeta && (stackMeta == maxMeta || stackMeta == 0)) {
                switch (result) {
                    case ForestryPlanks0: {
                        outBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("forestry", "planks.1"));
                        break;
                    }
                    case ForestryPlanks1: {
                        outBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("forestry", "planks.0"));
                        break;
                    }
                    case ForestryFireproofPlanks0: {
                        outBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("forestry", "planks.fireproof.1"));
                        break;
                    }
                    case ForestryFireproofPlanks1: {
                        outBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("forestry", "planks.fireproof.0"));
                    }
                }
            }
            if (stackMeta == newMeta) {
                if (newMeta == maxMeta) {
                    return new ItemStack(outBlock, heldStack.func_190916_E(), 0);
                }
                if (newMeta == 0) {
                    return new ItemStack(outBlock, heldStack.func_190916_E(), maxMeta);
                }
            }
            return new ItemStack(heldStack.func_77973_b(), heldStack.func_190916_E(), newMeta);
        }
    }
}

