/*
 * Decompiled with CFR 0.152.
 */
package com.trforcex.mods.wallpapercraft.network;

import com.trforcex.mods.wallpapercraft.blocks.base.BaseModBlock;
import com.trforcex.mods.wallpapercraft.blocks.base.IHasMetaItemBlock;
import com.trforcex.mods.wallpapercraft.blocks.base.ScrollingType;
import com.trforcex.mods.wallpapercraft.items.MetaItemBlock;
import com.trforcex.mods.wallpapercraft.network.BaseMetaScrollingMessage;
import com.trforcex.mods.wallpapercraft.util.ModHelper;
import com.trforcex.mods.wallpapercraft.util.RecipeHelper;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class ForestryCompatibleBlockScrollingMessage
extends BaseMetaScrollingMessage {
    public ForestryCompatibleBlockScrollingMessage() {
    }

    public ForestryCompatibleBlockScrollingMessage(boolean shouldIncreaseMeta) {
        super(shouldIncreaseMeta);
    }

    public static class Handler
    implements IMessageHandler<ForestryCompatibleBlockScrollingMessage, IMessage> {
        public IMessage onMessage(ForestryCompatibleBlockScrollingMessage message, MessageContext ctx) {
            EntityPlayerMP serverPlayer = ctx.getServerHandler().field_147369_b;
            ItemStack heldStack = serverPlayer.func_184614_ca();
            if (!heldStack.func_190926_b() && ((MetaItemBlock)heldStack.func_77973_b()).getScrollingType() == ScrollingType.ForestryCompatible) {
                serverPlayer.func_184611_a(EnumHand.MAIN_HAND, Handler.getOutputStack(message, heldStack));
            }
            return null;
        }

        static ItemStack getOutputStack(ForestryCompatibleBlockScrollingMessage message, ItemStack heldStack) {
            BaseModBlock block = (BaseModBlock)Block.func_149634_a((Item)heldStack.func_77973_b());
            int stackMeta = heldStack.func_77960_j();
            int maxMeta = block.getMaxMeta();
            int newMeta = MathHelper.func_76125_a((int)(stackMeta + (message.shouldIncreaseMeta ? 1 : -1)), (int)0, (int)maxMeta);
            Block outBlock = null;
            if (stackMeta == newMeta && (stackMeta == maxMeta || stackMeta == 0)) {
                switch (ModHelper.getGroupOfFcBlock(block)) {
                    case 1: {
                        outBlock = (Block)ForgeRegistries.BLOCKS.getValue(RecipeHelper.getModResLoc(block.getPattern(), "2"));
                        break;
                    }
                    case 2: {
                        outBlock = (Block)ForgeRegistries.BLOCKS.getValue(RecipeHelper.getModResLoc(block.getPattern(), "1"));
                    }
                }
            }
            if (stackMeta == newMeta) {
                if (newMeta == maxMeta) {
                    return new ItemStack(outBlock, heldStack.func_190916_E(), 0);
                }
                if (newMeta == 0) {
                    return new ItemStack(outBlock, heldStack.func_190916_E(), ((IHasMetaItemBlock)outBlock).getMaxMeta());
                }
            }
            return new ItemStack(heldStack.func_77973_b(), heldStack.func_190916_E(), newMeta);
        }
    }
}

