/*
 * Decompiled with CFR 0.152.
 */
package com.trforcex.mods.wallpapercraft.items;

import com.trforcex.mods.wallpapercraft.ModConfig;
import com.trforcex.mods.wallpapercraft.blocks.base.BaseModBlock;
import com.trforcex.mods.wallpapercraft.blocks.base.IHasMetaItemBlock;
import com.trforcex.mods.wallpapercraft.blocks.base.ScrollingType;
import com.trforcex.mods.wallpapercraft.init.ModCreativeTab;
import com.trforcex.mods.wallpapercraft.init.ModKeybinds;
import com.trforcex.mods.wallpapercraft.items.HintType;
import com.trforcex.mods.wallpapercraft.items.IScrollable;
import com.trforcex.mods.wallpapercraft.util.ModHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;

public class MetaItemBlock
extends ItemBlock
implements IScrollable {
    public MetaItemBlock(Block block) {
        super(block);
        if (!(block instanceof IHasMetaItemBlock)) {
            throw new IllegalArgumentException("Block \"" + block.func_149739_a() + "\" is not supposed to have MetaItemBlock!");
        }
        this.func_77656_e(0);
        this.func_77627_a(true);
        this.setRegistryName(block.getRegistryName());
        this.func_77655_b(ModHelper.makeUnlocalizedName((Item)this));
        this.func_77637_a(ModCreativeTab.WPC_TAB);
    }

    public void initModel() {
        for (int i = 0; i <= ((IHasMetaItemBlock)this.field_150939_a).getMaxMeta(); ++i) {
            ModelResourceLocation model = new ModelResourceLocation(this.field_150939_a.getRegistryName(), "variant=" + i);
            ModelLoader.setCustomModelResourceLocation((Item)this, (int)i, (ModelResourceLocation)model);
        }
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77667_c(stack) + "_" + stack.func_77960_j();
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (ModConfig.enableTooltipHints) {
            tooltip.add(I18n.func_135052_a((String)"tooltip.wallpapercraft.part_1", (Object[])new Object[0]) + ModKeybinds.metaScrollKey.getDisplayName() + I18n.func_135052_a((String)"tooltip.wallpapercraft.part_2", (Object[])new Object[0]));
            tooltip.add(I18n.func_135052_a((String)"tooltip.wallpapercraft.part_3", (Object[])new Object[0]));
            if (MetaItemBlock.getHintType(stack) == HintType.Forestry) {
                tooltip.add(I18n.func_135052_a((String)"tooltip.wallpapercraft.forestry_hint", (Object[])new Object[0]));
            }
        }
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        for (int i = 0; i <= ((IHasMetaItemBlock)this.field_150939_a).getMaxMeta(); ++i) {
            ItemStack newStack = new ItemStack((Item)this, 1, i);
            if (!this.func_194125_a(tab)) continue;
            items.add((Object)newStack);
        }
    }

    public int func_77647_b(int damage) {
        return damage;
    }

    public int getMaxMeta() {
        return ((IHasMetaItemBlock)this.field_150939_a).getMaxMeta();
    }

    @Override
    public ScrollingType getScrollingType() {
        return ((BaseModBlock)this.field_150939_a).getScrollingType();
    }

    private static HintType getHintType(ItemStack stack) {
        if (((MetaItemBlock)stack.func_77973_b()).getScrollingType() == ScrollingType.ForestryCompatible && stack.func_77960_j() != 0) {
            return HintType.Forestry;
        }
        return HintType.General;
    }
}

