/*
 * Decompiled with CFR 0.152.
 */
package com.trforcex.mods.wallpapercraft.items;

import com.trforcex.mods.wallpapercraft.ModConfig;
import com.trforcex.mods.wallpapercraft.init.ModCreativeTab;
import com.trforcex.mods.wallpapercraft.init.ModItems;
import com.trforcex.mods.wallpapercraft.util.ModDataManager;
import com.trforcex.mods.wallpapercraft.util.RecipeHelper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ColoredPaste
extends Item {
    private static final int MAX_DURABILITY = ModConfig.crafting.maxColoredPasteUsages - 1;
    public static final String KEY = "durability";

    public ColoredPaste() {
        this.setRegistryName("colored_paste");
        this.func_77656_e(0);
        this.func_77627_a(true);
        this.func_77625_d(1);
        this.func_77637_a(ModCreativeTab.WPC_TAB);
        ModItems.ITEMS.add(this);
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ArrayList<ModelResourceLocation> modelsResLocs = new ArrayList<ModelResourceLocation>();
        for (int i = 0; i < 8; ++i) {
            String color = ModDataManager.COLORS.get(i);
            ModelResourceLocation modelResLoc = new ModelResourceLocation(RecipeHelper.getModResLoc("colored_paste", color), "inventory");
            modelsResLocs.add(modelResLoc);
        }
        final ModelResourceLocation[] names = modelsResLocs.toArray(new ModelResourceLocation[0]);
        ModelLoader.registerItemVariants((Item)this, (ResourceLocation[])names);
        ModelLoader.setCustomMeshDefinition((Item)this, (ItemMeshDefinition)new ItemMeshDefinition(){

            public ModelResourceLocation func_178113_a(ItemStack stack) {
                int meta = stack.func_77960_j();
                if (meta <= 7) {
                    return names[meta];
                }
                return null;
            }
        });
    }

    public ItemStack getContainerItem(ItemStack itemStack) {
        int usesLeft = this.getUsesLeft(itemStack);
        if (usesLeft == 0) {
            return ItemStack.field_190927_a;
        }
        NBTTagCompound nbt = itemStack.func_77978_p();
        if (nbt != null) {
            nbt.func_74768_a(KEY, usesLeft - 1);
        } else {
            nbt = new NBTTagCompound();
            nbt.func_74768_a(KEY, usesLeft - 1);
        }
        ItemStack stack = new ItemStack(itemStack.func_77973_b(), itemStack.func_190916_E(), itemStack.func_77960_j());
        stack.func_77982_d(nbt);
        return stack;
    }

    public boolean func_77634_r() {
        return true;
    }

    public int getDamage(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return 0;
        }
        int durability = stack.func_77978_p().func_74762_e(KEY);
        if (durability >= MAX_DURABILITY) {
            return 0;
        }
        return MAX_DURABILITY - durability;
    }

    public int func_77647_b(int damage) {
        return damage;
    }

    public boolean isDamaged(ItemStack stack) {
        return this.getUsesLeft(stack) < MAX_DURABILITY;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - (double)this.getUsesLeft(stack) / (double)MAX_DURABILITY;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.getUsesLeft(stack) < MAX_DURABILITY;
    }

    public String func_77667_c(ItemStack stack) {
        return "item.wallpapercraft.colored_paste_" + stack.func_77960_j();
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add("Uses left: " + (this.getUsesLeft(stack) + 1));
        if (ModConfig.enableTooltipHints) {
            tooltip.add(I18n.func_135052_a((String)"tooltip.wallpapercraft.paste_hint", (Object[])new Object[0]));
            tooltip.add(I18n.func_135052_a((String)"tooltip.wallpapercraft.paste_hint_2", (Object[])new Object[0]));
        }
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            for (int i = 0; i < 8; ++i) {
                ItemStack stack = new ItemStack((Item)this, 1, i);
                items.add((Object)stack);
            }
        }
    }

    private int getUsesLeft(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt != null && nbt.func_74764_b(KEY)) {
            return nbt.func_74762_e(KEY);
        }
        return MAX_DURABILITY;
    }

    public static String getColor(ItemStack pasteStack) {
        if (pasteStack.func_77973_b() instanceof ColoredPaste) {
            return ModDataManager.COLORS.get(pasteStack.func_77960_j());
        }
        return "";
    }
}

