/*
 * Decompiled with CFR 0.152.
 */
package com.trforcex.mods.wallpapercraft.crafting;

import com.trforcex.mods.wallpapercraft.ModClass;
import com.trforcex.mods.wallpapercraft.ModConfig;
import com.trforcex.mods.wallpapercraft.init.ModItems;
import com.trforcex.mods.wallpapercraft.items.ColoredPaste;
import com.trforcex.mods.wallpapercraft.util.RecipeHelper;
import javax.annotation.Nullable;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class PasteCombinationRecipe
implements IRecipe {
    public static final PasteCombinationRecipe INSTANCE = new PasteCombinationRecipe();
    private static final int maxDurability = ModConfig.crafting.maxColoredPasteUsages - 1;

    public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
        int durabilityB;
        int durabilityA;
        int pasteStacks = 0;
        ItemStack stackA = ItemStack.field_190927_a;
        ItemStack stackB = ItemStack.field_190927_a;
        for (int slot = 0; slot < inv.func_70302_i_(); ++slot) {
            ItemStack slotStack = inv.func_70301_a(slot);
            if (slotStack.func_77973_b() instanceof ColoredPaste) {
                ++pasteStacks;
                if (stackA.func_190926_b()) {
                    stackA = slotStack;
                    continue;
                }
                stackB = slotStack;
                continue;
            }
            if (slotStack.func_190926_b()) continue;
            return false;
        }
        try {
            durabilityA = stackA.func_77942_o() ? stackA.func_77978_p().func_74762_e("durability") : maxDurability;
            durabilityB = stackB.func_77942_o() ? stackB.func_77978_p().func_74762_e("durability") : maxDurability;
        }
        catch (NullPointerException e) {
            ModClass.logger.error("Cannot get durability of colored paste paste stack", (Throwable)e);
            return false;
        }
        boolean colorMatch = ColoredPaste.getColor(stackA).equals(ColoredPaste.getColor(stackB));
        return pasteStacks == 2 && colorMatch && durabilityA + durabilityB <= maxDurability;
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        ItemStack pasteStack1 = ItemStack.field_190927_a;
        ItemStack pasteStack2 = ItemStack.field_190927_a;
        for (int slot = 0; slot < inv.func_70302_i_(); ++slot) {
            ItemStack slotStack = inv.func_70301_a(slot);
            if (!(slotStack.func_77973_b() instanceof ColoredPaste)) continue;
            if (pasteStack1.func_190926_b()) {
                pasteStack1 = slotStack;
                continue;
            }
            pasteStack2 = slotStack;
        }
        if (!pasteStack1.func_190926_b() && !pasteStack2.func_190926_b()) {
            int usesLeft = MathHelper.func_76125_a((int)(pasteStack1.func_77978_p().func_74762_e("durability") + pasteStack2.func_77978_p().func_74762_e("durability") + 1), (int)0, (int)maxDurability);
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74768_a("durability", usesLeft);
            return RecipeHelper.getStack((Object)ModItems.itemColoredPaste, 1, pasteStack1.func_77960_j(), nbt);
        }
        return ItemStack.field_190927_a;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 2;
    }

    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public IRecipe setRegistryName(ResourceLocation name) {
        return this;
    }

    @Nullable
    public ResourceLocation getRegistryName() {
        return RecipeHelper.getModResLoc("paste_combine_recipe");
    }

    public Class<IRecipe> getRegistryType() {
        return IRecipe.class;
    }

    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
        return NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
    }
}

