/*
 * Decompiled with CFR 0.152.
 */
package com.trforcex.mods.wallpapercraft.compatibility;

import com.trforcex.mods.wallpapercraft.util.Logger;
import com.trforcex.mods.wallpapercraft.util.ModDataManager;
import com.trforcex.mods.wallpapercraft.util.RecipeHelper;
import java.util.Collections;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class OreDictCompatibility {
    public static void registerModBlocksToOredict() {
        for (String color : ModDataManager.COLORS) {
            ItemStack woolStack = RecipeHelper.getStack(RecipeHelper.getModBlock("wool", color), 1, Short.MAX_VALUE);
            ItemStack checkeredWoolStack = RecipeHelper.getStack(RecipeHelper.getModBlock("checkered_wool", color), 1, Short.MAX_VALUE);
            ItemStack woodPlanksStack = RecipeHelper.getStack(RecipeHelper.getModBlock("wood_planks", color), 1, Short.MAX_VALUE);
            ItemStack woolCarpetStack = RecipeHelper.getStack(RecipeHelper.getModBlock("wool_carpet", color), 1, Short.MAX_VALUE);
            ItemStack checkeredWoolCarpetStack = RecipeHelper.getStack(RecipeHelper.getModBlock("checkered_carpet", color), 1, Short.MAX_VALUE);
            OreDictionary.registerOre((String)"blockWool", (ItemStack)woolStack);
            OreDictionary.registerOre((String)"blockWool", (ItemStack)checkeredWoolStack);
            OreDictionary.registerOre((String)"blockCarpet", (ItemStack)woolCarpetStack);
            OreDictionary.registerOre((String)"blockCarpet", (ItemStack)checkeredWoolCarpetStack);
            OreDictionary.registerOre((String)"plankWood", (ItemStack)woodPlanksStack);
        }
        Logger.logDebug("Registered mod blocks to OreDict");
    }

    public static void registerVanillaToOredict() {
        int WOOL_ID = OreDictionary.getOreID((String)"blockWool");
        int WOOD_ID = OreDictionary.getOreID((String)"plankWood");
        int HARDENED_CLAY_ID = OreDictionary.getOreID((String)"hardenedClay");
        ItemStack woolStack = new ItemStack(Blocks.field_150325_L, 1, Short.MAX_VALUE);
        ItemStack woodStack = new ItemStack(Blocks.field_150344_f, 1, Short.MAX_VALUE);
        ItemStack clayStack = new ItemStack(Blocks.field_150405_ch, 1, Short.MAX_VALUE);
        if (!Collections.singletonList(OreDictionary.getOreIDs((ItemStack)woolStack)).contains(WOOL_ID)) {
            OreDictionary.registerOre((String)"blockWool", (ItemStack)woolStack);
        }
        if (!Collections.singletonList(OreDictionary.getOreIDs((ItemStack)woodStack)).contains(WOOD_ID)) {
            OreDictionary.registerOre((String)"plankWood", (ItemStack)woodStack);
        }
        if (!Collections.singletonList(OreDictionary.getOreIDs((ItemStack)clayStack)).contains(HARDENED_CLAY_ID)) {
            OreDictionary.registerOre((String)"hardenedClay", (ItemStack)clayStack);
        }
        Logger.logDebug("Registered vanilla to OreDict");
    }
}

