/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity.effects;

import com.bobmowzie.mowziesmobs.client.particles.ParticleFallingBlock;
import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntityRing;
import com.bobmowzie.mowziesmobs.server.potion.PotionHandler;
import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.Potion;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityBoulder
extends Entity {
    int blockId;
    private EntityLivingBase caster;
    private boolean travelling;
    public IBlockState storedBlock;
    private static final DataParameter<Optional<IBlockState>> BLOCK_STATE = EntityDataManager.func_187226_a(EntityBoulder.class, (DataSerializer)DataSerializers.field_187197_g);
    private static final DataParameter<Boolean> SHOULD_EXPLODE = EntityDataManager.func_187226_a(EntityBoulder.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<BlockPos> ORIGIN = EntityDataManager.func_187226_a(EntityBoulder.class, (DataSerializer)DataSerializers.field_187200_j);
    private static final DataParameter<Integer> DEATH_TIME = EntityDataManager.func_187226_a(EntityBoulder.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> SIZE = EntityDataManager.func_187226_a(EntityBoulder.class, (DataSerializer)DataSerializers.field_187192_b);
    public float animationOffset = 0.0f;
    private List<Entity> ridingEntities = new ArrayList<Entity>();
    public int boulderSize = 0;
    private float speed = 1.5f;
    private int damage = 8;
    private int finishedRisingTick = 4;

    public EntityBoulder(World world) {
        super(world);
        this.func_70105_a(10.0f, 10.0f);
        this.travelling = false;
        this.damage = 8;
        this.finishedRisingTick = 4;
        this.animationOffset = this.field_70146_Z.nextFloat() * 8.0f;
        this.setOrigin(new BlockPos((Entity)this));
    }

    public EntityBoulder(World world, EntityLivingBase caster, int size, IBlockState block) {
        this(world);
        this.caster = caster;
        this.setBoulderSize(size);
        this.setSizeParams();
        if (!world.field_72995_K && block != null) {
            IBlockState newBlock = block;
            Material mat = block.func_185904_a();
            if (mat == Material.field_151577_b || mat == Material.field_151578_c) {
                newBlock = Blocks.field_150346_d.func_176223_P();
            } else if (mat == Material.field_151576_e) {
                if (block.func_177230_c().func_149739_a().contains("ore")) {
                    newBlock = Blocks.field_150348_b.func_176223_P();
                }
                if (block.func_177230_c() == Blocks.field_150449_bY) {
                    newBlock = Blocks.field_150424_aL.func_176223_P();
                }
                if (block.func_177230_c() == Blocks.field_150460_al || block.func_177230_c() == Blocks.field_150470_am || block.func_177230_c() == Blocks.field_150367_z || block.func_177230_c() == Blocks.field_150409_cd) {
                    newBlock = Blocks.field_150347_e.func_176223_P();
                }
            } else if (mat == Material.field_151571_B) {
                if (block.func_177230_c() == Blocks.field_150435_aG) {
                    newBlock = Blocks.field_150405_ch.func_176223_P();
                }
            } else if (mat == Material.field_151595_p) {
                if (block == Blocks.field_150354_m.func_176203_a(0)) {
                    newBlock = Blocks.field_150322_A.func_176223_P();
                } else if (block == Blocks.field_150354_m.func_176203_a(1)) {
                    newBlock = Blocks.field_180395_cM.func_176223_P();
                } else if (block.func_177230_c() == Blocks.field_150351_n) {
                    newBlock = Blocks.field_150347_e.func_176223_P();
                } else if (block.func_177230_c() == Blocks.field_150425_aM) {
                    newBlock = Blocks.field_150424_aL.func_176223_P();
                }
            }
            this.setBlock(newBlock);
        }
    }

    public boolean checkCanSpawn() {
        if (!this.field_70170_p.func_72872_a(EntityBoulder.class, this.func_174813_aQ()).isEmpty()) {
            return false;
        }
        return !this.field_70170_p.func_184143_b(this.func_174813_aQ());
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(BLOCK_STATE, (Object)Optional.of((Object)Blocks.field_150346_d.func_176223_P()));
        this.func_184212_Q().func_187214_a(SHOULD_EXPLODE, (Object)false);
        this.func_184212_Q().func_187214_a(ORIGIN, (Object)new BlockPos(0, 0, 0));
        this.func_184212_Q().func_187214_a(DEATH_TIME, (Object)1200);
        this.func_184212_Q().func_187214_a(SIZE, (Object)0);
    }

    public void setSizeParams() {
        int size = this.getBoulderSize();
        if (size == 0) {
            this.func_70105_a(1.0f, 1.0f);
        } else if (size == 1) {
            this.func_70105_a(2.0f, 1.5f);
            this.finishedRisingTick = 8;
            this.damage = 12;
            this.speed = 1.2f;
        } else if (size == 2) {
            this.func_70105_a(3.0f, 2.5f);
            this.finishedRisingTick = 12;
            this.damage = 16;
            this.speed = 1.0f;
        } else {
            this.func_70105_a(4.0f, 3.5f);
            this.finishedRisingTick = 90;
            this.damage = 20;
            this.speed = 0.65f;
        }
        if (this.caster instanceof EntityPlayer) {
            this.damage = (int)((float)this.damage * ConfigHandler.TOOLS_AND_ABILITIES.geomancyAttackMultiplier);
        }
    }

    public boolean func_174814_R() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public void func_70071_h_() {
        void var4_21;
        int dripNumber;
        if (this.field_70148_d) {
            this.setSizeParams();
            this.boulderSize = this.getBoulderSize();
        }
        if (this.storedBlock == null) {
            this.storedBlock = this.getBlock();
        }
        if (this.getShouldExplode()) {
            this.explode();
        }
        super.func_70071_h_();
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        if (this.ridingEntities != null) {
            this.ridingEntities.clear();
        }
        List onTopOfEntities = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_191195_a(0.0, (double)(this.field_70131_O - 1.0f), 0.0).func_191194_a(new Vec3d(0.0, (double)this.field_70131_O - 0.5, 0.0)).func_72314_b(0.6, 0.5, 0.6));
        for (Entity entity : onTopOfEntities) {
            if (entity == null || !entity.func_70067_L() || entity instanceof EntityBoulder || !(entity.field_70163_u >= this.field_70163_u + 0.2)) continue;
            this.ridingEntities.add(entity);
        }
        if (this.travelling) {
            for (Entity entity : this.ridingEntities) {
                entity.func_70091_d(MoverType.SHULKER_BOX, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            }
        }
        if (this.boulderSize == 3) {
            this.func_70105_a(this.field_70130_N, Math.min((float)this.field_70173_aa / (float)this.finishedRisingTick * 3.5f, 3.5f));
        }
        if (this.field_70173_aa < this.finishedRisingTick) {
            List popUpEntities = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ());
            for (Entity entity : popUpEntities) {
                if (!entity.func_70067_L() || entity instanceof EntityBoulder) continue;
                if (this.boulderSize != 3) {
                    entity.func_70091_d(MoverType.SHULKER_BOX, 0.0, 2.0 * Math.pow(2.0, (double)(-this.field_70173_aa) * (0.6 - 0.1 * (double)this.boulderSize)), 0.0);
                    continue;
                }
                entity.func_70091_d(MoverType.SHULKER_BOX, 0.0, (double)0.6f, 0.0);
            }
        }
        List<EntityLivingBase> entitiesHit = this.getEntityLivingBaseNearby(1.7);
        if (this.travelling && !entitiesHit.isEmpty()) {
            for (Entity entity : entitiesHit) {
                if (this.field_70170_p.field_72995_K || entity == this.caster || this.ridingEntities.contains(entity)) continue;
                if (this.caster != null) {
                    entity.func_70097_a(DamageSource.func_188403_a((Entity)this, (EntityLivingBase)this.caster), (float)this.damage);
                } else {
                    entity.func_70097_a(DamageSource.field_76377_j, (float)this.damage);
                }
                if (this.field_70128_L || this.boulderSize == 3) continue;
                this.setShouldExplode(true);
            }
        }
        List list = this.field_70170_p.func_72872_a(EntityBoulder.class, this.func_174813_aQ().func_72314_b(0.2, 0.2, 0.2).func_191194_a(new Vec3d(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72432_b().func_186678_a(0.5)));
        if (this.travelling && !list.isEmpty()) {
            for (EntityBoulder entity : list) {
                if (entity.travelling) continue;
                entity.func_85031_j(this);
                this.explode();
            }
        }
        if (this.travelling && this.field_70170_p.func_184143_b(this.func_174813_aQ().func_72314_b(0.1, 0.1, 0.1))) {
            this.setShouldExplode(true);
        }
        this.blockId = Block.func_176210_f((IBlockState)this.storedBlock);
        if (this.field_70173_aa == 1) {
            void var4_17;
            boolean bl = false;
            while ((float)var4_17 < 20.0f * this.field_70130_N) {
                Vec3d particlePos = new Vec3d((double)this.field_70146_Z.nextFloat() * 1.3 * (double)this.field_70130_N, 0.0, 0.0);
                particlePos = particlePos.func_178785_b((float)((double)(this.field_70146_Z.nextFloat() * 2.0f) * Math.PI));
                this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_CRACK, this.field_70165_t + particlePos.field_72450_a, this.field_70163_u - 1.0, this.field_70161_v + particlePos.field_72449_c, particlePos.field_72450_a, 2.0, particlePos.field_72449_c, new int[]{this.blockId});
                ++var4_17;
            }
            if (this.boulderSize == 0) {
                this.func_184185_a(MMSounds.EFFECT_GEOMANCY_SMALL_CRASH, 1.5f, 1.3f);
                this.func_184185_a(MMSounds.EFFECT_GEOMANCY_MAGIC_SMALL, 1.5f, 1.0f);
            } else if (this.boulderSize == 1) {
                this.func_184185_a(MMSounds.EFFECT_GEOMANCY_HIT_MEDIUM_2, 1.5f, 1.5f);
                this.func_184185_a(MMSounds.EFFECT_GEOMANCY_MAGIC_SMALL, 1.5f, 0.8f);
            } else if (this.boulderSize == 2) {
                this.func_184185_a(MMSounds.EFFECT_GEOMANCY_HIT_MEDIUM_1, 1.5f, 0.9f);
                this.func_184185_a(MMSounds.EFFECT_GEOMANCY_MAGIC_BIG, 1.5f, 1.5f);
            } else if (this.boulderSize == 3) {
                this.func_184185_a(MMSounds.EFFECT_GEOMANCY_MAGIC_BIG, 2.0f, 0.5f);
                this.func_184185_a(MMSounds.EFFECT_GEOMANCY_RUMBLE_1, 2.0f, 0.8f);
            }
            EntityRing entityRing = new EntityRing(this.field_70170_p, (float)this.field_70165_t, (float)this.field_70163_u - 0.9f, (float)this.field_70161_v, new Vec3d(0.0, 1.0, 0.0), (int)(5.0f + 2.0f * this.field_70130_N), 0.83f, 1.0f, 0.39f, 1.0f, 1.0f + 0.5f * this.field_70130_N, false);
            this.field_70170_p.func_72838_d((Entity)entityRing);
        }
        if (this.field_70173_aa == 30 && this.boulderSize == 3) {
            this.func_184185_a(MMSounds.EFFECT_GEOMANCY_RUMBLE_2, 2.0f, 0.7f);
        }
        int n = this.field_70173_aa - 2;
        if (this.boulderSize == 3) {
            var4_21 -= 20;
        }
        if ((dripNumber = (int)((double)(this.field_70130_N * 6.0f) * Math.pow(1.03 + 0.04 / (double)this.field_70130_N, (double)(-var4_21)))) >= 1 && var4_21 > 0) {
            dripNumber = (int)((float)dripNumber * this.field_70146_Z.nextFloat());
            for (int i = 0; i < dripNumber; ++i) {
                Vec3d particlePos = new Vec3d((double)this.field_70146_Z.nextFloat() * 0.6 * (double)this.field_70130_N, 0.0, 0.0);
                particlePos = particlePos.func_178785_b((float)((double)(this.field_70146_Z.nextFloat() * 2.0f) * Math.PI));
                float offsetY = this.boulderSize == 3 && this.field_70173_aa < this.finishedRisingTick ? this.field_70146_Z.nextFloat() * (this.field_70131_O - 1.0f) - this.field_70131_O * (float)(this.finishedRisingTick - this.field_70173_aa) / (float)this.finishedRisingTick : this.field_70146_Z.nextFloat() * (this.field_70131_O - 1.0f);
                this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_CRACK, this.field_70165_t + particlePos.field_72450_a, this.field_70163_u + (double)offsetY, this.field_70161_v + particlePos.field_72449_c, 0.0, -1.0, 0.0, new int[]{this.blockId});
            }
        }
        int newDeathTime = this.getDeathTime() - 1;
        this.setDeathTime(newDeathTime);
        if (newDeathTime < 0) {
            this.explode();
        }
    }

    private void explode() {
        block6: {
            Vec3d particlePos;
            int i;
            block8: {
                block7: {
                    block5: {
                        this.func_70106_y();
                        i = 0;
                        while ((float)i < 40.0f * this.field_70130_N) {
                            particlePos = new Vec3d((double)this.field_70146_Z.nextFloat() * 0.7 * (double)this.field_70130_N, 0.0, 0.0);
                            particlePos = particlePos.func_178785_b((float)((double)(this.field_70146_Z.nextFloat() * 2.0f) * Math.PI));
                            particlePos = particlePos.func_178789_a((float)((double)(this.field_70146_Z.nextFloat() * 2.0f) * Math.PI));
                            this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_CRACK, this.field_70165_t + particlePos.field_72450_a, this.field_70163_u + 0.5 + particlePos.field_72448_b, this.field_70161_v + particlePos.field_72449_c, particlePos.field_72450_a, particlePos.field_72448_b, particlePos.field_72449_c, new int[]{this.blockId});
                            ++i;
                        }
                        if (this.boulderSize != 0) break block5;
                        this.func_184185_a(MMSounds.EFFECT_GEOMANCY_MAGIC_SMALL, 1.5f, 0.9f);
                        this.func_184185_a(MMSounds.EFFECT_GEOMANCY_BREAK, 1.5f, 1.0f);
                        break block6;
                    }
                    if (this.boulderSize != 1) break block7;
                    this.func_184185_a(MMSounds.EFFECT_GEOMANCY_MAGIC_SMALL, 1.5f, 0.7f);
                    this.func_184185_a(MMSounds.EFFECT_GEOMANCY_BREAK_MEDIUM_3, 1.5f, 1.5f);
                    break block6;
                }
                if (this.boulderSize != 2) break block8;
                this.func_184185_a(MMSounds.EFFECT_GEOMANCY_MAGIC_BIG, 1.5f, 1.0f);
                this.func_184185_a(MMSounds.EFFECT_GEOMANCY_BREAK_MEDIUM_1, 1.5f, 0.9f);
                if (!this.field_70170_p.field_72995_K) break block6;
                for (i = 0; i < 5; ++i) {
                    particlePos = new Vec3d((double)(this.field_70146_Z.nextFloat() * 2.0f), 0.0, 0.0);
                    particlePos = particlePos.func_178785_b((float)((double)(this.field_70146_Z.nextFloat() * 2.0f) * Math.PI));
                    particlePos = particlePos.func_178789_a((float)((double)(this.field_70146_Z.nextFloat() * 2.0f) * Math.PI));
                    particlePos = particlePos.func_178787_e(new Vec3d(0.0, (double)(this.field_70131_O / 4.0f), 0.0));
                    ParticleFallingBlock.spawnFallingBlock(this.field_70170_p, this.field_70165_t + particlePos.field_72450_a, this.field_70163_u + 0.5 + particlePos.field_72448_b, this.field_70161_v + particlePos.field_72449_c, 10.0f, 90, 1.0f, (float)particlePos.field_72450_a * 0.3f, 0.2f + this.field_70146_Z.nextFloat() * 0.6f, (float)particlePos.field_72449_c * 0.3f, ParticleFallingBlock.EnumScaleBehavior.CONSTANT, this.getBlock());
                }
                break block6;
            }
            if (this.boulderSize == 3) {
                this.func_184185_a(MMSounds.EFFECT_GEOMANCY_MAGIC_BIG, 1.5f, 0.5f);
                this.func_184185_a(MMSounds.EFFECT_GEOMANCY_BREAK_LARGE_1, 1.5f, 0.5f);
                if (this.field_70170_p.field_72995_K) {
                    for (i = 0; i < 7; ++i) {
                        particlePos = new Vec3d((double)(this.field_70146_Z.nextFloat() * 3.0f), 0.0, 0.0);
                        particlePos = particlePos.func_178785_b((float)((double)(this.field_70146_Z.nextFloat() * 2.0f) * Math.PI));
                        particlePos = particlePos.func_178789_a((float)((double)(this.field_70146_Z.nextFloat() * 2.0f) * Math.PI));
                        particlePos = particlePos.func_178787_e(new Vec3d(0.0, (double)(this.field_70131_O / 4.0f), 0.0));
                        ParticleFallingBlock.spawnFallingBlock(this.field_70170_p, this.field_70165_t + particlePos.field_72450_a, this.field_70163_u + 0.5 + particlePos.field_72448_b, this.field_70161_v + particlePos.field_72449_c, 10.0f, 70, 1.0f, (float)particlePos.field_72450_a * 0.3f, 0.2f + this.field_70146_Z.nextFloat() * 0.6f, (float)particlePos.field_72449_c * 0.3f, ParticleFallingBlock.EnumScaleBehavior.CONSTANT, this.getBlock());
                    }
                }
            }
        }
    }

    @Nullable
    public AxisAlignedBB func_70046_E() {
        return this.func_174813_aQ();
    }

    public IBlockState getBlock() {
        return (IBlockState)((Optional)this.func_184212_Q().func_187225_a(BLOCK_STATE)).get();
    }

    public void setBlock(IBlockState block) {
        this.func_184212_Q().func_187227_b(BLOCK_STATE, (Object)Optional.of((Object)block));
        this.storedBlock = block;
    }

    public boolean getShouldExplode() {
        return (Boolean)this.func_184212_Q().func_187225_a(SHOULD_EXPLODE);
    }

    public void setShouldExplode(boolean shouldExplode) {
        this.func_184212_Q().func_187227_b(SHOULD_EXPLODE, (Object)shouldExplode);
    }

    public void setOrigin(BlockPos pos) {
        this.field_70180_af.func_187227_b(ORIGIN, (Object)pos);
    }

    public BlockPos getOrigin() {
        return (BlockPos)this.field_70180_af.func_187225_a(ORIGIN);
    }

    public int getDeathTime() {
        return (Integer)this.field_70180_af.func_187225_a(DEATH_TIME);
    }

    public void setDeathTime(int deathTime) {
        this.field_70180_af.func_187227_b(DEATH_TIME, (Object)deathTime);
    }

    public int getBoulderSize() {
        return (Integer)this.field_70180_af.func_187225_a(SIZE);
    }

    public void setBoulderSize(int size) {
        this.field_70180_af.func_187227_b(SIZE, (Object)size);
        this.boulderSize = size;
    }

    public void func_70014_b(NBTTagCompound compound) {
        Optional blockOption = Optional.of((Object)this.getBlock());
        if (blockOption.isPresent()) {
            compound.func_74782_a("block", (NBTBase)NBTUtil.func_190009_a((NBTTagCompound)new NBTTagCompound(), (IBlockState)((IBlockState)blockOption.get())));
        }
        compound.func_74768_a("deathTime", this.getDeathTime());
        compound.func_74768_a("size", this.getBoulderSize());
    }

    public void func_70037_a(NBTTagCompound compound) {
        IBlockState blockState = NBTUtil.func_190008_d((NBTTagCompound)((NBTTagCompound)compound.func_74781_a("block")));
        this.setBlock(blockState);
        this.setDeathTime(compound.func_74762_e("deathTime"));
        this.setBoulderSize(compound.func_74762_e("size"));
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_85031_j(Entity entityIn) {
        if (this.field_70173_aa > this.finishedRisingTick - 1) {
            if (entityIn instanceof EntityPlayer && ((EntityPlayer)entityIn).field_71071_by.func_70448_g().func_190926_b() && ((EntityPlayer)entityIn).func_70644_a((Potion)PotionHandler.GEOMANCY)) {
                EntityPlayer player = (EntityPlayer)entityIn;
                if (this.ridingEntities.contains(player)) {
                    Vec3d lateralLookVec = Vec3d.func_189986_a((float)0.0f, (float)player.field_70177_z).func_72432_b();
                    this.field_70159_w = (double)this.speed * 0.5 * lateralLookVec.field_72450_a;
                    this.field_70179_y = (double)this.speed * 0.5 * lateralLookVec.field_72449_c;
                } else {
                    this.field_70159_w = (double)this.speed * 0.5 * player.func_70040_Z().field_72450_a;
                    this.field_70181_x = (double)this.speed * 0.5 * player.func_70040_Z().field_72448_b;
                    this.field_70179_y = (double)this.speed * 0.5 * player.func_70040_Z().field_72449_c;
                }
            } else if (entityIn instanceof EntityBoulder && ((EntityBoulder)entityIn).travelling) {
                EntityBoulder boulder = (EntityBoulder)entityIn;
                Vec3d thisPos = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                Vec3d boulderPos = new Vec3d(boulder.field_70165_t, boulder.field_70163_u, boulder.field_70161_v);
                Vec3d velVec = thisPos.func_178788_d(boulderPos).func_72432_b();
                this.field_70159_w = (double)this.speed * 0.5 * velVec.field_72450_a;
                this.field_70181_x = (double)this.speed * 0.5 * velVec.field_72448_b;
                this.field_70179_y = (double)this.speed * 0.5 * velVec.field_72449_c;
            } else {
                return super.func_85031_j(entityIn);
            }
            if (!this.travelling) {
                this.setDeathTime(60);
            }
            this.travelling = true;
            if (this.boulderSize == 0) {
                this.func_184185_a(MMSounds.EFFECT_GEOMANCY_HIT_SMALL, 1.5f, 1.3f);
                this.func_184185_a(MMSounds.EFFECT_GEOMANCY_MAGIC_SMALL, 1.5f, 0.9f);
            } else if (this.boulderSize == 1) {
                this.func_184185_a(MMSounds.EFFECT_GEOMANCY_HIT_SMALL, 1.5f, 0.9f);
                this.func_184185_a(MMSounds.EFFECT_GEOMANCY_MAGIC_SMALL, 1.5f, 0.5f);
            } else if (this.boulderSize == 2) {
                this.func_184185_a(MMSounds.EFFECT_GEOMANCY_HIT_SMALL, 1.5f, 0.5f);
                this.func_184185_a(MMSounds.EFFECT_GEOMANCY_MAGIC_BIG, 1.5f, 1.3f);
            } else if (this.boulderSize == 3) {
                this.func_184185_a(MMSounds.EFFECT_GEOMANCY_HIT_MEDIUM_1, 1.5f, 1.0f);
                this.func_184185_a(MMSounds.EFFECT_GEOMANCY_MAGIC_BIG, 1.5f, 0.9f);
            }
            Vec3d ringOffset = new Vec3d(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72432_b().func_186678_a(-1.0);
            EntityRing ring = new EntityRing(entityIn.field_70170_p, (float)this.field_70165_t + (float)ringOffset.field_72450_a, (float)this.field_70163_u + 0.5f + (float)ringOffset.field_72448_b, (float)this.field_70161_v + (float)ringOffset.field_72449_c, ringOffset.func_72432_b(), (int)(4.0f + 1.0f * this.field_70130_N), 0.83f, 1.0f, 0.39f, 1.0f, 1.0f + 0.5f * this.field_70130_N, false);
            entityIn.field_70170_p.func_72838_d((Entity)ring);
        }
        return super.func_85031_j(entityIn);
    }

    public List<EntityLivingBase> getEntityLivingBaseNearby(double radius) {
        return this.getEntitiesNearby(EntityLivingBase.class, radius);
    }

    public <T extends Entity> List<T> getEntitiesNearby(Class<T> entityClass, double r) {
        return this.field_70170_p.func_175647_a(entityClass, this.func_174813_aQ().func_72314_b(r, r, r), e -> e != this && (double)this.func_70032_d((Entity)e) <= r + (double)(e.field_70130_N / 2.0f));
    }

    public double getAngleBetweenEntities(Entity first, Entity second) {
        return Math.atan2(second.field_70161_v - first.field_70161_v, second.field_70165_t - first.field_70165_t) * 57.29577951308232 + 90.0;
    }

    public void func_184185_a(SoundEvent soundIn, float volume, float pitch) {
        super.func_184185_a(soundIn, volume, pitch + this.field_70146_Z.nextFloat() * 0.25f - 0.125f);
    }
}

