/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.worldgen.trees;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.tslat.aoa3.block.functional.saplings.SaplingBlock;
import net.tslat.aoa3.block.generation.leaves.LeavesBlock;
import net.tslat.aoa3.common.registration.BlockRegister;
import net.tslat.aoa3.worldgen.trees.WorldGenTree;

public class WorldGenShyreTree
extends WorldGenTree {
    private final IBlockState leavesBlock;

    public WorldGenShyreTree(@Nullable SaplingBlock sapling, @Nullable LeavesBlock leaves, Random rand) {
        super(sapling);
        this.leavesBlock = leaves == null ? (rand.nextBoolean() ? BlockRegister.BRIGHT_SHYRE_LEAVES.func_176223_P() : BlockRegister.SHYRE_LEAVES.func_176223_P()) : leaves.func_176223_P();
    }

    @Override
    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        int i;
        int trunkHeight = 5 + rand.nextInt(5);
        if (!this.checkSafeHeight(world, pos, trunkHeight + 3, 1)) {
            return false;
        }
        if (!this.checkAndPrepSoil(world, pos, 1)) {
            return false;
        }
        BlockPos.MutableBlockPos movablePos = new BlockPos.MutableBlockPos(pos.func_177977_b());
        IBlockState log = BlockRegister.SHYRE_LOG.func_176223_P();
        for (i = 0; i < trunkHeight; ++i) {
            this.placeBlock(world, (BlockPos)movablePos.func_189536_c(EnumFacing.UP), log);
        }
        switch (rand.nextInt(4)) {
            case 0: {
                for (i = 0; i >= -2 - rand.nextInt(2); --i) {
                    this.placeBlock(world, movablePos.func_177982_a(-1, i, 0), this.leavesBlock);
                    this.placeBlock(world, movablePos.func_177982_a(1, i, 0), this.leavesBlock);
                    this.placeBlock(world, movablePos.func_177982_a(0, i, 1), this.leavesBlock);
                    this.placeBlock(world, movablePos.func_177982_a(0, i, -1), this.leavesBlock);
                }
                this.placeBlock(world, movablePos.func_177982_a(0, 1, 0), this.leavesBlock);
                break;
            }
            case 1: {
                for (int y = 0; y >= -1 - rand.nextInt(2); --y) {
                    for (int x = -1; x <= 1; ++x) {
                        for (int z = -1; z <= 1; ++z) {
                            this.placeBlock(world, movablePos.func_177982_a(x, y, z), this.leavesBlock);
                        }
                    }
                }
                this.placeBlock(world, movablePos.func_177982_a(0, 1, 0), this.leavesBlock);
                this.placeBlock(world, movablePos.func_177982_a(1, 1, 0), this.leavesBlock);
                this.placeBlock(world, movablePos.func_177982_a(0, 1, 1), this.leavesBlock);
                this.placeBlock(world, movablePos.func_177982_a(-1, 1, 0), this.leavesBlock);
                this.placeBlock(world, movablePos.func_177982_a(0, 1, -1), this.leavesBlock);
                break;
            }
            case 2: {
                for (int x = -1; x <= 1; ++x) {
                    for (int y = 1; y <= 3; y += 2) {
                        for (int z = -1; z <= 1; ++z) {
                            this.placeBlock(world, movablePos.func_177982_a(x, y, z), this.leavesBlock);
                        }
                    }
                }
                this.placeBlock(world, movablePos.func_177982_a(-1, 2, -1), this.leavesBlock);
                this.placeBlock(world, movablePos.func_177982_a(1, 2, 1), this.leavesBlock);
                this.placeBlock(world, movablePos.func_177982_a(-1, 2, 1), this.leavesBlock);
                this.placeBlock(world, movablePos.func_177982_a(1, 2, -1), this.leavesBlock);
                break;
            }
            case 3: {
                for (i = 0; i <= 3; ++i) {
                    if (i == 1) continue;
                    this.placeBlock(world, movablePos.func_177982_a(-1, i, 0), this.leavesBlock);
                    this.placeBlock(world, movablePos.func_177982_a(1, i, 0), this.leavesBlock);
                    this.placeBlock(world, movablePos.func_177982_a(0, i, 1), this.leavesBlock);
                    this.placeBlock(world, movablePos.func_177982_a(0, i, -1), this.leavesBlock);
                }
                this.placeBlock(world, movablePos.func_177982_a(0, 1, 0), this.leavesBlock);
            }
        }
        return true;
    }
}

