/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.worldgen.trees;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockLog;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.tslat.aoa3.block.functional.saplings.SaplingBlock;
import net.tslat.aoa3.common.registration.BlockRegister;
import net.tslat.aoa3.worldgen.trees.WorldGenTree;

public class WorldGenShadowTree
extends WorldGenTree {
    public WorldGenShadowTree(@Nullable SaplingBlock sapling) {
        super(sapling);
    }

    @Override
    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        int i;
        int trunkHeight = 8 + rand.nextInt(6);
        if (!this.checkSafeHeight(world, pos, trunkHeight + 1, 1)) {
            return false;
        }
        if (!this.checkAndPrepSoil(world, pos, 1)) {
            return false;
        }
        BlockPos.MutableBlockPos movablePos = new BlockPos.MutableBlockPos(pos.func_177977_b());
        IBlockState log = BlockRegister.SHADOW_LOG.func_176223_P();
        IBlockState barkLog = log.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.NONE);
        IBlockState leaves = BlockRegister.SHADOW_LEAVES.func_176223_P();
        int branchWidth = 1 + rand.nextInt(4);
        boolean additionalLeaves = rand.nextBoolean();
        for (i = 0; i < trunkHeight; ++i) {
            this.placeBlock(world, (BlockPos)movablePos.func_189536_c(EnumFacing.UP), log);
        }
        this.placeBlock(world, (BlockPos)movablePos.func_189536_c(EnumFacing.UP), barkLog);
        for (i = 1; i <= branchWidth; ++i) {
            this.placeBlock(world, movablePos.func_177964_d(i), barkLog);
            this.placeBlock(world, movablePos.func_177970_e(i), barkLog);
            this.placeBlock(world, movablePos.func_177965_g(i), barkLog);
            this.placeBlock(world, movablePos.func_177985_f(i), barkLog);
        }
        for (i = branchWidth + 1; i <= branchWidth + 3; ++i) {
            this.placeBlock(world, movablePos.func_177982_a(i, 0, 0), leaves);
            this.placeBlock(world, movablePos.func_177982_a(i, -2, 1), leaves);
            this.placeBlock(world, movablePos.func_177982_a(i, -2, -1), leaves);
            this.placeBlock(world, movablePos.func_177982_a(-i, 0, 0), leaves);
            this.placeBlock(world, movablePos.func_177982_a(-i, -2, 1), leaves);
            this.placeBlock(world, movablePos.func_177982_a(-i, -2, -1), leaves);
            this.placeBlock(world, movablePos.func_177982_a(0, 0, i), leaves);
            this.placeBlock(world, movablePos.func_177982_a(1, -2, i), leaves);
            this.placeBlock(world, movablePos.func_177982_a(-1, -2, i), leaves);
            this.placeBlock(world, movablePos.func_177982_a(0, 0, -i), leaves);
            this.placeBlock(world, movablePos.func_177982_a(1, -2, -i), leaves);
            this.placeBlock(world, movablePos.func_177982_a(-1, -2, -i), leaves);
            if (i == branchWidth + 3) {
                this.placeBlock(world, movablePos.func_177982_a(i, -1, 0), leaves);
                this.placeBlock(world, movablePos.func_177982_a(-i, -1, 0), leaves);
                this.placeBlock(world, movablePos.func_177982_a(0, -1, i), leaves);
                this.placeBlock(world, movablePos.func_177982_a(0, -1, -i), leaves);
                this.placeBlock(world, movablePos.func_177982_a(i, -3, 1), leaves);
                this.placeBlock(world, movablePos.func_177982_a(i, -3, -1), leaves);
                this.placeBlock(world, movablePos.func_177982_a(-i, -3, 1), leaves);
                this.placeBlock(world, movablePos.func_177982_a(-i, -3, -1), leaves);
                this.placeBlock(world, movablePos.func_177982_a(1, -3, i), leaves);
                this.placeBlock(world, movablePos.func_177982_a(-1, -3, i), leaves);
                this.placeBlock(world, movablePos.func_177982_a(1, -3, -i), leaves);
                this.placeBlock(world, movablePos.func_177982_a(-1, -3, -i), leaves);
                this.placeBlock(world, movablePos.func_177982_a(i, -4, 1), leaves);
                this.placeBlock(world, movablePos.func_177982_a(i, -4, -1), leaves);
                this.placeBlock(world, movablePos.func_177982_a(-i, -4, 1), leaves);
                this.placeBlock(world, movablePos.func_177982_a(-i, -4, -1), leaves);
                this.placeBlock(world, movablePos.func_177982_a(1, -4, i), leaves);
                this.placeBlock(world, movablePos.func_177982_a(-1, -4, i), leaves);
                this.placeBlock(world, movablePos.func_177982_a(1, -4, -i), leaves);
                this.placeBlock(world, movablePos.func_177982_a(-1, -4, -i), leaves);
                continue;
            }
            this.placeBlock(world, movablePos.func_177982_a(i, -1, 0), barkLog);
            this.placeBlock(world, movablePos.func_177982_a(-i, -1, 0), barkLog);
            this.placeBlock(world, movablePos.func_177982_a(0, -1, i), barkLog);
            this.placeBlock(world, movablePos.func_177982_a(0, -1, -i), barkLog);
            if (i == branchWidth + 1) {
                this.placeBlock(world, movablePos.func_177982_a(i, -3, 1), leaves);
                this.placeBlock(world, movablePos.func_177982_a(i, -3, -1), leaves);
                this.placeBlock(world, movablePos.func_177982_a(-i, -3, 1), leaves);
                this.placeBlock(world, movablePos.func_177982_a(-i, -3, -1), leaves);
                this.placeBlock(world, movablePos.func_177982_a(1, -3, i), leaves);
                this.placeBlock(world, movablePos.func_177982_a(-1, -3, i), leaves);
                this.placeBlock(world, movablePos.func_177982_a(1, -3, -i), leaves);
                this.placeBlock(world, movablePos.func_177982_a(-1, -3, -i), leaves);
                this.placeBlock(world, movablePos.func_177982_a(i, -4, 1), leaves);
                this.placeBlock(world, movablePos.func_177982_a(i, -4, -1), leaves);
                this.placeBlock(world, movablePos.func_177982_a(-i, -4, 1), leaves);
                this.placeBlock(world, movablePos.func_177982_a(-i, -4, -1), leaves);
                this.placeBlock(world, movablePos.func_177982_a(1, -4, i), leaves);
                this.placeBlock(world, movablePos.func_177982_a(-1, -4, i), leaves);
                this.placeBlock(world, movablePos.func_177982_a(1, -4, -i), leaves);
                this.placeBlock(world, movablePos.func_177982_a(-1, -4, -i), leaves);
            }
            if (!additionalLeaves) continue;
            this.placeBlock(world, movablePos.func_177982_a(i, -1, 1), leaves);
            this.placeBlock(world, movablePos.func_177982_a(i, -1, -1), leaves);
            this.placeBlock(world, movablePos.func_177982_a(-i, -1, 1), leaves);
            this.placeBlock(world, movablePos.func_177982_a(-i, -1, -1), leaves);
            this.placeBlock(world, movablePos.func_177982_a(1, -1, i), leaves);
            this.placeBlock(world, movablePos.func_177982_a(-1, -1, i), leaves);
            this.placeBlock(world, movablePos.func_177982_a(1, -1, -i), leaves);
            this.placeBlock(world, movablePos.func_177982_a(-1, -1, -i), leaves);
        }
        return true;
    }
}

