/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.worldgen.trees;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.tslat.aoa3.block.functional.saplings.SaplingBlock;
import net.tslat.aoa3.common.registration.BlockRegister;
import net.tslat.aoa3.worldgen.trees.WorldGenTree;

public class WorldGenLucalusTree
extends WorldGenTree {
    public WorldGenLucalusTree(@Nullable SaplingBlock sapling) {
        super(sapling);
    }

    @Override
    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        int z;
        int x;
        if ((pos = this.findMultiSaplingPosition(world, rand, pos, 2)) == null) {
            return false;
        }
        int trunkHeight = 16 + rand.nextInt(16);
        if (!this.checkSafeHeight(world, pos, trunkHeight + 2, 2)) {
            return false;
        }
        if (!this.checkAndPrepSoil(world, pos, 2)) {
            return false;
        }
        IBlockState log = BlockRegister.LUCALUS_LOG.func_176223_P();
        IBlockState leaves = BlockRegister.LUCALUS_LEAVES.func_176223_P();
        int northBranchGap = 0;
        int southBranchGap = 0;
        int eastBranchGap = 0;
        int westBranchGap = 0;
        for (int i = 0; i < trunkHeight; ++i) {
            for (int x2 = 0; x2 <= 1; ++x2) {
                for (int z2 = 0; z2 <= 1; ++z2) {
                    this.placeBlock(world, pos.func_177982_a(x2, i, z2), log);
                    if (i >= trunkHeight - 2) continue;
                    if (northBranchGap > 4 && rand.nextInt(4) == 0) {
                        northBranchGap = 0;
                        this.buildNorthSouthBranch(world, pos.func_177982_a(0, i, 0), rand, true);
                    }
                    if (eastBranchGap > 4 && rand.nextInt(4) == 0) {
                        eastBranchGap = 0;
                        this.buildEastWestBranch(world, pos.func_177982_a(0, i, 0), rand, true);
                    }
                    if (southBranchGap > 4 && rand.nextInt(4) == 0) {
                        southBranchGap = 0;
                        this.buildNorthSouthBranch(world, pos.func_177982_a(0, i, 0), rand, false);
                    }
                    if (westBranchGap <= 4 || rand.nextInt(4) != 0) continue;
                    westBranchGap = 0;
                    this.buildEastWestBranch(world, pos.func_177982_a(0, i, 0), rand, false);
                }
            }
            ++northBranchGap;
            ++southBranchGap;
            ++eastBranchGap;
            ++westBranchGap;
        }
        for (x = -1; x <= 2; ++x) {
            for (z = -1; z <= 2; ++z) {
                if ((x == -1 || x == 2) && (z == -1 || z == 2)) continue;
                this.placeBlock(world, pos.func_177982_a(x, trunkHeight - 1, z), leaves);
            }
        }
        for (x = -2; x <= 3; ++x) {
            for (z = -2; z <= 3; ++z) {
                if ((x == -2 || x == 3) && (z == -2 || z == 3)) continue;
                this.placeBlock(world, pos.func_177982_a(x, trunkHeight, z), leaves);
            }
        }
        this.placeBlock(world, pos.func_177982_a(0, trunkHeight + 1, 0), leaves);
        this.placeBlock(world, pos.func_177982_a(1, trunkHeight + 1, 0), leaves);
        this.placeBlock(world, pos.func_177982_a(0, trunkHeight + 1, 1), leaves);
        this.placeBlock(world, pos.func_177982_a(1, trunkHeight + 1, 1), leaves);
        return true;
    }

    private void buildNorthSouthBranch(World world, BlockPos branchPos, Random rand, boolean north) {
        IBlockState log = BlockRegister.LUCALUS_LOG.func_176223_P();
        IBlockState leaves = BlockRegister.LUCALUS_LEAVES.func_176223_P();
        int branchLength = 3 + rand.nextInt(2);
        if (north) {
            for (int i = 0; i < branchLength; ++i) {
                this.placeBlock(world, branchPos.func_177982_a(0, i, 2 + i), log);
                this.placeBlock(world, branchPos.func_177982_a(1, i, 2 + i), log);
            }
            int leafMod = 2 + rand.nextInt(3);
            for (int z = -2; z <= 2; ++z) {
                for (int x = -2; x <= 3; ++x) {
                    for (int y = 1; y <= 3; ++y) {
                        int x2 = x;
                        if (x > 0) {
                            --x2;
                        }
                        if (Math.abs(x2) > leafMod - Math.abs(z) - y) continue;
                        this.placeBlock(world, branchPos.func_177982_a(x, branchLength - 2 + y, branchLength + 1 + z), leaves);
                    }
                }
            }
        } else {
            for (int i = 0; i < branchLength; ++i) {
                this.placeBlock(world, branchPos.func_177982_a(0, i, -1 - i), log);
                this.placeBlock(world, branchPos.func_177982_a(1, i, -1 - i), log);
            }
            int leafMod = 2 + rand.nextInt(3);
            for (int z = -2; z <= 2; ++z) {
                for (int x = -2; x <= 3; ++x) {
                    for (int y = 1; y <= 3; ++y) {
                        int x2 = x;
                        if (x > 0) {
                            --x2;
                        }
                        if (Math.abs(x2) > leafMod - Math.abs(z) - y) continue;
                        this.placeBlock(world, branchPos.func_177982_a(x, branchLength - 2 + y, -branchLength + -z), leaves);
                    }
                }
            }
        }
    }

    private void buildEastWestBranch(World world, BlockPos branchPos, Random rand, boolean east) {
        IBlockState log = BlockRegister.LUCALUS_LOG.func_176223_P();
        IBlockState leaves = BlockRegister.LUCALUS_LEAVES.func_176223_P();
        int branchLength = 3 + rand.nextInt(2);
        if (east) {
            for (int i = 0; i < branchLength; ++i) {
                this.placeBlock(world, branchPos.func_177982_a(2 + i, i, 0), log);
                this.placeBlock(world, branchPos.func_177982_a(2 + i, i, 1), log);
            }
            int leafMod = 2 + rand.nextInt(3);
            for (int x = -2; x <= 2; ++x) {
                for (int z = -2; z <= 3; ++z) {
                    for (int y = 1; y <= 3; ++y) {
                        int z2 = z;
                        if (z > 0) {
                            --z2;
                        }
                        if (Math.abs(z2) > leafMod - Math.abs(x) - y) continue;
                        this.placeBlock(world, branchPos.func_177982_a(branchLength + 1 + x, branchLength - 2 + y, z), leaves);
                    }
                }
            }
        } else {
            for (int i = 0; i < branchLength; ++i) {
                this.placeBlock(world, branchPos.func_177982_a(-1 - i, i, 0), log);
                this.placeBlock(world, branchPos.func_177982_a(-1 - i, i, 1), log);
            }
            int leafMod = 2 + rand.nextInt(3);
            for (int x = -2; x <= 2; ++x) {
                for (int z = -2; z <= 3; ++z) {
                    for (int y = 1; y <= 3; ++y) {
                        int z2 = z;
                        if (z > 0) {
                            --z2;
                        }
                        if (Math.abs(z2) > leafMod - Math.abs(x) - y) continue;
                        this.placeBlock(world, branchPos.func_177982_a(-branchLength + -x, branchLength - 2 + y, z), leaves);
                    }
                }
            }
        }
    }
}

