/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.worldgen.trees;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.tslat.aoa3.block.functional.saplings.SaplingBlock;
import net.tslat.aoa3.common.registration.BlockRegister;
import net.tslat.aoa3.worldgen.trees.WorldGenTree;

public class WorldGenIrodustTree
extends WorldGenTree {
    public WorldGenIrodustTree(@Nullable SaplingBlock sapling) {
        super(sapling);
    }

    @Override
    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        if (rand.nextBoolean()) {
            return this.generateTree1(world, rand, pos);
        }
        return this.generateTree2(world, rand, pos);
    }

    private boolean generateTree1(World world, Random rand, BlockPos pos) {
        int trunkHeight = 8 + rand.nextInt(6);
        if (!this.checkSafeHeight(world, pos, trunkHeight + 1, 1)) {
            return false;
        }
        if (!this.checkAndPrepSoil(world, pos, 1)) {
            return false;
        }
        BlockPos.MutableBlockPos movablePos = new BlockPos.MutableBlockPos(pos.func_177977_b());
        IBlockState log = BlockRegister.IRO_LOG.func_176223_P();
        IBlockState leaves = BlockRegister.IRODUST_LEAVES.func_176223_P();
        for (int i = 0; i < trunkHeight; ++i) {
            this.placeBlock(world, (BlockPos)movablePos.func_189536_c(EnumFacing.UP), log);
        }
        int treeWidth = 1 + rand.nextInt(2);
        for (int x = -treeWidth - 1; x <= treeWidth + 1; ++x) {
            for (int z = -treeWidth - 1; z <= treeWidth + 1; ++z) {
                if (Math.abs(x) != treeWidth + 1 && Math.abs(z) != treeWidth + 1) {
                    this.placeBlock(world, movablePos.func_177982_a(x, 1, z), leaves);
                    continue;
                }
                this.placeBlock(world, movablePos.func_177982_a(x, 0, z), leaves);
            }
        }
        this.buildLeafRing(world, movablePos.func_177982_a(0, -1, 0), treeWidth + 1, true);
        return true;
    }

    private boolean generateTree2(World world, Random rand, BlockPos pos) {
        int trunkHeight = 8 + rand.nextInt(6);
        if (!this.checkSafeHeight(world, pos, trunkHeight + 2, 1)) {
            return false;
        }
        if (!this.checkAndPrepSoil(world, pos, 1)) {
            return false;
        }
        BlockPos.MutableBlockPos movablePos = new BlockPos.MutableBlockPos(pos.func_177977_b());
        IBlockState log = BlockRegister.IRO_LOG.func_176223_P();
        IBlockState leaves = BlockRegister.IRODUST_LEAVES.func_176223_P();
        for (int i = 0; i < trunkHeight; ++i) {
            this.placeBlock(world, (BlockPos)movablePos.func_189536_c(EnumFacing.UP), log);
        }
        this.buildLeafRing(world, movablePos.func_177963_a(0.0, -((double)trunkHeight / 1.75), 0.0), 3, false);
        this.buildLeafRing(world, movablePos.func_177982_a(0, -(trunkHeight / 4), 0), 2, true);
        for (int x = -1; x <= 1; ++x) {
            for (int y = 0; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    this.placeBlock(world, movablePos.func_177982_a(x, y, z), leaves);
                }
            }
        }
        return true;
    }

    private void buildLeafRing(World world, BlockPos pos, int radius, boolean fullRing) {
        IBlockState log = BlockRegister.IRO_LOG.func_176223_P();
        IBlockState leaves = BlockRegister.IRODUST_LEAVES.func_176223_P();
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                if (Math.abs(x) == radius || Math.abs(z) == radius) {
                    if (!fullRing && Math.abs(x) == radius && Math.abs(z) == radius) continue;
                    this.placeBlock(world, pos.func_177982_a(x, 0, z), leaves);
                    continue;
                }
                if (!(x == 0 ^ z == 0)) continue;
                this.placeBlock(world, pos.func_177982_a(x, 0, z), log);
            }
        }
    }
}

