/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.worldgen.trees;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.tslat.aoa3.block.functional.saplings.SaplingBlock;
import net.tslat.aoa3.common.registration.BlockRegister;
import net.tslat.aoa3.worldgen.trees.WorldGenTree;

public class WorldGenEyebushTree
extends WorldGenTree {
    public WorldGenEyebushTree(@Nullable SaplingBlock sapling) {
        super(sapling);
    }

    @Override
    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        boolean doubleTrunk = rand.nextBoolean();
        if (!this.checkSafeHeight(world, pos, (doubleTrunk ? 2 : 1) + 5, 1)) {
            return false;
        }
        if (!this.checkAndPrepSoil(world, pos, 1)) {
            return false;
        }
        IBlockState log = BlockRegister.EYEBALL_LOG.func_176223_P();
        this.placeBlock(world, pos, log);
        pos = pos.func_177984_a();
        if (doubleTrunk) {
            this.placeBlock(world, pos, log);
            pos = pos.func_177984_a();
        }
        this.placeBlock(world, pos.func_177978_c(), log);
        this.placeBlock(world, pos.func_177968_d(), log);
        this.placeBlock(world, pos.func_177974_f(), log);
        this.placeBlock(world, pos.func_177976_e(), log);
        this.placeBlock(world, pos.func_177984_a(), log);
        this.placeBlock(world, pos.func_177981_b(2), log);
        this.buildLeafRing(world, pos, 2);
        this.buildLeafRing(world, pos.func_177984_a(), 3);
        this.buildLeafRing(world, pos.func_177981_b(2), 2);
        this.buildLeafRing(world, pos.func_177981_b(3), 1);
        this.placeBlock(world, pos.func_177981_b(4), BlockRegister.VEIN_LEAVES.func_176223_P());
        return true;
    }

    private void buildLeafRing(World world, BlockPos pos, int radius) {
        IBlockState leaves = BlockRegister.VEIN_LEAVES.func_176223_P();
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                if ((x == radius || x == -radius) && (z == radius || z == -radius)) continue;
                this.placeBlock(world, pos.func_177982_a(x, 0, z), leaves);
            }
        }
    }
}

