/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.worldgen.trees;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.tslat.aoa3.block.functional.saplings.SaplingBlock;
import net.tslat.aoa3.common.registration.BlockRegister;
import net.tslat.aoa3.worldgen.trees.WorldGenTree;

public class WorldGenDawnwoodTree
extends WorldGenTree {
    public WorldGenDawnwoodTree(@Nullable SaplingBlock sapling) {
        super(sapling);
    }

    @Override
    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        int trunkHeight = 15 + rand.nextInt(10);
        if (!this.checkSafeHeight(world, pos, trunkHeight + 2, 1)) {
            return false;
        }
        if (!this.checkAndPrepSoil(world, pos, 1)) {
            return false;
        }
        BlockPos.MutableBlockPos movablePos = new BlockPos.MutableBlockPos(pos.func_177977_b());
        IBlockState log = BlockRegister.DAWN_LOG.func_176223_P();
        IBlockState leaves = BlockRegister.DAWN_LEAVES.func_176223_P();
        for (int i = 0; i < trunkHeight; ++i) {
            this.placeBlock(world, (BlockPos)movablePos.func_189536_c(EnumFacing.UP), log);
            if (rand.nextInt(4) == 0) {
                this.placeBlock(world, movablePos.func_177978_c(), leaves);
            }
            if (rand.nextInt(4) == 0) {
                this.placeBlock(world, movablePos.func_177968_d(), leaves);
            }
            if (rand.nextInt(4) == 0) {
                this.placeBlock(world, movablePos.func_177974_f(), leaves);
            }
            if (rand.nextInt(4) != 0) continue;
            this.placeBlock(world, movablePos.func_177976_e(), leaves);
        }
        if (rand.nextInt(3) == 0) {
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    this.placeBlock(world, movablePos.func_177982_a(x, -1, z), leaves);
                    this.placeBlock(world, movablePos.func_177982_a(x, 1, z), leaves);
                }
            }
            int leafWidth = 2 + rand.nextInt(2);
            for (int x = -leafWidth; x <= leafWidth; ++x) {
                for (int z = -leafWidth; z <= leafWidth; ++z) {
                    this.placeBlock(world, movablePos.func_177982_a(x, 0, z), leaves);
                }
            }
            this.placeBlock(world, movablePos.func_177982_a(0, 2, 0), leaves);
            this.placeBlock(world, movablePos.func_177982_a(1, -2, 0), leaves);
            this.placeBlock(world, movablePos.func_177982_a(-1, -2, 0), leaves);
            this.placeBlock(world, movablePos.func_177982_a(0, -2, 1), leaves);
            this.placeBlock(world, movablePos.func_177982_a(0, -2, -1), leaves);
        } else if (rand.nextBoolean()) {
            this.placeBlock(world, (BlockPos)movablePos.func_189536_c(EnumFacing.UP), leaves);
        }
        return true;
    }
}

