/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.worldgen.trees;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.tslat.aoa3.block.functional.saplings.SaplingBlock;
import net.tslat.aoa3.block.generation.leaves.LeavesBlock;
import net.tslat.aoa3.common.registration.BlockRegister;
import net.tslat.aoa3.worldgen.trees.WorldGenTree;

public class WorldGenCelevusTree
extends WorldGenTree {
    private final IBlockState leavesBlock;

    public WorldGenCelevusTree(@Nullable SaplingBlock sapling, @Nullable LeavesBlock leaves, Random rand) {
        super(sapling);
        if (leaves == null) {
            switch (rand.nextInt(6)) {
                case 0: {
                    this.leavesBlock = BlockRegister.BLUE_CELEVUS_LEAVES.func_176223_P();
                    break;
                }
                case 1: {
                    this.leavesBlock = BlockRegister.GREEN_CELEVUS_LEAVES.func_176223_P();
                    break;
                }
                case 2: {
                    this.leavesBlock = BlockRegister.PURPLE_CELEVUS_LEAVES.func_176223_P();
                    break;
                }
                case 3: {
                    this.leavesBlock = BlockRegister.RED_CELEVUS_LEAVES.func_176223_P();
                    break;
                }
                default: {
                    this.leavesBlock = BlockRegister.YELLOW_CELEVUS_LEAVES.func_176223_P();
                    break;
                }
            }
        } else {
            this.leavesBlock = leaves.func_176223_P();
        }
    }

    @Override
    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        BlockPos multiSaplingPos = this.findMultiSaplingPosition(world, rand, pos, 2);
        if (multiSaplingPos == null || this.sapling == null && rand.nextInt(6) != 0) {
            return this.genSmallTree(world, rand, pos);
        }
        return this.genBigTree(world, rand, multiSaplingPos);
    }

    public boolean genBigTree(World world, Random rand, BlockPos pos) {
        int x;
        int z;
        int trunkHeight = 15 + rand.nextInt(10);
        if (!this.checkSafeHeight(world, pos, trunkHeight + 5, 2)) {
            return false;
        }
        if (!this.checkAndPrepSoil(world, pos, 2)) {
            return false;
        }
        IBlockState log = BlockRegister.CELEVE_STEM.func_176223_P();
        boolean clockwise = rand.nextBoolean();
        boolean thickTwist = rand.nextBoolean();
        int twistOffset = 1 + rand.nextInt(3);
        block6: for (int i = 0; i < trunkHeight; ++i) {
            for (int x2 = 0; x2 <= 1; ++x2) {
                for (z = 0; z <= 1; ++z) {
                    this.placeBlock(world, pos.func_177982_a(x2, i, z), log);
                }
            }
            switch ((i + twistOffset) % 4) {
                case 0: {
                    this.placeBlock(world, pos.func_177982_a(0, i, 0), this.leavesBlock, true);
                    if (!thickTwist || i <= 0) continue block6;
                    this.placeBlock(world, pos.func_177982_a(0, i - 1, 0), this.leavesBlock, true);
                    continue block6;
                }
                case 1: {
                    if (clockwise) {
                        this.placeBlock(world, pos.func_177982_a(0, i, 1), this.leavesBlock, true);
                        if (!thickTwist || i <= 0) continue block6;
                        this.placeBlock(world, pos.func_177982_a(0, i - 1, 1), this.leavesBlock, true);
                        continue block6;
                    }
                    this.placeBlock(world, pos.func_177982_a(1, i, 0), this.leavesBlock, true);
                    if (!thickTwist || i <= 0) continue block6;
                    this.placeBlock(world, pos.func_177982_a(1, i - 1, 0), this.leavesBlock, true);
                    continue block6;
                }
                case 2: {
                    this.placeBlock(world, pos.func_177982_a(1, i, 1), this.leavesBlock, true);
                    if (!thickTwist || i <= 0) continue block6;
                    this.placeBlock(world, pos.func_177982_a(1, i - 1, 1), this.leavesBlock, true);
                    continue block6;
                }
                case 3: {
                    if (clockwise) {
                        this.placeBlock(world, pos.func_177982_a(1, i, 0), this.leavesBlock, true);
                        if (!thickTwist || i <= 0) continue block6;
                        this.placeBlock(world, pos.func_177982_a(1, i - 1, 0), this.leavesBlock, true);
                        continue block6;
                    }
                    this.placeBlock(world, pos.func_177982_a(0, i, 1), this.leavesBlock, true);
                    if (!thickTwist || i <= 0) continue block6;
                    this.placeBlock(world, pos.func_177982_a(0, i - 1, 1), this.leavesBlock, true);
                }
            }
        }
        pos = pos.func_177981_b(trunkHeight);
        for (x = -1; x <= 2; ++x) {
            for (int z2 = -1; z2 <= 2; ++z2) {
                this.placeBlock(world, pos.func_177982_a(x, 0, z2), this.leavesBlock);
                this.placeBlock(world, pos.func_177982_a(x, 5, z2), this.leavesBlock);
            }
        }
        for (x = -2; x <= 3; ++x) {
            for (int y = 1; y <= 4; ++y) {
                for (z = -2; z <= 3; ++z) {
                    this.placeBlock(world, pos.func_177982_a(x, y, z), this.leavesBlock);
                }
            }
        }
        return true;
    }

    public boolean genSmallTree(World world, Random rand, BlockPos pos) {
        int z;
        int x;
        int trunkHeight = 8 + rand.nextInt(7);
        if (!this.checkSafeHeight(world, pos, trunkHeight + 5, 1)) {
            return false;
        }
        if (!this.checkAndPrepSoil(world, pos, 1)) {
            return false;
        }
        BlockPos.MutableBlockPos movablePos = new BlockPos.MutableBlockPos(pos.func_177977_b());
        IBlockState log = BlockRegister.CELEVE_STEM.func_176223_P();
        IBlockState whiteLeaves = BlockRegister.WHITE_CELEVUS_LEAVES.func_176223_P();
        int leafRingGap = -1;
        for (int i = 0; i < trunkHeight; ++i) {
            this.placeBlock(world, (BlockPos)movablePos.func_189536_c(EnumFacing.UP), log);
            if (leafRingGap > 1 && i < trunkHeight - 1 && rand.nextBoolean()) {
                leafRingGap = 0;
                for (int x2 = -1; x2 <= 1; ++x2) {
                    for (int z2 = -1; z2 <= 1; ++z2) {
                        this.placeBlock(world, movablePos.func_177982_a(x2, 0, z2), this.leavesBlock);
                    }
                }
            }
            ++leafRingGap;
        }
        for (x = -1; x <= 1; ++x) {
            for (z = -1; z <= 1; ++z) {
                this.placeBlock(world, movablePos.func_177982_a(x, 0, z), whiteLeaves);
                this.placeBlock(world, movablePos.func_177982_a(x, 5, z), this.leavesBlock);
            }
        }
        for (x = -2; x <= 2; ++x) {
            for (z = -2; z <= 2; ++z) {
                this.placeBlock(world, movablePos.func_177982_a(x, 1, z), this.leavesBlock);
                this.placeBlock(world, movablePos.func_177982_a(x, 2, z), whiteLeaves);
                this.placeBlock(world, movablePos.func_177982_a(x, 3, z), this.leavesBlock);
                this.placeBlock(world, movablePos.func_177982_a(x, 4, z), whiteLeaves);
            }
        }
        return true;
    }
}

