/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.worldgen.trees;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockLog;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.tslat.aoa3.block.functional.saplings.SaplingBlock;
import net.tslat.aoa3.common.registration.BlockRegister;
import net.tslat.aoa3.worldgen.trees.WorldGenTree;

public class WorldGenBloodtwisterTree
extends WorldGenTree {
    public WorldGenBloodtwisterTree(@Nullable SaplingBlock sapling) {
        super(sapling);
    }

    @Override
    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        int weaveHeight;
        int trunkHeight = 5 + rand.nextInt(5);
        if (!this.checkSafeHeight(world, pos, trunkHeight + (weaveHeight = 8 + rand.nextInt(8)), 1)) {
            return false;
        }
        if (!this.checkAndPrepSoil(world, pos, 1)) {
            return false;
        }
        BlockPos.MutableBlockPos movablePos = new BlockPos.MutableBlockPos(pos.func_177977_b());
        IBlockState log = BlockRegister.BLOOD_LOG.func_176223_P();
        IBlockState leaves = BlockRegister.BLOOD_LEAVES.func_176223_P();
        IBlockState barkLog = log.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.NONE);
        for (int i = 0; i < trunkHeight; ++i) {
            this.placeBlock(world, (BlockPos)movablePos.func_189536_c(EnumFacing.UP), log);
        }
        this.placeBlock(world, pos.func_177981_b(1 + rand.nextInt(3)), BlockRegister.EYEBALL_LOG.func_176223_P());
        this.placeBlock(world, movablePos.func_177982_a(1, 0, 0), barkLog);
        this.placeBlock(world, movablePos.func_177982_a(0, 0, 1), barkLog);
        this.placeBlock(world, (BlockPos)movablePos, barkLog);
        this.placeBlock(world, movablePos.func_177982_a(-1, 0, 0), barkLog);
        this.placeBlock(world, movablePos.func_177982_a(0, 0, -1), barkLog);
        this.placeBlock(world, movablePos.func_177982_a(2, 0, 0), leaves);
        this.placeBlock(world, movablePos.func_177982_a(0, 0, 2), leaves);
        this.placeBlock(world, movablePos.func_177982_a(-2, 0, 0), leaves);
        this.placeBlock(world, movablePos.func_177982_a(0, 0, -2), leaves);
        this.placeBlock(world, movablePos.func_177982_a(3, 0, 0), leaves);
        this.placeBlock(world, movablePos.func_177982_a(0, 0, 3), leaves);
        this.placeBlock(world, movablePos.func_177982_a(-3, 0, 0), leaves);
        this.placeBlock(world, movablePos.func_177982_a(0, 0, -3), leaves);
        if (rand.nextBoolean()) {
            EnumFacing[] directions = new EnumFacing[]{EnumFacing.NORTH, EnumFacing.EAST, EnumFacing.SOUTH, EnumFacing.WEST};
            int turnMod = rand.nextBoolean() ? 3 : 4;
            int direction = 0;
            int curBaseDirection = 0;
            BlockPos basePos = movablePos.func_185334_h();
            movablePos.func_189534_c(EnumFacing.WEST, 3);
            for (int i = 1; i <= weaveHeight; ++i) {
                this.placeBlock(world, (BlockPos)movablePos.func_189536_c(directions[direction]), leaves);
                this.placeBlock(world, (BlockPos)movablePos.func_189536_c(EnumFacing.UP), leaves);
                if (i == weaveHeight && curBaseDirection < 3) {
                    movablePos.func_189533_g((Vec3i)basePos).func_189534_c(directions[curBaseDirection], 3);
                    direction = ++curBaseDirection;
                    i = 1;
                }
                if (i % turnMod != 0 || ++direction <= 3) continue;
                direction = 0;
            }
        } else {
            EnumFacing[] directions = new EnumFacing[]{EnumFacing.SOUTH, EnumFacing.EAST, EnumFacing.NORTH, EnumFacing.WEST};
            int turnMod = rand.nextBoolean() ? 3 : 4;
            int direction = 0;
            int curBaseDirection = 0;
            BlockPos basePos = movablePos.func_185334_h();
            movablePos.func_189534_c(EnumFacing.WEST, 3);
            for (int i = 1; i <= weaveHeight; ++i) {
                this.placeBlock(world, (BlockPos)movablePos.func_189536_c(directions[direction]), leaves);
                this.placeBlock(world, (BlockPos)movablePos.func_189536_c(EnumFacing.UP), leaves);
                if (i == weaveHeight && curBaseDirection < 3) {
                    movablePos.func_189533_g((Vec3i)basePos).func_189534_c(directions[curBaseDirection], 3);
                    direction = ++curBaseDirection;
                    i = 1;
                }
                if (i % turnMod != 0 || ++direction <= 3) continue;
                direction = 0;
            }
        }
        return true;
    }
}

