/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.utils;

import java.util.ArrayList;
import java.util.function.BiPredicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.BlockGravel;
import net.minecraft.block.BlockIce;
import net.minecraft.block.BlockOre;
import net.minecraft.block.BlockRedstoneOre;
import net.minecraft.block.BlockSand;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.BlockSnowBlock;
import net.minecraft.block.BlockStone;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketBlockChange;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.Explosion;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import net.tslat.aoa3.entity.projectiles.mob.BaseMobProjectile;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.ConfigurationUtil;

public final class WorldUtil {
    public static int getTrueWorldHeight(World world, int x, int z) {
        boolean match1 = false;
        boolean match2 = false;
        try {
            int height;
            if (world.field_73011_w.getDimension() == ConfigurationUtil.MainConfig.dimensionIds.deeplands) {
                height = 121;
            } else if (world.field_73011_w.getDimension() == -1) {
                height = 128;
            } else if (world.field_73011_w.getDimension() == ConfigurationUtil.MainConfig.dimensionIds.crystevia) {
                height = 127;
            } else {
                return world.func_189649_b(x, z);
            }
            if (Math.abs(x) > 30000000 || Math.abs(z) > 30000000) {
                return 0;
            }
            for (int i = height; i > 0; --i) {
                if (world.func_180495_p(new BlockPos(x, i, z)).func_177230_c() == Blocks.field_150350_a) {
                    if (match1) {
                        if (match2) continue;
                        match2 = true;
                        continue;
                    }
                    match1 = true;
                    continue;
                }
                if (match1 && match2) {
                    return i;
                }
                match1 = false;
                match2 = false;
            }
        }
        catch (Exception e) {
            return 0;
        }
        return 0;
    }

    public static boolean isNaturalDimensionBlock(World world, BlockPos pos, IBlockState blockState) {
        Block bl = blockState.func_177230_c();
        if (bl instanceof BlockStone) {
            BlockStone.EnumType stoneVariant = (BlockStone.EnumType)blockState.func_177229_b((IProperty)BlockStone.field_176247_a);
            return stoneVariant != BlockStone.EnumType.ANDESITE_SMOOTH && stoneVariant != BlockStone.EnumType.DIORITE_SMOOTH && stoneVariant != BlockStone.EnumType.GRANITE_SMOOTH;
        }
        if (bl instanceof BlockGrass || bl instanceof BlockDirt || bl instanceof BlockSand || bl instanceof BlockGravel || bl instanceof BlockSnowBlock || bl instanceof BlockSnow || bl instanceof BlockIce || bl instanceof BlockOre || bl instanceof BlockRedstoneOre) {
            return true;
        }
        Biome biome = world.func_180494_b(pos);
        return bl == biome.field_76752_A.func_177230_c() || bl == biome.field_76753_B.func_177230_c();
    }

    public static Explosion createExplosion(@Nullable Entity exploder, World world, BlockPos pos, float strength) {
        return WorldUtil.createExplosion(exploder, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), strength, WorldUtil.checkGameRule(world, "destructiveWeaponPhysics"), false);
    }

    public static Explosion createExplosion(@Nonnull Entity exploder, World world, float strength) {
        return WorldUtil.createExplosion(exploder, world, exploder.field_70165_t, exploder.field_70163_u, exploder.field_70161_v, strength, WorldUtil.checkGameRule(world, "doStrongerMobGriefing"), false);
    }

    public static Explosion createExplosion(@Nullable Entity exploder, World world, @Nonnull Entity explodingEntity, float strength) {
        boolean doGriefing;
        if (exploder instanceof EntityPlayer) {
            doGriefing = WorldUtil.checkGameRule(world, "destructiveWeaponPhysics");
        } else {
            if (exploder == null) {
                exploder = explodingEntity;
            }
            doGriefing = explodingEntity instanceof BaseMobProjectile || explodingEntity instanceof EntityLivingBase ? WorldUtil.checkGameRule(world, "doStrongerMobGriefing") : WorldUtil.checkGameRule(world, "destructiveWeaponPhysics");
        }
        return WorldUtil.createExplosion(exploder, world, explodingEntity.field_70165_t, explodingEntity.field_70163_u, explodingEntity.field_70161_v, strength, doGriefing, false);
    }

    public static Explosion createExplosion(@Nullable Entity exploder, World world, double posX, double posY, double posZ, float strength) {
        return WorldUtil.createExplosion(exploder, world, posX, posY, posZ, strength, WorldUtil.checkGameRule(world, "destructiveWeaponPhysics"), false);
    }

    public static Explosion createExplosion(@Nullable Entity exploder, World world, double posX, double posY, double posZ, float strength, boolean destructiveExplosion) {
        return WorldUtil.createExplosion(exploder, world, posX, posY, posZ, strength, destructiveExplosion, false);
    }

    public static Explosion createExplosion(@Nullable Entity exploder, World world, double posX, double posY, double posZ, float strength, boolean destructiveExplosion, boolean fieryExplosion) {
        return world.func_72885_a(exploder, posX, posY, posZ, strength, fieryExplosion, destructiveExplosion);
    }

    @Nullable
    public static Enums.Dimensions getDimensionFromId(int id) {
        if (id == 0) {
            return Enums.Dimensions.OVERWORLD;
        }
        if (id == -1) {
            return Enums.Dimensions.NETHER;
        }
        if (id == 1) {
            return Enums.Dimensions.THE_END;
        }
        if (id == ConfigurationUtil.MainConfig.dimensionIds.abyss) {
            return Enums.Dimensions.ABYSS;
        }
        if (id == ConfigurationUtil.MainConfig.dimensionIds.ancientCavern) {
            return Enums.Dimensions.ANCIENT_CAVERN;
        }
        if (id == ConfigurationUtil.MainConfig.dimensionIds.barathos) {
            return Enums.Dimensions.BARATHOS;
        }
        if (id == ConfigurationUtil.MainConfig.dimensionIds.candyland) {
            return Enums.Dimensions.CANDYLAND;
        }
        if (id == ConfigurationUtil.MainConfig.dimensionIds.celeve) {
            return Enums.Dimensions.CELEVE;
        }
        if (id == ConfigurationUtil.MainConfig.dimensionIds.creeponia) {
            return Enums.Dimensions.CREEPONIA;
        }
        if (id == ConfigurationUtil.MainConfig.dimensionIds.crystevia) {
            return Enums.Dimensions.CRYSTEVIA;
        }
        if (id == ConfigurationUtil.MainConfig.dimensionIds.deeplands) {
            return Enums.Dimensions.DEEPLANDS;
        }
        if (id == ConfigurationUtil.MainConfig.dimensionIds.dustopia) {
            return Enums.Dimensions.DUSTOPIA;
        }
        if (id == ConfigurationUtil.MainConfig.dimensionIds.gardencia) {
            return Enums.Dimensions.GARDENCIA;
        }
        if (id == ConfigurationUtil.MainConfig.dimensionIds.greckon) {
            return Enums.Dimensions.GRECKON;
        }
        if (id == ConfigurationUtil.MainConfig.dimensionIds.haven) {
            return Enums.Dimensions.HAVEN;
        }
        if (id == ConfigurationUtil.MainConfig.dimensionIds.immortallis) {
            return Enums.Dimensions.IMMORTALLIS;
        }
        if (id == ConfigurationUtil.MainConfig.dimensionIds.iromine) {
            return Enums.Dimensions.IROMINE;
        }
        if (id == ConfigurationUtil.MainConfig.dimensionIds.lborean) {
            return Enums.Dimensions.LBOREAN;
        }
        if (id == ConfigurationUtil.MainConfig.dimensionIds.lelyetia) {
            return Enums.Dimensions.LELYETIA;
        }
        if (id == ConfigurationUtil.MainConfig.dimensionIds.lunalus) {
            return Enums.Dimensions.LUNALUS;
        }
        if (id == ConfigurationUtil.MainConfig.dimensionIds.mysterium) {
            return Enums.Dimensions.MYSTERIUM;
        }
        if (id == ConfigurationUtil.MainConfig.dimensionIds.precasia) {
            return Enums.Dimensions.PRECASIA;
        }
        if (id == ConfigurationUtil.MainConfig.dimensionIds.runandor) {
            return Enums.Dimensions.RUNANDOR;
        }
        if (id == ConfigurationUtil.MainConfig.dimensionIds.shyrelands) {
            return Enums.Dimensions.SHYRELANDS;
        }
        if (id == ConfigurationUtil.MainConfig.dimensionIds.voxPonds) {
            return Enums.Dimensions.VOX_PONDS;
        }
        return null;
    }

    public int blockFlagsToInt(Enums.BlockUpdateFlags ... flags) {
        int value = 0;
        for (Enums.BlockUpdateFlags flag : flags) {
            value |= flag.value;
        }
        return value;
    }

    public static boolean checkGameRule(World world, String gameRule) {
        return world.func_82736_K().func_82766_b(gameRule);
    }

    public static String getGameRuleString(World world, String gameRule) {
        return world.func_82736_K().func_82767_a(gameRule);
    }

    public static int getGameRuleInt(World world, String gameRule) {
        return world.func_82736_K().func_180263_c(gameRule);
    }

    public static int getLightLevel(World world, BlockPos position, boolean ignoreSkyLight, boolean ignoreBlockLight) {
        if (ignoreBlockLight && ignoreSkyLight) {
            ignoreBlockLight = false;
            ignoreSkyLight = false;
        }
        Chunk chunk = world.func_175726_f(position);
        if (position.func_177956_o() > 255) {
            position = new BlockPos(position.func_177958_n(), 255, position.func_177952_p());
        } else if (position.func_177956_o() < 0) {
            position = new BlockPos(position.func_177958_n(), 0, position.func_177952_p());
        }
        if (ignoreSkyLight) {
            return chunk.func_177413_a(EnumSkyBlock.BLOCK, position);
        }
        if (ignoreBlockLight) {
            return chunk.func_177413_a(EnumSkyBlock.SKY, position);
        }
        return world.func_175671_l(position);
    }

    public static boolean harvestAdditionalBlock(World world, EntityPlayer pl, ItemStack toolStack, BlockPos originPos, BlockPos breakPos) {
        IBlockState blockState = world.func_180495_p(breakPos);
        Block block = blockState.func_177230_c();
        if (block.isAir(blockState, (IBlockAccess)world, breakPos)) {
            return false;
        }
        if (ForgeHooks.blockStrength((IBlockState)world.func_180495_p(originPos), (EntityPlayer)pl, (World)world, (BlockPos)originPos) / ForgeHooks.blockStrength((IBlockState)blockState, (EntityPlayer)pl, (World)world, (BlockPos)breakPos) > 10.0f) {
            return false;
        }
        if (!world.field_72995_K) {
            int blockXp = ForgeHooks.onBlockBreakEvent((World)world, (GameType)((EntityPlayerMP)pl).field_71134_c.func_73081_b(), (EntityPlayerMP)((EntityPlayerMP)pl), (BlockPos)breakPos);
            if (blockXp < 0) {
                return false;
            }
            if (block.removedByPlayer(blockState, world, breakPos, pl, true)) {
                toolStack.func_179548_a(world, blockState, breakPos, pl);
                block.func_176206_d(world, breakPos, blockState);
                block.func_180657_a(world, pl, breakPos, blockState, world.func_175625_s(breakPos), toolStack);
                block.func_180637_b(world, breakPos, blockXp);
                ((EntityPlayerMP)pl).field_71135_a.func_147359_a((Packet)new SPacketBlockChange(world, breakPos));
            }
        } else if (block.removedByPlayer(blockState, world, breakPos, pl, true)) {
            world.func_175669_a(2001, breakPos, Block.func_176210_f((IBlockState)blockState));
            block.func_176206_d(world, breakPos, blockState);
            toolStack.func_179548_a(world, blockState, breakPos, pl);
            if (toolStack.func_190916_E() <= 0 && toolStack == pl.func_184614_ca()) {
                ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)pl, (ItemStack)toolStack, (EnumHand)EnumHand.MAIN_HAND);
                pl.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
            }
        }
        return true;
    }

    public static ArrayList<BlockPos> getBlocksWithinAABB(World world, AxisAlignedBB aabb, @Nullable BiPredicate<IBlockState, BlockPos.MutableBlockPos> predicate) {
        BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos();
        ArrayList<BlockPos> matches = new ArrayList<BlockPos>();
        int x = (int)Math.floor(aabb.field_72340_a);
        while ((double)x <= Math.ceil(aabb.field_72336_d)) {
            int y = (int)Math.floor(aabb.field_72338_b);
            while ((double)y <= Math.ceil(aabb.field_72337_e)) {
                int z = (int)Math.floor(aabb.field_72339_c);
                while ((double)z <= Math.ceil(aabb.field_72334_f)) {
                    checkPos.func_181079_c(x, y, z);
                    if (predicate == null || predicate.test(world.func_180495_p((BlockPos)checkPos), checkPos)) {
                        matches.add(checkPos.func_185334_h());
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return matches;
    }

    public static boolean isOreBlock(Block block) {
        return block instanceof BlockOre || block instanceof BlockRedstoneOre;
    }

    public static boolean isOreBlock(IBlockState block) {
        return WorldUtil.isOreBlock(block.func_177230_c());
    }

    public static float getAmbientTemperature(World world, BlockPos pos) {
        Biome biome = world.func_180494_b(pos);
        float temp = biome.func_180626_a(pos);
        if (world.func_175678_i(pos)) {
            temp = world.func_72935_r() ? (temp *= 1.35f) : (temp /= 1.35f);
            if (world.func_72896_J() && world.func_175725_q(pos).func_177956_o() < pos.func_177956_o()) {
                if (biome.func_76746_c()) {
                    temp /= 1.5f;
                } else if (biome.func_76738_d()) {
                    temp /= 1.25f;
                }
            }
        }
        return temp;
    }
}

