/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.utils;

import java.text.DecimalFormat;
import javax.annotation.Nonnull;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class StringUtil {
    public static TextComponentTranslation getLocale(String key) {
        return new TextComponentTranslation(key, new Object[0]);
    }

    public static TextComponentTranslation getColourLocale(String key, TextFormatting colour) {
        return (TextComponentTranslation)new TextComponentTranslation(key, new Object[0]).func_150255_a(new Style().func_150238_a(colour));
    }

    public static TextComponentTranslation getLocaleWithArguments(String key, String ... args) {
        return new TextComponentTranslation(key, (Object[])args);
    }

    public static TextComponentTranslation getColourLocaleWithArguments(String key, TextFormatting colour, String ... args) {
        return (TextComponentTranslation)new TextComponentTranslation(key, (Object[])args).func_150255_a(new Style().func_150238_a(colour));
    }

    @SideOnly(value=Side.CLIENT)
    public static String getLocaleString(String key) {
        return I18n.func_135052_a((String)key, (Object[])new Object[0]);
    }

    @SideOnly(value=Side.CLIENT)
    public static String getLocaleStringWithArguments(String key, String ... args) {
        return I18n.func_135052_a((String)key, (Object[])args);
    }

    @SideOnly(value=Side.CLIENT)
    public static String getColourLocaleString(String key, TextFormatting colour) {
        return colour + I18n.func_135052_a((String)key, (Object[])new Object[0]);
    }

    @SideOnly(value=Side.CLIENT)
    public static String getColourLocaleStringWithArguments(String key, TextFormatting colour, String ... args) {
        return colour + I18n.func_135052_a((String)key, (Object[])args);
    }

    public static void sendMessageWithinRadius(TextComponentTranslation msg, Entity center, int radius) {
        for (EntityPlayer pl : center.field_70170_p.func_72872_a(EntityPlayer.class, center.func_174813_aQ().func_186662_g((double)radius))) {
            pl.func_145747_a((ITextComponent)msg);
        }
    }

    public static String capitaliseFirstLetter(String string) {
        char firstLetter = Character.toTitleCase(string.charAt(0));
        return firstLetter + string.substring(1).toLowerCase();
    }

    public static String floorAndAppendSuffix(float value, boolean strictDigitCount) {
        String suffix = "";
        if (value >= 10000.0f) {
            if (value < 1000000.0f) {
                suffix = "k";
                value /= 1000.0f;
            } else if (value < 1.0E9f) {
                suffix = "m";
                value /= 1000000.0f;
            } else {
                suffix = "b";
                value /= 1.0E9f;
            }
        }
        if (strictDigitCount && value >= 10.0f) {
            value = (int)value;
        }
        return new DecimalFormat(strictDigitCount ? "#.#" : "#.##").format(value) + suffix;
    }

    public static String roundToNthDecimalPlace(float value, int decimals) {
        float val = (float)Math.round(value * (float)Math.pow(10.0, decimals)) / (float)Math.pow(10.0, decimals);
        if ((float)((int)val) == val) {
            return String.valueOf((int)val);
        }
        return String.valueOf(val);
    }

    public static String toTitleCase(@Nonnull String str) {
        int sz = str.length();
        StringBuilder buffer = new StringBuilder(sz);
        boolean space = true;
        for (int i = 0; i < sz; ++i) {
            char ch = str.charAt(i);
            if (Character.isWhitespace(ch) || ch == '_') {
                buffer.append(ch);
                space = true;
                continue;
            }
            if (space) {
                buffer.append(Character.toTitleCase(ch));
                space = false;
                continue;
            }
            buffer.append(ch);
        }
        return buffer.toString();
    }

    public static boolean isInteger(CharSequence chars) {
        if (chars == null || chars.length() == 0) {
            return false;
        }
        for (int i = 0; i < chars.length(); ++i) {
            if (Character.isDigit(chars.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static int toInteger(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static float toFloat(String string) {
        try {
            return Float.parseFloat(string);
        }
        catch (NumberFormatException e) {
            return 0.0f;
        }
    }
}

