/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.utils;

import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.client.gui.mainwindow.AdventGuiTabPlayer;
import net.tslat.aoa3.common.registration.ArmourRegister;
import net.tslat.aoa3.common.registration.EnchantmentsRegister;
import net.tslat.aoa3.hooks.ThirdPartyInteractions;
import net.tslat.aoa3.hooks.ic2.IC2Compat;
import net.tslat.aoa3.item.SkillItem;
import net.tslat.aoa3.item.misc.RuneItem;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.library.misc.AoAAttributes;
import net.tslat.aoa3.utils.StringUtil;
import net.tslat.aoa3.utils.player.PlayerDataManager;
import net.tslat.aoa3.utils.player.PlayerUtil;

public class ItemUtil {
    public static void setAttribute(Multimap<String, AttributeModifier> map, IAttribute att, UUID id, double value) {
        Collection modifiers = map.get((Object)att.func_111108_a());
        Optional<AttributeModifier> mod = modifiers.stream().filter(attributeModifier -> attributeModifier.func_111167_a().equals(id)).findFirst();
        if (mod.isPresent()) {
            AttributeModifier existingMod = mod.get();
            modifiers.remove(existingMod);
            modifiers.add(new AttributeModifier(existingMod.func_111167_a(), existingMod.func_111166_b(), value, existingMod.func_111169_c()));
        }
    }

    public static void multiplyAttribute(Multimap<String, AttributeModifier> map, IAttribute att, UUID id, double multiplier) {
        Collection modifiers = map.get((Object)att.func_111108_a());
        Optional<AttributeModifier> mod = modifiers.stream().filter(attributeModifier -> attributeModifier.func_111167_a().equals(id)).findFirst();
        if (mod.isPresent()) {
            AttributeModifier existingMod = mod.get();
            modifiers.remove(existingMod);
            modifiers.add(new AttributeModifier(existingMod.func_111167_a(), existingMod.func_111166_b(), existingMod.func_111164_d() * multiplier, existingMod.func_111169_c()));
        }
    }

    public static double getStackAttributeValue(ItemStack stack, IAttribute baseAttribute, EntityPlayer player, EntityEquipmentSlot equipmentSlot, UUID attributeUUID) {
        for (Map.Entry entry : stack.func_77973_b().getAttributeModifiers(equipmentSlot, stack).entries()) {
            AttributeModifier mod = (AttributeModifier)entry.getValue();
            if (!mod.func_111167_a().equals(attributeUUID)) continue;
            double value = mod.func_111164_d();
            if (mod.func_111167_a().equals(AoAAttributes.VANILLA_ATTACK_SPEED)) {
                value += player.func_110148_a(baseAttribute).func_111125_b();
            }
            return mod.func_111169_c() != 1 && mod.func_111169_c() != 2 ? value : value * 100.0;
        }
        return 0.0;
    }

    public static boolean checkCooledItemProc(EntityLivingBase holder, float percentageChance) {
        float percent = holder instanceof EntityPlayer ? AdventOfAscension.rand.nextFloat() / ((EntityPlayer)holder).func_184825_o(1.0E-6f) : AdventOfAscension.rand.nextFloat();
        return percentageChance > percent;
    }

    public static boolean findAndConsumeRunes(HashMap<RuneItem, Integer> runeMap, EntityPlayer player, boolean allowBuffs, @Nonnull ItemStack heldItem) {
        int amount;
        RuneItem type;
        if (player.field_71075_bZ.field_75098_d) {
            return true;
        }
        Enums.ArmourSets armour = PlayerUtil.getAdventPlayer(player).equipment().getCurrentFullArmourSet();
        int archmage = allowBuffs ? EnchantmentHelper.func_77506_a((Enchantment)EnchantmentsRegister.ARCHMAGE, (ItemStack)heldItem) : 0;
        boolean nightmareArmour = allowBuffs && armour == Enums.ArmourSets.NIGHTMARE;
        boolean greed = EnchantmentHelper.func_77506_a((Enchantment)EnchantmentsRegister.GREED, (ItemStack)heldItem) > 0;
        HashMap<RuneItem, Integer> requiredRunes = new HashMap<RuneItem, Integer>();
        for (Map.Entry<RuneItem, Integer> runeEntry : runeMap.entrySet()) {
            if (!allowBuffs || archmage == 0 && !nightmareArmour && !greed) {
                requiredRunes.putAll(runeMap);
                break;
            }
            int amount2 = runeEntry.getValue();
            if (greed) {
                amount2 += 2;
            }
            if (archmage > 0) {
                amount2 -= archmage;
            }
            if (nightmareArmour) {
                --amount2;
            }
            if (amount2 <= 0) {
                amount2 = 1;
            }
            requiredRunes.put(runeEntry.getKey(), amount2);
        }
        if (requiredRunes.isEmpty()) {
            return true;
        }
        HashSet<Integer> runeSlots = new HashSet<Integer>();
        HashMap<RuneItem, Integer> runeCounter = new HashMap<RuneItem, Integer>(requiredRunes);
        ItemStack mainHandStack = player.func_184586_b(EnumHand.OFF_HAND);
        ItemStack offHandStack = player.func_184586_b(EnumHand.MAIN_HAND);
        if (mainHandStack.func_77973_b() instanceof RuneItem && runeCounter.containsKey((Object)(type = (RuneItem)mainHandStack.func_77973_b()))) {
            amount = (Integer)runeCounter.get((Object)type);
            runeSlots.add(-1);
            if ((amount -= mainHandStack.func_190916_E()) > 0) {
                runeCounter.put(type, amount);
            } else {
                runeCounter.remove((Object)type);
            }
        }
        if (!runeCounter.isEmpty() && offHandStack.func_77973_b() instanceof RuneItem && runeCounter.containsKey((Object)(type = (RuneItem)offHandStack.func_77973_b()))) {
            amount = (Integer)runeCounter.get((Object)type);
            runeSlots.add(-2);
            if ((amount -= offHandStack.func_190916_E()) > 0) {
                runeCounter.put(type, amount);
            } else {
                runeCounter.remove((Object)type);
            }
        }
        if (!runeCounter.isEmpty()) {
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                RuneItem type2;
                ItemStack stack = player.field_71071_by.func_70301_a(i);
                if (!(stack.func_77973_b() instanceof RuneItem) || !runeCounter.containsKey((Object)(type2 = (RuneItem)stack.func_77973_b()))) continue;
                int amount3 = (Integer)runeCounter.get((Object)type2);
                runeSlots.add(i);
                if ((amount3 -= stack.func_190916_E()) > 0) {
                    runeCounter.put(type2, amount3);
                } else {
                    runeCounter.remove((Object)type2);
                }
                if (runeCounter.isEmpty()) break;
            }
        }
        if (runeCounter.isEmpty()) {
            int remaining;
            if (runeSlots.contains(-1)) {
                ItemStack rune = player.func_184586_b(EnumHand.MAIN_HAND);
                RuneItem type3 = (RuneItem)rune.func_77973_b();
                int amount4 = (Integer)requiredRunes.get((Object)type3);
                remaining = amount4 - rune.func_190916_E();
                rune.func_190918_g(amount4);
                if (remaining <= 0) {
                    requiredRunes.remove((Object)type3);
                } else {
                    requiredRunes.put(type3, remaining);
                }
                runeSlots.remove(-1);
            }
            if (runeSlots.contains(-2)) {
                ItemStack rune = player.func_184586_b(EnumHand.OFF_HAND);
                RuneItem type4 = (RuneItem)rune.func_77973_b();
                int amount5 = (Integer)requiredRunes.get((Object)type4);
                remaining = amount5 - rune.func_190916_E();
                rune.func_190918_g(amount5);
                if (remaining <= 0) {
                    requiredRunes.remove((Object)type4);
                } else {
                    requiredRunes.put(type4, remaining);
                }
                runeSlots.remove(-2);
            }
            Iterator iterator = runeSlots.iterator();
            while (iterator.hasNext()) {
                int slotId = (Integer)iterator.next();
                ItemStack rune = player.field_71071_by.func_70301_a(slotId);
                RuneItem type5 = (RuneItem)rune.func_77973_b();
                int amount6 = (Integer)requiredRunes.get((Object)type5);
                int remaining2 = amount6 - rune.func_190916_E();
                rune.func_190918_g(amount6);
                if (remaining2 <= 0) {
                    requiredRunes.remove((Object)type5);
                } else {
                    requiredRunes.put(type5, remaining2);
                }
                if (!requiredRunes.isEmpty()) continue;
                break;
            }
            return true;
        }
        return false;
    }

    public static ItemStack removeEnchantment(ItemStack stack, Enchantment ench) {
        ItemStack newStack = stack.func_77946_l();
        Map enchants = EnchantmentHelper.func_82781_a((ItemStack)newStack);
        if (enchants.containsKey(ench)) {
            enchants.remove(ench);
            EnchantmentHelper.func_82782_a((Map)enchants, (ItemStack)newStack);
        }
        return newStack;
    }

    public static void givePlayerMultipleItems(EntityPlayer pl, ItemStack ... stacks) {
        ItemUtil.givePlayerMultipleItems(pl, Arrays.asList(stacks));
    }

    public static void givePlayerMultipleItems(EntityPlayer pl, Collection<ItemStack> stacks) {
        for (ItemStack stack : stacks) {
            if (pl.field_71071_by.func_70441_a(stack)) continue;
            pl.func_70099_a(stack, 0.5f);
        }
        pl.field_71069_bz.func_75142_b();
    }

    public static void givePlayerItemOrDrop(EntityPlayer player, ItemStack stack) {
        if (stack.func_190926_b()) {
            return;
        }
        if (!player.field_71071_by.func_70441_a(stack)) {
            player.func_70099_a(stack, 0.5f);
        }
        player.field_71069_bz.func_75142_b();
    }

    @Nullable
    public static Item findInventoryItemType(EntityPlayer player, Class<? extends Item> itemType, boolean consumeItem, int amount) {
        if (amount <= 0) {
            return null;
        }
        if (amount == 1) {
            ItemStack checkStack = player.func_184586_b(EnumHand.MAIN_HAND);
            if (itemType.isInstance(checkStack.func_77973_b()) && !checkStack.func_190926_b()) {
                if (consumeItem && !player.field_71075_bZ.field_75098_d) {
                    checkStack.func_190918_g(1);
                }
                return checkStack.func_77973_b();
            }
            checkStack = player.func_184586_b(EnumHand.OFF_HAND);
            if (itemType.isInstance(checkStack.func_77973_b()) && !checkStack.func_190926_b()) {
                if (consumeItem && !player.field_71075_bZ.field_75098_d) {
                    checkStack.func_190918_g(1);
                }
                return checkStack.func_77973_b();
            }
            for (ItemStack checkStack2 : player.field_71071_by.field_70462_a) {
                if (checkStack2.func_190926_b() || !itemType.isInstance(checkStack2.func_77973_b())) continue;
                if (consumeItem && !player.field_71075_bZ.field_75098_d) {
                    checkStack2.func_190918_g(1);
                }
                return checkStack2.func_77973_b();
            }
            for (ItemStack checkStack2 : player.field_71071_by.field_70460_b) {
                if (checkStack2.func_190926_b() || !itemType.isInstance(checkStack2.func_77973_b())) continue;
                if (consumeItem && !player.field_71075_bZ.field_75098_d) {
                    checkStack2.func_190918_g(1);
                }
                return checkStack2.func_77973_b();
            }
            return null;
        }
        ArrayList<ItemStack> matchedStacks = new ArrayList<ItemStack>();
        int foundCount = 0;
        ItemStack checkStack = player.func_184586_b(EnumHand.MAIN_HAND);
        if (itemType.isInstance(checkStack.func_77973_b()) && !checkStack.func_190926_b()) {
            matchedStacks.add(checkStack);
            foundCount += checkStack.func_190916_E();
        }
        if (foundCount < amount && itemType.isInstance((checkStack = player.func_184586_b(EnumHand.OFF_HAND)).func_77973_b()) && !checkStack.func_190926_b()) {
            matchedStacks.add(checkStack);
            foundCount += checkStack.func_190916_E();
        }
        if (foundCount < amount) {
            for (ItemStack checkStack2 : player.field_71071_by.field_70462_a) {
                if (checkStack2.func_190926_b() || !itemType.isInstance(checkStack2.func_77973_b())) continue;
                matchedStacks.add(checkStack2);
                if ((foundCount += checkStack2.func_190916_E()) < amount) continue;
                break;
            }
        }
        if (foundCount < amount) {
            for (ItemStack checkStack2 : player.field_71071_by.field_70460_b) {
                if (checkStack2.func_190926_b() || !itemType.isInstance(checkStack2.func_77973_b())) continue;
                matchedStacks.add(checkStack2);
                if ((foundCount += checkStack2.func_190916_E()) < amount) continue;
                break;
            }
        }
        if (foundCount < amount) {
            return null;
        }
        Item matchedItem = ((ItemStack)matchedStacks.get(0)).func_77973_b();
        if (!consumeItem || player.field_71075_bZ.field_75098_d) {
            return matchedItem;
        }
        for (ItemStack matchedStack : matchedStacks) {
            int consumeAmount = Math.min(matchedStack.func_190916_E(), foundCount);
            matchedStack.func_190918_g(consumeAmount);
            foundCount -= consumeAmount;
        }
        return matchedItem;
    }

    public static boolean findInventoryItem(EntityPlayer player, ItemStack stack, boolean consumeItem, int amount) {
        if (stack.func_190926_b()) {
            return false;
        }
        if (amount <= 0 || player.func_184812_l_()) {
            return true;
        }
        if (amount == 1) {
            ItemStack checkStack = player.func_184586_b(EnumHand.MAIN_HAND);
            if (ItemUtil.areStacksFunctionallyEqual(checkStack, stack) && !checkStack.func_190926_b()) {
                if (consumeItem && !player.field_71075_bZ.field_75098_d) {
                    checkStack.func_190918_g(1);
                }
                return true;
            }
            checkStack = player.func_184586_b(EnumHand.OFF_HAND);
            if (ItemUtil.areStacksFunctionallyEqual(checkStack, stack) && !checkStack.func_190926_b()) {
                if (consumeItem && !player.field_71075_bZ.field_75098_d) {
                    checkStack.func_190918_g(1);
                }
                return true;
            }
            for (ItemStack checkStack2 : player.field_71071_by.field_70462_a) {
                if (checkStack2.func_190926_b() || !ItemUtil.areStacksFunctionallyEqual(stack, checkStack2)) continue;
                if (consumeItem && !player.field_71075_bZ.field_75098_d) {
                    checkStack2.func_190918_g(1);
                }
                return true;
            }
            for (ItemStack checkStack2 : player.field_71071_by.field_70460_b) {
                if (checkStack2.func_190926_b() || !ItemUtil.areStacksFunctionallyEqual(stack, checkStack2)) continue;
                if (consumeItem && !player.field_71075_bZ.field_75098_d) {
                    checkStack2.func_190918_g(1);
                }
                return true;
            }
            return false;
        }
        ArrayList<ItemStack> matchedStacks = new ArrayList<ItemStack>();
        int foundCount = 0;
        ItemStack checkStack = player.func_184586_b(EnumHand.MAIN_HAND);
        if (ItemUtil.areStacksFunctionallyEqual(checkStack, stack) && !checkStack.func_190926_b()) {
            matchedStacks.add(checkStack);
            foundCount += checkStack.func_190916_E();
        }
        if (foundCount < amount && ItemUtil.areStacksFunctionallyEqual(checkStack = player.func_184586_b(EnumHand.OFF_HAND), stack) && !checkStack.func_190926_b()) {
            matchedStacks.add(checkStack);
            foundCount += checkStack.func_190916_E();
        }
        if (foundCount < amount) {
            for (ItemStack checkStack2 : player.field_71071_by.field_70462_a) {
                if (checkStack2.func_190926_b() || !ItemUtil.areStacksFunctionallyEqual(stack, checkStack2)) continue;
                matchedStacks.add(checkStack2);
                if ((foundCount += checkStack2.func_190916_E()) < amount) continue;
                break;
            }
        }
        if (foundCount < amount) {
            for (ItemStack checkStack2 : player.field_71071_by.field_70460_b) {
                if (checkStack2.func_190926_b() || !ItemUtil.areStacksFunctionallyEqual(stack, checkStack2)) continue;
                matchedStacks.add(checkStack2);
                if ((foundCount += checkStack2.func_190916_E()) < amount) continue;
                break;
            }
        }
        if (foundCount < amount) {
            return false;
        }
        if (!consumeItem || player.field_71075_bZ.field_75098_d) {
            return true;
        }
        for (ItemStack matchedStack : matchedStacks) {
            int consumeAmount = Math.min(matchedStack.func_190916_E(), Math.min(amount, foundCount));
            matchedStack.func_190918_g(consumeAmount);
            foundCount -= consumeAmount;
        }
        return true;
    }

    public static boolean areStacksFunctionallyEqual(ItemStack a, ItemStack b) {
        if (a.func_77973_b() != b.func_77973_b()) {
            return false;
        }
        if (a.func_77984_f() ^ b.func_77984_f()) {
            return false;
        }
        if (!a.func_77984_f() && a.func_77952_i() != b.func_77952_i()) {
            return false;
        }
        return !a.func_77942_o() ? !b.func_77942_o() : b.func_77942_o() && a.func_77978_p().equals((Object)b.func_77978_p());
    }

    public static String getFormattedDescriptionText(String langKey, Enums.ItemDescriptionType type, String ... args) {
        return StringUtil.getColourLocaleStringWithArguments(langKey, type.format, args);
    }

    public static String getFormattedDescriptionText(String langKey, Enums.ItemDescriptionType type) {
        return StringUtil.getColourLocaleString(langKey, type.format);
    }

    @SideOnly(value=Side.CLIENT)
    public static String getFormattedLevelRestrictedDescriptionText(Enums.Skills skill, int levelReq) {
        boolean meetsReq = Minecraft.func_71410_x().field_71439_g != null && Minecraft.func_71410_x().field_71439_g.field_71075_bZ.field_75098_d || AdventGuiTabPlayer.getSkillLevel(skill) >= levelReq;
        return StringUtil.getColourLocaleStringWithArguments("items.description.skillRequirement", meetsReq ? TextFormatting.GREEN : TextFormatting.RED, Integer.toString(levelReq), StringUtil.getLocaleString("skills." + skill.toString().toLowerCase() + ".name"));
    }

    public static boolean hasLevelForItem(Item item, PlayerDataManager plData) {
        if (item == null) {
            return false;
        }
        if (plData.player().field_71075_bZ.field_75098_d || !(item instanceof SkillItem)) {
            return true;
        }
        SkillItem skillItem = (SkillItem)item;
        return skillItem.getLevelReq() <= plData.stats().getLevel(skillItem.getSkill());
    }

    @Nullable
    public static ItemStack getStackFromHotbar(EntityPlayer player, Item item) {
        for (int i = 0; i < 9; ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (stack.func_77973_b() != item) continue;
            return stack;
        }
        return null;
    }

    public static int findItemInInventory(EntityPlayer player, Item item) {
        int i = 0;
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (stack.func_77973_b() == item) {
                return i;
            }
            ++i;
        }
        for (ItemStack stack : player.field_71071_by.field_70460_b) {
            if (stack.func_77973_b() == item) {
                return i;
            }
            ++i;
        }
        for (ItemStack stack : player.field_71071_by.field_184439_c) {
            if (stack.func_77973_b() == item) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Nullable
    public static ItemStack getStackFromInventory(EntityPlayer player, Item item) {
        int i = ItemUtil.findItemInInventory(player, item);
        if (i < 0) {
            return null;
        }
        return player.field_71071_by.func_70301_a(i);
    }

    public static boolean isHoldingItem(EntityLivingBase entity, Item item) {
        return entity.func_184614_ca().func_77973_b() == item || entity.func_184592_cb().func_77973_b() == item;
    }

    public static boolean isPlayerEnvironmentallyProtected(EntityPlayer player) {
        if (PlayerUtil.isWearingFullSet(player, Enums.ArmourSets.HAZMAT) || ((ItemStack)player.field_71071_by.field_70460_b.get(EntityEquipmentSlot.HEAD.func_188454_b())).func_77973_b() == ArmourRegister.FACE_MASK) {
            return true;
        }
        if (ThirdPartyInteractions.isIc2Active()) {
            return IC2Compat.getCompatTool().isPlayerEnvironmentallyProtected(player);
        }
        return false;
    }
}

