/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.spi.FileSystemProvider;
import java.util.Collections;
import java.util.Iterator;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.Loader;
import net.tslat.aoa3.advent.AdventOfAscension;
import org.apache.commons.io.FilenameUtils;
import org.apache.logging.log4j.Level;

public class FileUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void walkAllAvailableResourceFiles(String fileType, String modId, String folderPath, @Nullable String backupFolderPath, Consumer<BufferedReader> consumer) {
        Object modContainer = Loader.instance().getIndexedModList().get(modId);
        boolean fallbackRequired = false;
        if (modContainer == null) {
            AdventOfAscension.logMessage(Level.ERROR, "Unable to find mod with domain: " + modId);
            return;
        }
        URL resourceURL = modContainer.getClass().getResource("/assets/" + modId + "/" + folderPath);
        if (resourceURL == null) {
            if (backupFolderPath != null) {
                resourceURL = modContainer.getClass().getResource("/assets/" + modId + "/" + backupFolderPath);
            }
            if (resourceURL == null) {
                AdventOfAscension.logOptionalMessage("Unable to find resource from mod " + modId + " with path: " + folderPath + (backupFolderPath != null ? " or backup path: " + backupFolderPath : ""));
                return;
            }
            fallbackRequired = true;
        }
        FileSystem fs = null;
        try {
            Path path;
            URI resourceURI = resourceURL.toURI();
            if ("file".equalsIgnoreCase(resourceURI.getScheme())) {
                path = Paths.get(resourceURI);
            } else {
                fs = FileUtil.safelyGetFileSystem(resourceURI);
                if (fs == null) {
                    throw new FileSystemNotFoundException();
                }
                path = fs.getPath("/assets/" + modId + "/" + (fallbackRequired ? backupFolderPath : folderPath), new String[0]);
            }
            Iterator resourceFiles = Files.walk(path, new FileVisitOption[0]).iterator();
            while (resourceFiles.hasNext()) {
                Path resourcePath = (Path)resourceFiles.next();
                if (!fileType.equals(FilenameUtils.getExtension((String)resourcePath.toString()))) continue;
                BufferedReader reader = Files.newBufferedReader(resourcePath);
                Throwable throwable = null;
                try {
                    consumer.accept(reader);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (reader == null) continue;
                    if (throwable != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    reader.close();
                }
            }
        }
        catch (URISyntaxException ex) {
            AdventOfAscension.logMessage(Level.ERROR, "Invalid URI syntax for resource search. Mod ID: " + modId + ", path: " + resourceURL.toString());
            ex.printStackTrace();
        }
        catch (IOException ex) {
            AdventOfAscension.logMessage(Level.ERROR, "Error reading resource file during file walk. Mod ID: " + modId + ", path: " + resourceURL.toString());
        }
        catch (FileSystemNotFoundException ex) {
            AdventOfAscension.logOptionalMessage("FileSystem error - somehow managed to find an existing filesystem without one present.", ex);
        }
        finally {
            try {
                if (fs != null) {
                    fs.close();
                }
            }
            catch (IOException ex) {
                AdventOfAscension.logOptionalMessage("Failed to close filesystem after file walk. This could be an issue.", ex);
            }
        }
    }

    public static void walkAllAvailableFiles(String fileType, String folderPath, @Nullable String backupFolderPath, Consumer<BufferedReader> consumer) {
        File folder = new File(FilenameUtils.separatorsToSystem((String)folderPath));
        if (!folder.exists()) {
            if (backupFolderPath != null) {
                folder = new File(FilenameUtils.separatorsToSystem((String)backupFolderPath));
            }
            if (!folder.exists()) {
                AdventOfAscension.logOptionalMessage("Unable to find folder for file walk: " + folderPath + (backupFolderPath != null ? ". Also tried backup location: " + backupFolderPath : ""));
                return;
            }
            if (!folder.isDirectory()) {
                AdventOfAscension.logOptionalMessage("Filepath does not point to valid directory: " + folderPath);
                return;
            }
        }
        try {
            Iterator files = Files.walk(folder.toPath(), new FileVisitOption[0]).iterator();
            while (files.hasNext()) {
                Path filePath = (Path)files.next();
                if (!fileType.equals(FilenameUtils.getExtension((String)filePath.toString()))) continue;
                BufferedReader reader = Files.newBufferedReader(filePath);
                Throwable throwable = null;
                try {
                    consumer.accept(reader);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (reader == null) continue;
                    if (throwable != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    reader.close();
                }
            }
        }
        catch (IOException ex) {
            AdventOfAscension.logOptionalMessage("Error reading file during file walk. Path: " + folder.getAbsolutePath(), ex);
        }
    }

    /*
     * Exception decompiling
     */
    @Nullable
    public static String getTextFromResourceFile(String modId, String assetFilePath, @Nullable String backupFilePath) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static String getTextFromFile(String filePath, @Nullable String backupFilePath) {
        File file = new File(FilenameUtils.separatorsToSystem((String)filePath));
        if (!file.exists()) {
            if (backupFilePath != null) {
                file = new File(FilenameUtils.separatorsToSystem((String)backupFilePath));
            }
            if (!file.exists()) {
                AdventOfAscension.logOptionalMessage("Unable to find requested file: " + filePath + (backupFilePath != null ? ". Also tried to find " + backupFilePath : ""));
                return null;
            }
        }
        try (BufferedReader reader = Files.newBufferedReader(file.toPath());){
            String string = FileUtil.bufferedReaderToString(reader);
            return string;
        }
        catch (IOException ex) {
            AdventOfAscension.logOptionalMessage("Error reading file: " + file.getAbsolutePath(), ex);
            return null;
        }
    }

    public static String bufferedReaderToString(BufferedReader reader) {
        StringBuilder content = new StringBuilder();
        reader.lines().forEach(line -> {
            content.append((String)line);
            content.append("\n");
        });
        return content.toString();
    }

    @Nullable
    private static FileSystem safelyGetFileSystem(URI uri) throws IOException {
        String scheme = uri.getScheme();
        try {
            for (FileSystemProvider provider : FileSystemProvider.installedProviders()) {
                if (!scheme.equalsIgnoreCase(provider.getScheme())) continue;
                return provider.getFileSystem(uri);
            }
        }
        catch (FileSystemNotFoundException ex) {
            return FileSystems.newFileSystem(uri, Collections.emptyMap());
        }
        return null;
    }
}

