/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.utils;

import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.item.EntityEnderCrystal;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityFlying;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.MobEffects;
import net.minecraft.pathfinding.PathNavigateFlying;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.entity.misc.EntityBossItem;
import net.tslat.aoa3.entity.properties.BossEntity;
import net.tslat.aoa3.entity.properties.SpecialPropertyEntity;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.skills.HunterUtil;

public class EntityUtil {
    public static float getCurrentHealthPercent(EntityLivingBase entity) {
        return entity.func_110143_aJ() / entity.func_110138_aP();
    }

    public static boolean checkAboveHealthPercentThreshold(EntityLivingBase entity, float thresholdPercent) {
        if (entity.func_110143_aJ() <= 0.0f) {
            return false;
        }
        return EntityUtil.getCurrentHealthPercent(entity) >= thresholdPercent;
    }

    public static boolean checkBelowHealthPercentThreshold(EntityLivingBase entity, float thresholdPercent) {
        if (entity.func_110143_aJ() <= 0.0f) {
            return false;
        }
        return EntityUtil.getCurrentHealthPercent(entity) < thresholdPercent;
    }

    public static void healEntity(EntityLivingBase entity, float healAmount) {
        if (!entity.field_70128_L && entity.func_110143_aJ() > 0.0f && entity.func_110143_aJ() < entity.func_110138_aP()) {
            entity.func_70691_i(healAmount);
        }
    }

    public static void killEntityCleanly(Entity entity) {
        if (!(entity instanceof EntityLivingBase)) {
            entity.func_70097_a(DamageSource.field_76380_i, Float.MAX_VALUE);
            entity.func_70106_y();
            return;
        }
        EntityLivingBase target = (EntityLivingBase)entity;
        target.func_70097_a(new DamageSource("magic").func_76348_h().func_151518_m().func_82726_p(), ((EntityLivingBase)entity).func_110143_aJ());
        if (target.func_110143_aJ() > 0.0f) {
            target.func_70606_j(0.0f);
        }
    }

    public static boolean dealAoeDamage(@Nullable Entity indirectSource, EntityLivingBase attacker, Entity target, float dmg, boolean bypassProtections) {
        DamageSource damageSource;
        if (indirectSource != null) {
            damageSource = new EntityDamageSourceIndirect("aoe", indirectSource, (Entity)attacker).func_82726_p();
        } else {
            DamageSource damageSource2 = damageSource = attacker instanceof EntityPlayer ? DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)attacker)) : DamageSource.func_76358_a((EntityLivingBase)attacker);
        }
        if (bypassProtections) {
            damageSource.func_76348_h();
            damageSource.func_151518_m();
        }
        if (target.func_180431_b(damageSource)) {
            return false;
        }
        if (target instanceof EntityLivingBase && !HunterUtil.canAttackTarget((EntityLivingBase)target, (Entity)attacker, false)) {
            return false;
        }
        target.field_70172_ad = 0;
        return target.func_70097_a(damageSource, dmg);
    }

    public static boolean dealBlasterDamage(EntityLivingBase attacker, Entity target, Entity shot, float dmg, boolean bypassProtections) {
        EntityDamageSourceIndirect damageSource = new EntityDamageSourceIndirect("blaster", shot, (Entity)attacker);
        damageSource.func_82726_p();
        if (!(target instanceof EntityPlayer)) {
            damageSource.func_76348_h();
        }
        if (bypassProtections) {
            damageSource.func_151518_m();
            damageSource.func_76348_h();
        }
        if (target.func_180431_b((DamageSource)damageSource) || EntityUtil.checkMobProperty(target, Enums.MobProperties.BLASTER_IMMUNE)) {
            return false;
        }
        if (target instanceof MultiPartEntityPart || target instanceof EntityEnderCrystal) {
            return target.func_70097_a((DamageSource)damageSource, dmg);
        }
        if (!(target instanceof EntityLivingBase)) {
            return false;
        }
        if (!HunterUtil.canAttackTarget((EntityLivingBase)target, (Entity)attacker, true)) {
            return false;
        }
        target.field_70172_ad = 0;
        double velocityX = target.field_70159_w;
        double velocityY = target.field_70181_x;
        double velocityZ = target.field_70179_y;
        boolean success = target.func_70097_a((DamageSource)damageSource, dmg);
        target.field_70159_w = velocityX;
        target.field_70181_x = velocityY;
        target.field_70179_y = velocityZ;
        target.field_70133_I = false;
        return success;
    }

    public static boolean dealMeleeDamage(EntityLivingBase attacker, Entity target, float dmg, boolean bypassProtections) {
        DamageSource damageSource;
        DamageSource damageSource2 = damageSource = attacker instanceof EntityPlayer ? DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)attacker)) : DamageSource.func_76358_a((EntityLivingBase)attacker);
        if (target.func_180431_b(damageSource) || EntityUtil.checkMobProperty(target, Enums.MobProperties.MELEE_IMMUNE)) {
            return false;
        }
        if (bypassProtections) {
            damageSource.func_76348_h();
            damageSource.func_151518_m();
        }
        if (target instanceof EntityLivingBase && !HunterUtil.canAttackTarget((EntityLivingBase)target, (Entity)attacker, true)) {
            return false;
        }
        target.field_70172_ad = 0;
        boolean success = target.func_70097_a(damageSource, dmg);
        target.field_70172_ad = 0;
        return success;
    }

    public static boolean dealMagicDamage(@Nullable Entity indirectSource, EntityLivingBase attacker, Entity target, float dmg, boolean bypassProtections) {
        Object damageSource = indirectSource != null ? new EntityDamageSourceIndirect("magic", indirectSource, (Entity)attacker) : (attacker instanceof EntityPlayer ? DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)attacker)) : DamageSource.func_76358_a((EntityLivingBase)attacker));
        damageSource.func_82726_p();
        if (!(target instanceof EntityPlayer)) {
            damageSource.func_76348_h();
        }
        if (bypassProtections) {
            damageSource.func_151518_m();
        }
        if (target.func_180431_b(damageSource) || EntityUtil.checkMobProperty(target, Enums.MobProperties.MAGIC_IMMUNE)) {
            return false;
        }
        if (target instanceof MultiPartEntityPart || target instanceof EntityEnderCrystal) {
            return target.func_70097_a(damageSource, dmg);
        }
        if (!(target instanceof EntityLivingBase)) {
            return false;
        }
        if (!HunterUtil.canAttackTarget((EntityLivingBase)target, (Entity)attacker, true)) {
            return false;
        }
        target.field_70172_ad = 0;
        return target.func_70097_a(damageSource, dmg);
    }

    public static void dealSelfHarmDamage(EntityLivingBase target, float dmg) {
        if (target instanceof EntityPlayer && ((EntityPlayer)target).field_71075_bZ.field_75098_d) {
            return;
        }
        if (target.func_110143_aJ() - dmg > 0.0f) {
            target.func_70606_j(target.func_110143_aJ() - dmg);
        } else {
            target.field_70172_ad = 0;
            target.func_70097_a(new DamageSource("selfharm").func_151518_m().func_76348_h(), dmg);
        }
    }

    public static boolean dealGunDamage(Entity target, EntityLivingBase attacker, EntityThrowable bullet, float dmg) {
        boolean success;
        DamageSource source = new EntityDamageSourceIndirect("gun", (Entity)bullet, (Entity)attacker).func_76349_b();
        if (target.func_180431_b(source) || EntityUtil.checkMobProperty(target, Enums.MobProperties.GUN_IMMUNE)) {
            return false;
        }
        if (target instanceof MultiPartEntityPart || target instanceof EntityEnderCrystal) {
            return target.func_70097_a(source, dmg);
        }
        if (!(target instanceof EntityLivingBase)) {
            return false;
        }
        if (!HunterUtil.canAttackTarget((EntityLivingBase)target, (Entity)attacker, true)) {
            return false;
        }
        target.field_70172_ad = 0;
        if (AdventOfAscension.rand.nextInt(10) < 6) {
            double velocityX = target.field_70159_w;
            double velocityY = target.field_70181_x;
            double velocityZ = target.field_70179_y;
            success = target.func_70097_a(source, dmg);
            target.field_70159_w = velocityX;
            target.field_70181_x = velocityY;
            target.field_70179_y = velocityZ;
            target.field_70133_I = false;
        } else {
            success = target.func_70097_a(source, dmg);
            target.field_70133_I = true;
        }
        return success;
    }

    public static boolean dealVulcaneDamage(EntityLivingBase target, EntityPlayer attacker, float dmg) {
        DamageSource source = DamageSource.func_76365_a((EntityPlayer)attacker).func_151518_m().func_76348_h();
        if (target.func_180431_b(source)) {
            return false;
        }
        if (!HunterUtil.canAttackTarget(target, (Entity)attacker, false)) {
            return false;
        }
        target.field_70172_ad = 0;
        return target.func_70097_a(source, dmg);
    }

    public static boolean dealRangedDamage(Entity target, EntityLivingBase attacker, Entity projectile, float dmg) {
        DamageSource source = DamageSource.func_76356_a((Entity)projectile, (Entity)attacker);
        if (target.func_180431_b(source) || (projectile instanceof EntityArrow || projectile instanceof EntityThrowable) && EntityUtil.checkMobProperty(target, Enums.MobProperties.RANGED_IMMUNE)) {
            return false;
        }
        if (target instanceof MultiPartEntityPart || target instanceof EntityEnderCrystal) {
            return target.func_70097_a(source, dmg);
        }
        if (!(target instanceof EntityLivingBase)) {
            return false;
        }
        if (!HunterUtil.canAttackTarget((EntityLivingBase)target, (Entity)attacker, true)) {
            return false;
        }
        target.field_70172_ad = 0;
        target.field_70133_I = true;
        return target.func_70097_a(source, dmg);
    }

    public static boolean isSpecExempt(Entity target, EntityLivingBase attacker) {
        if (target instanceof EntityLivingBase && !HunterUtil.canAttackTarget((EntityLivingBase)target, (Entity)attacker, false)) {
            return true;
        }
        return target instanceof EntityPlayer || target instanceof EntityWither || target instanceof EntityDragon || target instanceof BossEntity || target.func_190530_aW() || target instanceof EntityLivingBase && ((EntityLivingBase)target).func_110138_aP() > 500.0f;
    }

    public static void doScaledKnockback(EntityLivingBase target, Entity attacker, float strength, double xRatio, double zRatio) {
        if (target instanceof EntityPlayer && ((EntityPlayer)target).field_71075_bZ.field_75098_d) {
            return;
        }
        LivingKnockBackEvent event = ForgeHooks.onLivingKnockBack((EntityLivingBase)target, (Entity)attacker, (float)strength, (double)xRatio, (double)zRatio);
        if (event.isCanceled()) {
            return;
        }
        strength = event.getStrength() * (float)(1.0 - target.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111126_e());
        xRatio = event.getRatioX();
        zRatio = event.getRatioZ();
        target.field_70160_al = true;
        target.field_70133_I = true;
        float f = MathHelper.func_76133_a((double)(xRatio * xRatio + zRatio * zRatio));
        target.field_70159_w /= 2.0;
        target.field_70179_y /= 2.0;
        target.field_70159_w -= xRatio / (double)f * (double)strength;
        target.field_70179_y -= zRatio / (double)f * (double)strength;
        if (target.field_70122_E) {
            target.field_70181_x /= 2.0;
            target.field_70181_x += (double)strength;
            if (target.field_70181_x > (double)0.4f) {
                target.field_70181_x = 0.4f;
            }
        }
    }

    public static boolean isMeleeDamage(DamageSource source) {
        return source.func_76346_g() != null && !source.func_76352_a() && !source.func_76355_l().equals("thrown") && !source.func_82725_o() && !source.func_94541_c() && !source.func_76347_k() && source.func_76364_f() == source.func_76346_g();
    }

    public static boolean isBlasterDamage(DamageSource source) {
        return source.func_76355_l().equals("blaster") && source.func_82725_o();
    }

    public static boolean isMagicDamage(DamageSource source, Entity target, float dmg) {
        return source.func_82725_o() && !source.func_76355_l().equals("blaster") && !source.func_76355_l().equals("thorns") && (!(target instanceof EntityLivingBase) || !EntityUtil.isPoisonDamage(source, target, dmg));
    }

    public static boolean isRangedDamage(DamageSource source, Entity target, float dmg) {
        return (source.func_76352_a() && !source.func_76355_l().equals("gun") || source.func_76355_l().equals("thrown")) && !EntityUtil.isMagicDamage(source, target, dmg);
    }

    public static boolean isGunDamage(DamageSource source) {
        return source.func_76355_l().equals("gun") && source.func_76352_a();
    }

    public static boolean isPoisonDamage(DamageSource source, Entity target, float dmg) {
        return source.func_82725_o() && source.func_76346_g() == null && !source.func_76355_l().equals("thorns") && target instanceof EntityLivingBase && ((EntityLivingBase)target).func_70644_a(MobEffects.field_76436_u) && dmg == 1.0f;
    }

    public static boolean isPhysicalDamage(DamageSource source, Entity target, float dmg) {
        return !EntityUtil.isPoisonDamage(source, target, dmg) && !source.func_82725_o() && !source.func_94541_c() && source != DamageSource.field_82727_n && source != DamageSource.field_76380_i && !source.func_76347_k() && source != DamageSource.field_76366_f;
    }

    public static boolean isEnvironmentalDamage(DamageSource source) {
        if (source.func_76346_g() != null || source.func_94541_c()) {
            return false;
        }
        switch (source.func_76355_l()) {
            case "onFire": 
            case "inFire": 
            case "cactus": 
            case "acid": 
            case "lightningBolt": 
            case "lava": 
            case "cramming": 
            case "inWall": 
            case "fallingBlock": 
            case "starve": 
            case "anvil": 
            case "outOfWorld": {
                return true;
            }
        }
        return false;
    }

    public static BlockPos getBlockAimingAt(EntityPlayer pl, double distance) {
        float angleZ;
        float sinPitch;
        float cosPitch;
        Vec3d startVec = new Vec3d(pl.field_70165_t, pl.field_70163_u + (double)pl.func_70047_e(), pl.field_70161_v);
        float cosYaw = MathHelper.func_76134_b((float)(-pl.field_70177_z * ((float)Math.PI / 180) - (float)Math.PI));
        float sinYaw = MathHelper.func_76126_a((float)(-pl.field_70177_z * ((float)Math.PI / 180) - (float)Math.PI));
        float angleX = sinYaw * (cosPitch = -MathHelper.func_76134_b((float)(-pl.field_70125_A * ((float)Math.PI / 180))));
        Vec3d endVec = startVec.func_72441_c((double)angleX * distance, (double)(sinPitch = MathHelper.func_76126_a((float)(-pl.field_70125_A * ((float)Math.PI / 180)))) * distance, (double)(angleZ = cosYaw * cosPitch) * distance);
        RayTraceResult ray = pl.field_70170_p.func_147447_a(startVec, endVec, true, true, false);
        if (ray == null) {
            return null;
        }
        return ray.func_178782_a();
    }

    public static boolean isHostileMob(Entity mob) {
        return mob instanceof IMob;
    }

    public static EnumFacing getDirectionFacing(Entity entity, boolean lateralOnly) {
        if (!lateralOnly) {
            if (entity.field_70125_A < -50.0f) {
                return EnumFacing.DOWN;
            }
            if (entity.field_70125_A > 50.0f) {
                return EnumFacing.UP;
            }
        }
        int vec = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        switch (++vec % 4) {
            case 0: {
                return EnumFacing.EAST;
            }
            case 1: {
                return EnumFacing.SOUTH;
            }
            case 2: {
                return EnumFacing.WEST;
            }
        }
        return EnumFacing.NORTH;
    }

    public static boolean checkMobProperty(Entity entity, Enums.MobProperties property) {
        return entity instanceof SpecialPropertyEntity && ((SpecialPropertyEntity)entity).getMobProperties().contains((Object)property);
    }

    public static boolean isPlayerLookingAtEntity(EntityPlayer pl, Entity target) {
        return EntityUtil.isPlayerLookingAt(pl, target.field_70165_t, target.func_174813_aQ().field_72338_b + (double)target.field_70131_O / 2.0, target.field_70161_v) && pl.func_70685_l(target);
    }

    public static boolean isPlayerLookingAt(EntityPlayer pl, double posX, double posY, double posZ) {
        Vec3d playerLookVec = pl.func_70040_Z().func_72432_b();
        Vec3d requiredLookVec = new Vec3d(posX - pl.field_70165_t, posY - (pl.field_70163_u + (double)pl.func_70047_e()), posZ - pl.field_70161_v);
        double requiredLookVecLength = requiredLookVec.func_72433_c();
        double vecDotProduct = playerLookVec.func_72430_b(requiredLookVec = requiredLookVec.func_72432_b());
        return vecDotProduct > 1.0 - 0.025 / requiredLookVecLength;
    }

    public static EntityBossItem newBossEntityItemFromExisting(EntityItem item, EntityPlayer player) {
        EntityBossItem bossItem = new EntityBossItem(item.field_70170_p, player.field_70165_t, player.field_70163_u - 0.3 + (double)player.func_70047_e(), player.field_70161_v, item.func_92059_d(), player);
        bossItem.func_174867_a(10);
        bossItem.func_145799_b(player.func_70005_c_());
        bossItem.field_70159_w = -MathHelper.func_76126_a((float)(player.field_70177_z * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(player.field_70125_A * ((float)Math.PI / 180))) * 0.3f;
        bossItem.field_70179_y = MathHelper.func_76134_b((float)(player.field_70177_z * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(player.field_70125_A * ((float)Math.PI / 180))) * 0.3f;
        bossItem.field_70181_x = -MathHelper.func_76126_a((float)(player.field_70125_A * ((float)Math.PI / 180))) * 0.3f + 0.1f;
        Random rand = player.func_70681_au();
        float angleMod = rand.nextFloat() * (float)Math.PI * 2.0f;
        float velocityMod = 0.02f * rand.nextFloat();
        bossItem.field_70159_w += Math.cos(angleMod) * (double)velocityMod;
        bossItem.field_70181_x += (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f);
        bossItem.field_70179_y += Math.sin(angleMod) * (double)velocityMod;
        item.func_70106_y();
        return bossItem;
    }

    public static void reapplyAttributeModifier(EntityLivingBase entity, IAttribute attribute, AttributeModifier modifier) {
        IAttributeInstance instance = entity.func_110148_a(attribute);
        if (instance != null) {
            if (instance.func_111127_a(modifier.func_111167_a()) != null) {
                instance.func_188479_b(modifier.func_111167_a());
            }
            instance.func_111121_a(modifier);
        }
    }

    public static void applyAttributeModifierSafely(EntityLivingBase entity, IAttribute attribute, AttributeModifier modifier) {
        IAttributeInstance instance = entity.func_110148_a(attribute);
        if (instance != null && !instance.func_180374_a(modifier)) {
            instance.func_111121_a(modifier);
        }
    }

    public static void removeAttributeModifier(EntityLivingBase entity, IAttribute attribute, AttributeModifier modifier) {
        IAttributeInstance instance = entity.func_110148_a(attribute);
        if (instance != null && instance.func_180374_a(modifier)) {
            instance.func_111124_b(modifier);
        }
    }

    public static void removeAttributeModifier(EntityLivingBase entity, IAttribute attribute, UUID modifierId) {
        AttributeModifier modifier;
        IAttributeInstance instance = entity.func_110148_a(attribute);
        if (instance != null && (modifier = instance.func_111127_a(modifierId)) != null) {
            instance.func_111124_b(modifier);
        }
    }

    public static boolean canPvp(EntityPlayer attacker, EntityPlayer target) {
        return attacker.field_70170_p.func_73046_m().func_71219_W() && attacker != target && !attacker.func_184191_r((Entity)target);
    }

    public static void pushEntityAway(@Nonnull Entity centralEntity, @Nonnull Entity targetEntity, float strength) {
        targetEntity.field_70159_w = (targetEntity.field_70165_t - centralEntity.field_70165_t) * (double)strength;
        targetEntity.field_70181_x = (targetEntity.field_70163_u - centralEntity.field_70163_u) * (double)strength;
        targetEntity.field_70179_y = (targetEntity.field_70161_v - centralEntity.field_70161_v) * (double)strength;
        targetEntity.field_70133_I = true;
    }

    public static void pullEntityIn(@Nonnull Entity centralEntity, @Nonnull Entity targetEntity, float strength) {
        targetEntity.field_70159_w = (centralEntity.field_70165_t - targetEntity.field_70165_t) * (double)strength;
        targetEntity.field_70181_x = (centralEntity.field_70163_u - targetEntity.field_70163_u) * (double)strength;
        targetEntity.field_70179_y = (centralEntity.field_70161_v - targetEntity.field_70161_v) * (double)strength;
        targetEntity.field_70133_I = true;
    }

    @Nullable
    public static Vec3d preciseEntityInterceptCalculation(Entity impactedEntity, Entity impactingEntity, int granularity) {
        double velocityX = impactingEntity.field_70159_w;
        double velocityY = impactingEntity.field_70181_x;
        double velocityZ = impactingEntity.field_70179_y;
        Object impactVec = null;
        for (int i = 0; i < granularity; ++i) {
            double projectionX = velocityX * (double)(1.0f / (float)granularity) * (double)i;
            double projectionY = velocityY * (double)(1.0f / (float)granularity) * (double)i;
            double projectionZ = velocityZ * (double)(1.0f / (float)granularity) * (double)i;
            Vec3d initialVec = new Vec3d(impactingEntity.field_70165_t, impactingEntity.field_70163_u, impactingEntity.field_70161_v);
            Vec3d projectedVec = initialVec.func_72441_c(projectionX, projectionY, projectionZ);
            List entityList = impactingEntity.field_70170_p.func_72839_b(impactingEntity, impactingEntity.func_174813_aQ().func_72314_b(projectionX, projectionY, projectionZ));
            for (Entity entity : entityList) {
                RayTraceResult intercept;
                if (entity != impactedEntity || (intercept = entity.func_174813_aQ().func_72327_a(initialVec, projectedVec)) == null) continue;
                return intercept.field_72307_f;
            }
        }
        return null;
    }

    public static void safelyAddPotionEffect(Entity entity, Potion potion, int duration, int amplifier, boolean isAmbient, boolean displayParticles) {
        if (!(!(entity instanceof EntityLivingBase) || entity instanceof EntityPlayer && (entity instanceof FakePlayer || ((EntityPlayer)entity).field_71075_bZ.field_75098_d && potion.func_76398_f()))) {
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(potion, duration, amplifier, isAmbient, displayParticles));
        }
    }

    public static void safelyRemovePotionEffects(EntityLivingBase entity, Potion ... effects) {
        for (Potion effect : effects) {
            if (!entity.func_70644_a(effect)) continue;
            entity.func_184589_d(effect);
        }
    }

    public static boolean isTypeImmune(Entity entity, Enums.MobProperties property) {
        return !entity.func_190530_aW() && entity instanceof SpecialPropertyEntity && ((SpecialPropertyEntity)entity).getMobProperties().contains((Object)property);
    }

    public static boolean isFlyingCreature(Entity entity) {
        return entity instanceof EntityLiving && (entity instanceof EntityFlying || entity instanceof net.minecraft.entity.EntityFlying || ((EntityLiving)entity).func_70661_as() instanceof PathNavigateFlying);
    }
}

