/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.structure;

import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.tslat.aoa3.structure.StructuresHandler;

public abstract class AoAStructure
extends WorldGenerator {
    private final String name;
    private boolean isWorldGen = true;

    public AoAStructure(String name) {
        this.name = name;
        StructuresHandler.registerStructure(this);
    }

    private AoAStructure() {
        this.name = "EMPTY";
    }

    public final String getName() {
        return this.name;
    }

    protected boolean replacesBlocks() {
        return false;
    }

    public boolean doPreChecks(World world, Random rand, BlockPos basePos, IBlockState ... groundBlocks) {
        return true;
    }

    public final boolean func_180709_b(World world, Random rand, BlockPos position) {
        boolean bl = this.isWorldGen = rand != null;
        if (rand == null) {
            rand = new Random();
        }
        this.build(world, rand, (BlockPos)new BlockPos.MutableBlockPos(position));
        this.doPostBuildOps(world, rand, position);
        this.spawnEntities(world, rand, position);
        return true;
    }

    protected abstract void build(World var1, Random var2, BlockPos var3);

    protected void doPostBuildOps(World world, Random rand, BlockPos basePos) {
    }

    protected void spawnEntities(World world, Random rand, BlockPos basePos) {
    }

    public final void addBlock(World world, BlockPos pos, int xCoordOffset, int yCoordOffset, int zCoordOffset, IBlockState block) {
        if (this.replacesBlocks() || world.func_175623_d(pos.func_177982_a(xCoordOffset, yCoordOffset, zCoordOffset))) {
            world.func_180501_a(pos.func_177982_a(xCoordOffset, yCoordOffset, zCoordOffset), block, this.isWorldGen ? 2 : 3);
        }
    }

    protected void assignLootChests(World world, Random rand, ResourceLocation lootTable, BlockPos ... positions) {
        for (BlockPos pos : positions) {
            TileEntity tileEntity = world.func_175625_s(pos);
            if (!(tileEntity instanceof TileEntityChest)) continue;
            ((TileEntityChest)tileEntity).func_189404_a(lootTable, rand.nextLong());
        }
    }

    static final class EmptyStructure
    extends AoAStructure {
        EmptyStructure() {
        }

        @Override
        protected void build(World world, Random rand, BlockPos basePos) {
        }
    }
}

