/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.library;

import javax.annotation.Nullable;
import net.minecraft.client.audio.MusicTicker;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.EnumHelperClient;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.common.registration.SoundsRegister;
import org.apache.logging.log4j.Level;

public final class Enums {
    @SideOnly(value=Side.CLIENT)
    public static final MusicTicker.MusicType NULL_MUSIC = EnumHelperClient.addMusicType((String)"null", (SoundEvent)SoundsRegister.MUSIC_NULL, (int)0, (int)1);

    public static enum Particles {
        STAR_TRAIL(0),
        FLUFFY_TRAIL(1),
        FLICKERING_FLUFFY_TRAIL(2),
        SWIRLY_TRAIL(3),
        LINGERING_FLUFFY_TRAIL(4),
        FLUFFY_RAINBOW_TRAIL(5),
        PORTAL_FLOATER(6);

        public final int id;

        private Particles(int id) {
            this.id = id;
        }

        @Nullable
        public static Particles byId(int id) {
            switch (id) {
                case 0: {
                    return STAR_TRAIL;
                }
                case 1: {
                    return FLUFFY_TRAIL;
                }
                case 2: {
                    return FLICKERING_FLUFFY_TRAIL;
                }
                case 3: {
                    return SWIRLY_TRAIL;
                }
                case 4: {
                    return LINGERING_FLUFFY_TRAIL;
                }
                case 5: {
                    return FLUFFY_RAINBOW_TRAIL;
                }
                case 6: {
                    return PORTAL_FLOATER;
                }
            }
            return null;
        }
    }

    public static enum ItemDescriptionType {
        POSITIVE(TextFormatting.DARK_GREEN),
        NEGATIVE(TextFormatting.RED),
        NEUTRAL(TextFormatting.DARK_GRAY),
        UNIQUE(TextFormatting.DARK_PURPLE),
        ITEM_TYPE_INFO(TextFormatting.AQUA),
        ITEM_DAMAGE(TextFormatting.DARK_RED),
        ITEM_AMMO_COST(TextFormatting.LIGHT_PURPLE);

        public final TextFormatting format;

        private ItemDescriptionType(TextFormatting format) {
            this.format = format;
        }
    }

    public static enum BlockUpdateFlags {
        BLOCK_UPDATE(1),
        SYNC_CLIENT(2),
        PREVENT_RERENDER(4),
        DESYNC_RENDERS(8),
        NO_OBSERVERS(16);

        public int value;

        private BlockUpdateFlags(int flagValue) {
            this.value = flagValue;
        }
    }

    public static enum PlayerHaloTypes {
        Donator,
        Super_Donator,
        Crazy_Donator,
        Wiki_Editor,
        Tslat,
        Staff;


        public static enum ChoosableHaloTypes {
            Donator,
            Super_Donator,
            Wiki_Editor;


            public PlayerHaloTypes toBaseType() {
                switch (this) {
                    case Donator: {
                        return Donator;
                    }
                    case Super_Donator: {
                        return Super_Donator;
                    }
                    case Wiki_Editor: {
                        return Wiki_Editor;
                    }
                }
                return null;
            }
        }
    }

    public static enum CommandFeedbackType {
        INFO(TextFormatting.GRAY),
        SUCCESS(TextFormatting.GREEN),
        WARN(TextFormatting.RED),
        ERROR(TextFormatting.DARK_RED);

        private final TextFormatting colour;

        private CommandFeedbackType(TextFormatting colour) {
            this.colour = colour;
        }

        public TextFormatting getColour() {
            return this.colour;
        }
    }

    public static enum ModGuis {
        WORN_BOOK(0),
        TRADER_ASSASSIN(1),
        TRADER_CORRUPTED_TRAVELLER(2),
        TRADER_CREEP_BANKER(3),
        TRADER_CRYSTAL_TRADER(4),
        TRADER_DUNGEON_KEEPER(5),
        TRADER_EXPLOSIVES_EXPERT(6),
        TRADER_GORB_ARMS_DEALER(7),
        TRADER_GORB_ENGINEER(8),
        TRADER_LELYETIAN_BANKER(9),
        TRADER_LELYETIAN_TRADER(10),
        TRADER_LOTTOMAN(11),
        TRADER_METALLOID(12),
        TRADER_NATURALIST(13),
        TRADER_PRIMORDIAL_BANKER(14),
        TRADER_PRIMORDIAL_MERCHANT(15),
        TRADER_PRIMORDIAL_SPELLBINDER(16),
        TRADER_PRIMORDIAL_WIZARD(17),
        TRADER_PROFESSOR(18),
        TRADER_REALMSHIFTER(19),
        TRADER_SHYRE_ARCHER(20),
        TRADER_SHYRE_BANKER(21),
        TRADER_SKILL_MASTER(22),
        TRADER_UNDEAD_HERALD(23),
        TRADER_STORE_KEEPER(24),
        TRADER_TOKEN_COLLECTOR(25),
        TRADER_TOY_MERCHANT(26),
        TRADER_TROLL_TRADER(27),
        TRADER_ZAL_BANKER(28),
        TRADER_ZAL_GROCER(29),
        TRADER_ZAL_HERBALIST(30),
        TRADER_ZAL_SPELLBINDER(31),
        TRADER_ZAL_VENDOR(32),
        ADVENT_MAIN_WINDOW(100),
        INFUSION_TABLE(101),
        FRAME_BENCH(102),
        REALMSTONE_MENU(103),
        MENDING_TABLE(104),
        WHITEWASHING_TABLE(105),
        DIVINE_STATION(106),
        BANKER(107);

        public int guiId;

        private ModGuis(int guiId) {
            this.guiId = guiId;
        }

        @Nullable
        public static ModGuis getById(int id) {
            switch (id) {
                case 0: {
                    return WORN_BOOK;
                }
                case 1: {
                    return TRADER_ASSASSIN;
                }
                case 2: {
                    return TRADER_CORRUPTED_TRAVELLER;
                }
                case 3: {
                    return TRADER_CREEP_BANKER;
                }
                case 4: {
                    return TRADER_CRYSTAL_TRADER;
                }
                case 5: {
                    return TRADER_DUNGEON_KEEPER;
                }
                case 6: {
                    return TRADER_EXPLOSIVES_EXPERT;
                }
                case 7: {
                    return TRADER_GORB_ARMS_DEALER;
                }
                case 8: {
                    return TRADER_GORB_ENGINEER;
                }
                case 9: {
                    return TRADER_LELYETIAN_BANKER;
                }
                case 10: {
                    return TRADER_LELYETIAN_TRADER;
                }
                case 11: {
                    return TRADER_LOTTOMAN;
                }
                case 12: {
                    return TRADER_METALLOID;
                }
                case 13: {
                    return TRADER_NATURALIST;
                }
                case 14: {
                    return TRADER_PRIMORDIAL_BANKER;
                }
                case 15: {
                    return TRADER_PRIMORDIAL_MERCHANT;
                }
                case 16: {
                    return TRADER_PRIMORDIAL_SPELLBINDER;
                }
                case 17: {
                    return TRADER_PRIMORDIAL_WIZARD;
                }
                case 18: {
                    return TRADER_PROFESSOR;
                }
                case 19: {
                    return TRADER_REALMSHIFTER;
                }
                case 20: {
                    return TRADER_SHYRE_ARCHER;
                }
                case 21: {
                    return TRADER_SHYRE_BANKER;
                }
                case 22: {
                    return TRADER_SKILL_MASTER;
                }
                case 23: {
                    return TRADER_UNDEAD_HERALD;
                }
                case 24: {
                    return TRADER_STORE_KEEPER;
                }
                case 25: {
                    return TRADER_TOKEN_COLLECTOR;
                }
                case 26: {
                    return TRADER_TOY_MERCHANT;
                }
                case 27: {
                    return TRADER_TROLL_TRADER;
                }
                case 28: {
                    return TRADER_ZAL_BANKER;
                }
                case 29: {
                    return TRADER_ZAL_GROCER;
                }
                case 30: {
                    return TRADER_ZAL_HERBALIST;
                }
                case 31: {
                    return TRADER_ZAL_SPELLBINDER;
                }
                case 32: {
                    return TRADER_ZAL_VENDOR;
                }
                case 100: {
                    return ADVENT_MAIN_WINDOW;
                }
                case 101: {
                    return INFUSION_TABLE;
                }
                case 102: {
                    return FRAME_BENCH;
                }
                case 103: {
                    return REALMSTONE_MENU;
                }
                case 104: {
                    return MENDING_TABLE;
                }
                case 105: {
                    return WHITEWASHING_TABLE;
                }
                case 106: {
                    return DIVINE_STATION;
                }
                case 107: {
                    return BANKER;
                }
            }
            return null;
        }
    }

    public static enum MobProjectileType {
        MAGIC,
        PHYSICAL,
        GUN,
        OTHER;

    }

    public static enum MobProperties {
        RANGED_IMMUNE,
        BLASTER_IMMUNE,
        MAGIC_IMMUNE,
        EXPLOSION_IMMUNE,
        FIRE_IMMUNE,
        GUN_IMMUNE,
        MELEE_IMMUNE,
        SPECIAL_COMBAT_ENTITY,
        STATUS_IMMUNE;

    }

    public static enum Runes {
        Unpowered(0),
        Charged(1),
        Compass(2),
        Distortion(3),
        Energy(4),
        Fire(5),
        Kinetic(6),
        Life(7),
        Lunar(8),
        Poison(9),
        Power(10),
        Storm(11),
        Strike(12),
        Water(13),
        Wind(14),
        Wither(15);

        public final int meta;

        private Runes(int meta) {
            this.meta = meta;
        }

        public static Runes getByMeta(int meta) {
            switch (meta) {
                case 0: {
                    return Unpowered;
                }
                case 1: {
                    return Charged;
                }
                case 2: {
                    return Compass;
                }
                case 3: {
                    return Distortion;
                }
                case 4: {
                    return Energy;
                }
                case 5: {
                    return Fire;
                }
                case 6: {
                    return Kinetic;
                }
                case 7: {
                    return Life;
                }
                case 8: {
                    return Lunar;
                }
                case 9: {
                    return Poison;
                }
                case 10: {
                    return Power;
                }
                case 11: {
                    return Storm;
                }
                case 12: {
                    return Strike;
                }
                case 13: {
                    return Water;
                }
                case 14: {
                    return Wind;
                }
                case 15: {
                    return Wither;
                }
            }
            return Unpowered;
        }
    }

    public static enum HelmetScreens {
        NIGHT_VISION_GOGGLES;

    }

    public static enum ScopeScreens {
        BASIC,
        DOTTED,
        SCRATCHES,
        REDLIGHT,
        FLORO,
        MARKER,
        MONSTER,
        DISCHARGE,
        MOON,
        CRYSTAL,
        CANDY,
        DIAMOND,
        BOULDER;

    }

    public static enum CreatureEvents {
        BIG_DAY,
        BLOOD_HUNT,
        CREEP_DAY,
        DEATH_DAY,
        LUNAR_INVASION,
        SOUL_SCURRY,
        FULL_MOON;

    }

    public static final class RGBIntegers {
        public static final int BLACK = 0;
        public static final int BLUE = 255;
        public static final int BONE = 16448150;
        public static final int BRIGHT_TURQUOISE = 58861;
        public static final int BROWN = 9593401;
        public static final int CYAN = 65535;
        public static final int DARK_GRAY = 1973526;
        public static final int DARK_LIME_GREEN = 39168;
        public static final int DARK_VIOLET = 8519858;
        public static final int DE_YORK = 8699004;
        public static final int DEEP_PINK = 16711794;
        public static final int ELECTRIC_BLUE = 0x7CFFFF;
        public static final int ELECTRIC_LIME = 13622528;
        public static final int GOLD = 0xCCAC00;
        public static final int GOLD_YELLOW = 0xFFDF00;
        public static final int GOLDEN_POPPY = 14073088;
        public static final int GREEN = 65280;
        public static final int HELIOTROPE = 12732927;
        public static final int IRIS_BLUE = 44504;
        public static final int LAVENDER_BLUSH = 16769787;
        public static final int LIGHT_CORAL = 15698295;
        public static final int MANGO_TANGO = 14509824;
        public static final int MISTY_ROSE = 0xFFE8E8;
        public static final int OLIVE = 5924864;
        public static final int ORANGE = 14653696;
        public static final int PIGMENT_GREEN = 37698;
        public static final int PINK = 16738740;
        public static final int PURPLE = 12665047;
        public static final int RED = 0xFF0000;
        public static final int RED_2 = 0xE50000;
        public static final int SILVER = 0xB5B5B5;
        public static final int TANGERINE_YELLOW = 15257600;
        public static final int TOXIC_GREEN = 0x336600;
        public static final int TYRIAN_PURPLE = 7012434;
        public static final int WHITE = 0xFFFFFF;
        public static final int YELLOW = 0xFFFF00;
        public static final int YELLOW_2 = 16248576;
    }

    public static enum ScreenOverlays {
        SCRATCHES(0),
        BLOODY(1),
        STATIC(2),
        GRILLFACE(3),
        DARKNESS(4),
        EILOSAPIEN(5),
        PURPLE_FOG(6),
        CIRCLES(7),
        CONIFERON_VINES(8),
        SPIKEY_CIRCLES(9),
        SHYRE_DIZZY(10),
        SHYRE_BLIND(11),
        LIGHTWALKER(12);

        public final int id;

        private ScreenOverlays(int id) {
            this.id = id;
        }

        public static ScreenOverlays getById(int id) {
            switch (id) {
                case 0: {
                    return SCRATCHES;
                }
                case 1: {
                    return BLOODY;
                }
                case 2: {
                    return STATIC;
                }
                case 3: {
                    return GRILLFACE;
                }
                case 4: {
                    return DARKNESS;
                }
                case 5: {
                    return EILOSAPIEN;
                }
                case 6: {
                    return PURPLE_FOG;
                }
                case 7: {
                    return CIRCLES;
                }
                case 8: {
                    return CONIFERON_VINES;
                }
                case 9: {
                    return SPIKEY_CIRCLES;
                }
                case 10: {
                    return SHYRE_DIZZY;
                }
                case 11: {
                    return SHYRE_BLIND;
                }
                case 12: {
                    return LIGHTWALKER;
                }
            }
            return null;
        }
    }

    public static enum WeaponSpeed {
        QUADRUPLE(2.4),
        TRIPLE(1.33333),
        DOUBLE(-0.8),
        NORMAL(-2.4),
        HALF(-3.2),
        THIRD(-3.46667),
        QUARTER(-3.6);

        public final double value;

        private WeaponSpeed(double speed) {
            this.value = speed;
        }
    }

    public static enum Counters {
        ARCHAIC,
        BATTLEBORN,
        CANDY,
        HYDROPLATE,
        KNIGHT,
        MERCURIAL,
        NECRO,
        ROSID,
        RUNIC;

    }

    public static enum Resources {
        CREATION,
        ENERGY,
        RAGE,
        SOUL;


        @Nullable
        public static Resources fromString(String resourceName) {
            Resources resource;
            try {
                resource = Resources.valueOf(resourceName.toUpperCase().replace(" ", "_"));
            }
            catch (IllegalArgumentException ex) {
                AdventOfAscension.logMessage(Level.WARN, "Unable to find resource with name: \"" + resourceName + "\"", ex);
                return null;
            }
            return resource;
        }
    }

    public static enum Dimensions {
        ABYSS,
        ANCIENT_CAVERN,
        BARATHOS,
        CANDYLAND,
        CELEVE,
        CREEPONIA,
        CRYSTEVIA,
        DEEPLANDS,
        DUSTOPIA,
        GARDENCIA,
        GRECKON,
        HAVEN,
        IMMORTALLIS,
        IROMINE,
        LBOREAN,
        LELYETIA,
        LUNALUS,
        MYSTERIUM,
        NETHER,
        OVERWORLD,
        PRECASIA,
        RUNANDOR,
        SHYRELANDS,
        THE_END,
        VOX_PONDS;

    }

    public static enum ArmourSets {
        ALACRITY,
        ALCHEMY,
        ALL,
        AMETHIND,
        ANIMA,
        ARCHAIC,
        AUGURY,
        BARON,
        BATTLEBORN,
        BIOGENIC,
        BOREIC,
        BUTCHERY,
        CANDY,
        COMMANDER,
        CREATION,
        CRYSTALLIS,
        ELECANYTE,
        EMBRODIUM,
        ENGINEERING,
        EXOPLATE,
        EXPEDITION,
        EXPLOSIVE,
        EXTRACTION,
        FORAGING,
        FUNGAL,
        GHASTLY,
        GHOULISH,
        HAULING,
        HAZMAT,
        HUNTER,
        HYDRANGIC,
        HYDROPLATE,
        ICE,
        INFERNAL,
        INFUSION,
        INNERVATION,
        KNIGHT,
        LOGGING,
        LUNAR,
        LYNDAMYTE,
        LYONIC,
        MERCURIAL,
        NECRO,
        NETHENGEIC,
        NIGHTMARE,
        NONE,
        OMNI,
        PHANTASM,
        POISON,
        PREDATIOUS,
        PRIMORDIAL,
        PURITY,
        ROCKBONE,
        ROSIDIAN,
        RUNATION,
        RUNIC,
        SHARPSHOT,
        SKELETAL,
        SPACEKING,
        SPEED,
        SUBTERRANEAN,
        UTOPIAN,
        VOID,
        WEAKEN,
        WITHER,
        ZARGONITE;

    }

    public static enum Deities {
        EREBON,
        LUXON,
        PLUTON,
        SELYAN;


        @Nullable
        public static Deities fromString(String deityName) {
            Deities deity;
            try {
                deity = Deities.valueOf(deityName.toUpperCase().replace(" ", "_"));
            }
            catch (IllegalArgumentException ex) {
                AdventOfAscension.logMessage(Level.WARN, "Unable to find deity with name: \"" + deityName + "\"", ex);
                return null;
            }
            return deity;
        }
    }

    public static enum Skills {
        ALCHEMY(0),
        ANIMA(1),
        AUGURY(2),
        BUTCHERY(3),
        CREATION(4),
        ENGINEERING(5),
        EXPEDITION(6),
        EXTRACTION(7),
        FORAGING(8),
        HAULING(9),
        HUNTER(10),
        INFUSION(11),
        INNERVATION(12),
        LOGGING(13),
        RUNATION(14);

        public final int id;

        private Skills(int id) {
            this.id = id;
        }

        public static Skills getById(int id) {
            switch (id) {
                case 0: {
                    return ALCHEMY;
                }
                case 1: {
                    return ANIMA;
                }
                case 2: {
                    return AUGURY;
                }
                case 3: {
                    return BUTCHERY;
                }
                case 4: {
                    return CREATION;
                }
                case 5: {
                    return ENGINEERING;
                }
                case 6: {
                    return EXPEDITION;
                }
                case 7: {
                    return EXTRACTION;
                }
                case 8: {
                    return FORAGING;
                }
                case 9: {
                    return HAULING;
                }
                case 10: {
                    return HUNTER;
                }
                case 11: {
                    return INFUSION;
                }
                case 12: {
                    return INNERVATION;
                }
                case 13: {
                    return LOGGING;
                }
                case 14: {
                    return RUNATION;
                }
            }
            return null;
        }

        @Nullable
        public static Skills fromString(String skillName) {
            Skills skill;
            try {
                skill = Skills.valueOf(skillName.toUpperCase().replace(" ", "_"));
            }
            catch (IllegalArgumentException ex) {
                AdventOfAscension.logMessage(Level.WARN, "Unable to find skill with name: \"" + skillName + "\"", ex);
                return null;
            }
            return skill;
        }
    }
}

