/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.staff;

import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.common.registration.ItemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.projectiles.staff.BaseEnergyShot;
import net.tslat.aoa3.entity.projectiles.staff.EntityWitherShot;
import net.tslat.aoa3.item.misc.RuneItem;
import net.tslat.aoa3.item.weapon.staff.BaseStaff;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.EntityUtil;
import net.tslat.aoa3.utils.ItemUtil;

public class WitherStaff
extends BaseStaff {
    public WitherStaff(int durability) {
        super(durability);
        this.func_77655_b("WitherStaff");
        this.setRegistryName("aoa3:wither_staff");
    }

    @Override
    @Nullable
    public SoundEvent getCastingSound() {
        return SoundsRegister.BASIC_STAFF_CAST;
    }

    @Override
    protected void populateRunes(HashMap<RuneItem, Integer> runes) {
        runes.put(ItemRegister.WIND_RUNE, 2);
        runes.put(ItemRegister.WITHER_RUNE, 2);
    }

    @Override
    public void cast(World world, ItemStack staff, EntityLivingBase caster, Object args) {
        world.func_72838_d((Entity)new EntityWitherShot(caster, this, 60));
    }

    @Override
    public boolean doEntityImpact(BaseEnergyShot shot, Entity target, EntityLivingBase shooter) {
        if (EntityUtil.dealMagicDamage((Entity)shot, shooter, target, this.getDmg(), false)) {
            if (target instanceof EntityLivingBase) {
                ((EntityLivingBase)target).func_70690_d(new PotionEffect(MobEffects.field_82731_v, 60, 3, true, false));
            }
            return true;
        }
        return false;
    }

    @Override
    public float getDmg() {
        return 5.0f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(ItemUtil.getFormattedDescriptionText("item.WitherStaff.desc.1", Enums.ItemDescriptionType.POSITIVE));
        super.func_77624_a(stack, world, tooltip, flag);
    }
}

