/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.staff;

import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAreaEffectCloud;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.common.registration.ItemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.projectiles.staff.BaseEnergyShot;
import net.tslat.aoa3.entity.projectiles.staff.EntityNoxiousShot;
import net.tslat.aoa3.item.misc.RuneItem;
import net.tslat.aoa3.item.weapon.EnergyProjectileWeapon;
import net.tslat.aoa3.item.weapon.staff.BaseStaff;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.EntityUtil;
import net.tslat.aoa3.utils.ItemUtil;

public class NoxiousStaff
extends BaseStaff {
    public NoxiousStaff(int durability) {
        super(durability);
        this.func_77655_b("NoxiousStaff");
        this.setRegistryName("aoa3:noxious_staff");
    }

    @Override
    @Nullable
    public SoundEvent getCastingSound() {
        return SoundsRegister.NOXIOUS_STAFF_CAST;
    }

    @Override
    protected void populateRunes(HashMap<RuneItem, Integer> runes) {
        runes.put(ItemRegister.WIND_RUNE, 2);
        runes.put(ItemRegister.POISON_RUNE, 2);
        runes.put(ItemRegister.STORM_RUNE, 2);
    }

    @Override
    public void cast(World world, ItemStack staff, EntityLivingBase caster, Object args) {
        world.func_72838_d((Entity)new EntityNoxiousShot(caster, (EnergyProjectileWeapon)this, 60, 0.0f, 0.0f, 0.0f));
        world.func_72838_d((Entity)new EntityNoxiousShot(caster, (EnergyProjectileWeapon)this, 60, 0.075f, 0.075f, 0.0f));
        world.func_72838_d((Entity)new EntityNoxiousShot(caster, (EnergyProjectileWeapon)this, 60, -0.075f, 0.0f, 0.075f));
        world.func_72838_d((Entity)new EntityNoxiousShot(caster, (EnergyProjectileWeapon)this, 60, 0.0f, -0.075f, -0.075f));
        world.func_72838_d((Entity)new EntityNoxiousShot(caster, (EnergyProjectileWeapon)this, 60, -0.075f, 0.075f, -0.075f));
        world.func_72838_d((Entity)new EntityNoxiousShot(caster, (EnergyProjectileWeapon)this, 60, -0.075f, -0.075f, 0.075f));
    }

    @Override
    public boolean doEntityImpact(BaseEnergyShot shot, Entity target, EntityLivingBase shooter) {
        if (EntityUtil.dealMagicDamage((Entity)shot, shooter, target, this.getDmg(), false)) {
            if (target instanceof EntityLivingBase) {
                ((EntityLivingBase)target).func_70690_d(new PotionEffect(MobEffects.field_76436_u, 100, 2, true, true));
            }
            return true;
        }
        return false;
    }

    @Override
    public void doBlockImpact(BaseEnergyShot shot, BlockPos pos, EntityLivingBase shooter) {
        EntityAreaEffectCloud cloud = new EntityAreaEffectCloud(shot.field_70170_p, shot.field_70165_t, shot.field_70163_u, shot.field_70161_v);
        cloud.func_184483_a(3.0f);
        cloud.func_184484_a(PotionTypes.field_185219_B);
        cloud.func_184496_a(new PotionEffect(MobEffects.field_76436_u, 100, 2, true, true));
        cloud.func_184486_b(3);
        cloud.func_184482_a(0x336600);
        cloud.func_184481_a(shooter);
        shot.field_70170_p.func_72838_d((Entity)cloud);
    }

    @Override
    public float getDmg() {
        return 3.5f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(ItemUtil.getFormattedDescriptionText("item.NoxiousStaff.desc.1", Enums.ItemDescriptionType.POSITIVE));
        super.func_77624_a(stack, world, tooltip, flag);
    }
}

