/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.staff;

import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAreaEffectCloud;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.common.registration.ItemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.projectiles.staff.BaseEnergyShot;
import net.tslat.aoa3.entity.projectiles.staff.EntityMoonlightFall;
import net.tslat.aoa3.item.misc.RuneItem;
import net.tslat.aoa3.item.weapon.EnergyProjectileWeapon;
import net.tslat.aoa3.item.weapon.staff.BaseStaff;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.EntityUtil;
import net.tslat.aoa3.utils.ItemUtil;

public class MoonlightStaff
extends BaseStaff {
    public MoonlightStaff(int durability) {
        super(durability);
        this.func_77655_b("MoonlightStaff");
        this.setRegistryName("aoa3:moonlight_staff");
    }

    @Override
    @Nullable
    public SoundEvent getCastingSound() {
        return SoundsRegister.MOONLIGHT_STAFF_CAST;
    }

    @Override
    protected void populateRunes(HashMap<RuneItem, Integer> runes) {
        runes.put(ItemRegister.COMPASS_RUNE, 1);
        runes.put(ItemRegister.LUNAR_RUNE, 2);
        runes.put(ItemRegister.KINETIC_RUNE, 2);
    }

    @Override
    public Object checkPreconditions(EntityLivingBase caster, ItemStack staff) {
        BlockPos trace = null;
        if (caster instanceof EntityPlayer) {
            trace = EntityUtil.getBlockAimingAt((EntityPlayer)caster, 70.0);
        }
        return trace;
    }

    @Override
    public void cast(World world, ItemStack staff, EntityLivingBase caster, Object args) {
        BlockPos pos = (BlockPos)args;
        world.func_72838_d((Entity)new EntityMoonlightFall(caster, (EnergyProjectileWeapon)this, (double)pos.func_177958_n(), (double)(pos.func_177956_o() + 30), (double)pos.func_177952_p(), 3.0f));
    }

    @Override
    public void doBlockImpact(BaseEnergyShot shot, BlockPos block, EntityLivingBase caster) {
        this.createCloud(shot, caster);
    }

    @Override
    public boolean doEntityImpact(BaseEnergyShot shot, Entity target, EntityLivingBase caster) {
        if (!EntityUtil.isTypeImmune(target, Enums.MobProperties.MAGIC_IMMUNE)) {
            this.createCloud(shot, caster);
            return true;
        }
        return false;
    }

    private void createCloud(BaseEnergyShot shot, EntityLivingBase caster) {
        EntityAreaEffectCloud cloud = new EntityAreaEffectCloud(shot.field_70170_p, shot.field_70165_t, shot.field_70163_u, shot.field_70161_v);
        cloud.func_184481_a(caster);
        cloud.func_184496_a(new PotionEffect(MobEffects.field_76421_d, 140, 1, false, true));
        cloud.func_184483_a(0.1f);
        cloud.func_184487_c(1.0f);
        cloud.func_184486_b(10);
        cloud.func_184485_d(0);
        shot.field_70170_p.func_72838_d((Entity)cloud);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(ItemUtil.getFormattedDescriptionText("item.MoonlightStaff.desc.1", Enums.ItemDescriptionType.POSITIVE));
        super.func_77624_a(stack, world, tooltip, flag);
    }
}

