/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.staff;

import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.monster.IMob;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.common.registration.ItemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.projectiles.staff.BaseEnergyShot;
import net.tslat.aoa3.entity.projectiles.staff.EntityLyonicShot;
import net.tslat.aoa3.item.misc.RuneItem;
import net.tslat.aoa3.item.weapon.EnergyProjectileWeapon;
import net.tslat.aoa3.item.weapon.staff.BaseStaff;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.ItemUtil;

public class LyonicStaff
extends BaseStaff {
    public LyonicStaff(int durability) {
        super(durability);
        this.func_77655_b("LyonicStaff");
        this.setRegistryName("aoa3:lyonic_staff");
    }

    @Override
    @Nullable
    public SoundEvent getCastingSound() {
        return SoundsRegister.BASIC_STAFF_CAST;
    }

    @Override
    protected void populateRunes(HashMap<RuneItem, Integer> runes) {
        runes.put(ItemRegister.ENERGY_RUNE, 1);
        runes.put(ItemRegister.WIND_RUNE, 1);
        runes.put(ItemRegister.WITHER_RUNE, 2);
        runes.put(ItemRegister.STRIKE_RUNE, 1);
    }

    @Override
    @Nullable
    public Object checkPreconditions(EntityLivingBase caster, ItemStack staff) {
        List targets = caster.field_70170_p.func_175647_a(EntityLivingBase.class, caster.func_174813_aQ().func_72314_b(10.0, 1.0, 10.0), entity -> entity instanceof IMob && entity.func_70089_S());
        return targets.isEmpty() ? null : targets;
    }

    @Override
    public void cast(World world, ItemStack staff, EntityLivingBase caster, Object args) {
        for (float x = -1.0f; x <= 1.0f; x += 0.125f) {
            for (float z = -1.0f; z <= 1.0f; z += 0.125f) {
                world.func_72838_d((Entity)new EntityLyonicShot(caster, (EnergyProjectileWeapon)this, 1, x, 0.0f, z));
            }
        }
    }

    @Override
    public boolean doEntityImpact(BaseEnergyShot shot, Entity target, EntityLivingBase shooter) {
        if (target instanceof IMob) {
            if (target instanceof EntityLivingBase) {
                ((EntityLivingBase)target).func_70690_d(new PotionEffect(MobEffects.field_82731_v, 100, 1, false, true));
            }
            if (field_77697_d.nextInt(150) == 0) {
                target.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(target.field_70170_p, target.field_70165_t, target.field_70163_u, target.field_70161_v, false));
            }
            return true;
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(ItemUtil.getFormattedDescriptionText("item.LyonicStaff.desc.1", Enums.ItemDescriptionType.POSITIVE));
        tooltip.add(ItemUtil.getFormattedDescriptionText("item.LyonicStaff.desc.2", Enums.ItemDescriptionType.POSITIVE));
        tooltip.add(ItemUtil.getFormattedDescriptionText("item.LyonicStaff.desc.3", Enums.ItemDescriptionType.POSITIVE));
        super.func_77624_a(stack, world, tooltip, flag);
    }
}

