/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.staff;

import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.common.registration.ItemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.item.misc.RuneItem;
import net.tslat.aoa3.item.weapon.staff.BaseStaff;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.EntityUtil;
import net.tslat.aoa3.utils.ItemUtil;

public class LightningStaff
extends BaseStaff {
    public LightningStaff(int durability) {
        super(durability);
        this.func_77655_b("LightningStaff");
        this.setRegistryName("aoa3:lightning_staff");
    }

    @Override
    @Nullable
    public SoundEvent getCastingSound() {
        return SoundsRegister.BASIC_STAFF_CAST;
    }

    @Override
    protected void populateRunes(HashMap<RuneItem, Integer> runes) {
        runes.put(ItemRegister.COMPASS_RUNE, 1);
        runes.put(ItemRegister.STRIKE_RUNE, 4);
        runes.put(ItemRegister.STORM_RUNE, 4);
    }

    @Override
    public Object checkPreconditions(EntityLivingBase caster, ItemStack staff) {
        BlockPos trace = null;
        if (caster instanceof EntityPlayer) {
            trace = EntityUtil.getBlockAimingAt((EntityPlayer)caster, 70.0);
        }
        return trace;
    }

    @Override
    public void cast(World world, ItemStack staff, EntityLivingBase caster, Object args) {
        BlockPos pos = (BlockPos)args;
        for (int i = 0; i <= 360; i += 18) {
            double posX = (double)pos.func_177958_n() + Math.cos(i) * 4.0;
            double posZ = (double)pos.func_177952_p() + Math.sin(i) * 4.0;
            world.func_72942_c((Entity)new EntityLightningBolt(world, posX, (double)world.func_189649_b((int)posX, (int)posZ), posZ, false));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(ItemUtil.getFormattedDescriptionText("item.LightningStaff.desc.1", Enums.ItemDescriptionType.POSITIVE));
        super.func_77624_a(stack, world, tooltip, flag);
    }
}

