/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.staff;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.common.registration.BlockRegister;
import net.tslat.aoa3.common.registration.ItemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.item.misc.RuneItem;
import net.tslat.aoa3.item.weapon.staff.BaseStaff;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.library.scheduling.async.CoralStaffTask;
import net.tslat.aoa3.utils.ItemUtil;

public class CoralStaff
extends BaseStaff {
    public CoralStaff(int durability) {
        super(durability);
        this.func_77655_b("CoralStaff");
        this.setRegistryName("aoa3:coral_staff");
    }

    @Override
    @Nullable
    public SoundEvent getCastingSound() {
        return SoundsRegister.CORAL_STAFF_CAST;
    }

    @Override
    protected void populateRunes(HashMap<RuneItem, Integer> runes) {
        runes.put(ItemRegister.WATER_RUNE, 2);
        runes.put(ItemRegister.KINETIC_RUNE, 8);
    }

    @Override
    @Nullable
    public Object checkPreconditions(EntityLivingBase caster, ItemStack staff) {
        int y;
        ArrayList<BlockPos> coralPositions = new ArrayList<BlockPos>();
        BlockPos pos = caster.func_180425_c();
        BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos();
        for (int x = -2; x <= 1; ++x) {
            for (int z = -2; z <= 1; ++z) {
                checkPos.func_181079_c(pos.func_177958_n() + x, pos.func_177956_o() - 2, pos.func_177952_p() + z);
                if (this.safeBlockPos(caster, (BlockPos)checkPos)) {
                    coralPositions.add(checkPos.func_185334_h());
                }
                if (!this.safeBlockPos(caster, (BlockPos)checkPos.func_189534_c(EnumFacing.UP, 4))) continue;
                coralPositions.add(checkPos.func_185334_h());
            }
            for (y = -2; y <= 2; ++y) {
                checkPos.func_181079_c(pos.func_177958_n() + x, pos.func_177956_o() + y, pos.func_177952_p() - 2);
                if (this.safeBlockPos(caster, (BlockPos)checkPos)) {
                    coralPositions.add(checkPos.func_185334_h());
                }
                if (!this.safeBlockPos(caster, (BlockPos)checkPos.func_189534_c(EnumFacing.SOUTH, 4))) continue;
                coralPositions.add(checkPos.func_185334_h());
            }
        }
        for (int z = -2; z <= 2; ++z) {
            for (y = -2; y <= 2; ++y) {
                checkPos.func_181079_c(pos.func_177958_n() - 2, pos.func_177956_o() + y, pos.func_177952_p() + z);
                if (this.safeBlockPos(caster, (BlockPos)checkPos)) {
                    coralPositions.add(checkPos.func_185334_h());
                }
                if (!this.safeBlockPos(caster, (BlockPos)checkPos.func_189534_c(EnumFacing.EAST, 4))) continue;
                coralPositions.add(checkPos.func_185334_h());
            }
        }
        return coralPositions.isEmpty() ? null : coralPositions;
    }

    @Override
    public void cast(World world, ItemStack staff, EntityLivingBase caster, Object args) {
        if (!world.field_72995_K && caster instanceof EntityPlayer) {
            for (BlockPos pos : (ArrayList)args) {
                world.func_180501_a(pos, BlockRegister.PINK_CORAL.func_176223_P(), 2);
            }
            world.func_184148_a(null, caster.field_70165_t, caster.field_70163_u, caster.field_70161_v, SoundsRegister.REEF_STAFF_CAST, SoundCategory.PLAYERS, 1.0f, 1.0f);
            new CoralStaffTask(world, (ArrayList)args).schedule(30, TimeUnit.SECONDS);
        }
    }

    private boolean safeBlockPos(EntityLivingBase caster, BlockPos pos) {
        return caster.field_70170_p.func_180495_p(pos).func_177230_c() == Blocks.field_150350_a && (!(caster instanceof EntityPlayer) || caster.field_70170_p.field_73011_w.canMineBlock((EntityPlayer)caster, pos));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(ItemUtil.getFormattedDescriptionText("item.CoralStaff.desc.1", Enums.ItemDescriptionType.POSITIVE));
        super.func_77624_a(stack, world, tooltip, flag);
    }
}

