/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.staff;

import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.common.registration.ItemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.projectiles.staff.BaseEnergyShot;
import net.tslat.aoa3.entity.projectiles.staff.EntityCelestialFall;
import net.tslat.aoa3.item.misc.RuneItem;
import net.tslat.aoa3.item.weapon.EnergyProjectileWeapon;
import net.tslat.aoa3.item.weapon.staff.BaseStaff;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.EntityUtil;
import net.tslat.aoa3.utils.ItemUtil;
import net.tslat.aoa3.utils.WorldUtil;

public class CelestialStaff
extends BaseStaff {
    public CelestialStaff(int durability) {
        super(durability);
        this.func_77655_b("CelestialStaff");
        this.setRegistryName("aoa3:celestial_staff");
    }

    @Override
    @Nullable
    public SoundEvent getCastingSound() {
        return SoundsRegister.CELESTIAL_STAFF_CAST;
    }

    @Override
    protected void populateRunes(HashMap<RuneItem, Integer> runes) {
        runes.put(ItemRegister.COMPASS_RUNE, 1);
        runes.put(ItemRegister.LUNAR_RUNE, 2);
        runes.put(ItemRegister.ENERGY_RUNE, 2);
    }

    @Override
    public Object checkPreconditions(EntityLivingBase caster, ItemStack staff) {
        BlockPos trace = null;
        if (caster instanceof EntityPlayer) {
            trace = EntityUtil.getBlockAimingAt((EntityPlayer)caster, 70.0);
        }
        return trace;
    }

    @Override
    public void cast(World world, ItemStack staff, EntityLivingBase caster, Object args) {
        BlockPos pos = (BlockPos)args;
        world.func_72838_d((Entity)new EntityCelestialFall(caster, (EnergyProjectileWeapon)this, (double)pos.func_177958_n(), (double)(pos.func_177956_o() + 25), (double)pos.func_177952_p(), 3.0f));
    }

    @Override
    public void doBlockImpact(BaseEnergyShot shot, BlockPos block, EntityLivingBase shooter) {
        WorldUtil.createExplosion((Entity)shooter, shot.field_70170_p, (Entity)shot, 2.5f);
    }

    @Override
    public boolean doEntityImpact(BaseEnergyShot shot, Entity target, EntityLivingBase shooter) {
        WorldUtil.createExplosion((Entity)shooter, shot.field_70170_p, (Entity)shot, 2.5f);
        return EntityUtil.dealMagicDamage((Entity)shot, shooter, target, this.getDmg(), false);
    }

    @Override
    public float getDmg() {
        return 11.0f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(ItemUtil.getFormattedDescriptionText("item.CelestialStaff.desc.1", Enums.ItemDescriptionType.POSITIVE));
        super.func_77624_a(stack, world, tooltip, flag);
    }
}

