/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.sniper;

import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.common.packet.PacketRecoil;
import net.tslat.aoa3.common.registration.CreativeTabsRegister;
import net.tslat.aoa3.common.registration.EnchantmentsRegister;
import net.tslat.aoa3.common.registration.ItemRegister;
import net.tslat.aoa3.entity.projectiles.gun.BaseBullet;
import net.tslat.aoa3.entity.projectiles.gun.EntitySniperSlug;
import net.tslat.aoa3.item.weapon.AdventWeapon;
import net.tslat.aoa3.item.weapon.gun.BaseGun;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.ItemUtil;
import net.tslat.aoa3.utils.PacketUtil;
import net.tslat.aoa3.utils.StringUtil;

public abstract class BaseSniper
extends BaseGun
implements AdventWeapon {
    public BaseSniper(double dmg, int durability, int fireDelayTicks, float recoil) {
        super(dmg, durability, fireDelayTicks, recoil);
        this.func_77637_a(CreativeTabsRegister.SNIPERS);
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (hand != EnumHand.MAIN_HAND) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)stack);
        }
        if (player.func_184825_o(0.0f) < 1.0f) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)stack);
        }
        BaseBullet bullet = this.findAndConsumeAmmo(player, stack, hand);
        if (bullet != null) {
            if (!world.field_72995_K) {
                this.fireSniper((EntityLivingBase)player, hand, bullet);
            }
            if (this.getFiringSound() != null) {
                player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, this.getFiringSound(), SoundCategory.PLAYERS, 1.0f, 1.0f);
            }
            stack.func_77972_a(1, (EntityLivingBase)player);
            player.func_71029_a(StatList.func_188057_b((Item)this));
            player.func_184811_cZ().func_185145_a((Item)this, this.getFiringDelay());
            return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
        }
        if (player instanceof EntityPlayerMP) {
            ((EntityPlayerMP)player).func_71120_a(player.field_71069_bz);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)stack);
    }

    public void fireSniper(EntityLivingBase shooter, EnumHand hand, BaseBullet bullet) {
        if (shooter.func_70093_af() && shooter.field_70122_E) {
            if (shooter instanceof EntityPlayerMP) {
                int control = EnchantmentHelper.func_77506_a((Enchantment)EnchantmentsRegister.CONTROL, (ItemStack)shooter.func_184586_b(hand));
                float recoiling = this.getRecoilForShot(shooter.func_184586_b(hand), shooter) * (1.0f - (float)control * 0.15f);
                PacketUtil.network.sendTo((IMessage)new PacketRecoil(recoiling, this.getFiringDelay()), (EntityPlayerMP)shooter);
            }
        } else {
            bullet.func_184538_a((Entity)shooter, shooter.field_70125_A, shooter.field_70177_z, 0.0f, 20.0f, 50.0f);
            if (shooter instanceof EntityPlayerMP) {
                PacketUtil.network.sendTo((IMessage)new PacketRecoil(this.getRecoil() * 2.0f, this.getFiringDelay()), (EntityPlayerMP)shooter);
            }
        }
        shooter.field_70170_p.func_72838_d((Entity)bullet);
    }

    @Override
    public void doImpactDamage(Entity target, EntityLivingBase shooter, BaseBullet bullet, float bulletDmgMultiplier) {
        super.doImpactDamage(target, shooter, bullet, bullet.getAge() <= 1 ? bulletDmgMultiplier * 0.5f : bulletDmgMultiplier);
    }

    @Override
    public BaseBullet findAndConsumeAmmo(EntityPlayer player, ItemStack gunStack, EnumHand hand) {
        if (ItemUtil.findInventoryItem(player, new ItemStack((Item)ItemRegister.METAL_SLUG), true, 1 + EnchantmentHelper.func_77506_a((Enchantment)EnchantmentsRegister.GREED, (ItemStack)gunStack))) {
            return new EntitySniperSlug((EntityLivingBase)player, (BaseGun)gunStack.func_77973_b(), 0);
        }
        return null;
    }

    public Enums.ScopeScreens getScreen() {
        return Enums.ScopeScreens.BASIC;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(1, ItemUtil.getFormattedDescriptionText("items.description.damage.gun", Enums.ItemDescriptionType.ITEM_DAMAGE, Double.toString(this.getDamage())));
        tooltip.add(ItemUtil.getFormattedDescriptionText("items.description.sniper.use", Enums.ItemDescriptionType.ITEM_TYPE_INFO));
        tooltip.add(StringUtil.getLocaleStringWithArguments("items.description.gun.speed", Double.toString((double)(2000 / this.getFiringDelay()) / 100.0)));
        tooltip.add(ItemUtil.getFormattedDescriptionText("items.description.ammo.metalSlugs", Enums.ItemDescriptionType.ITEM_AMMO_COST));
    }
}

