/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.gun;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAreaEffectCloud;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.common.registration.EnchantmentsRegister;
import net.tslat.aoa3.common.registration.ItemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.projectiles.gun.BaseBullet;
import net.tslat.aoa3.entity.projectiles.gun.EntityHotShot;
import net.tslat.aoa3.item.weapon.gun.BaseGun;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.ItemUtil;
import net.tslat.aoa3.utils.PredicateUtil;
import net.tslat.aoa3.utils.StringUtil;

public class HotShot
extends BaseGun {
    private final int firingDelay;
    private final double dmg;

    public HotShot(double dmg, int durability, int firingDelayTicks, float recoil) {
        super(dmg, durability, firingDelayTicks, recoil);
        this.dmg = dmg;
        this.firingDelay = firingDelayTicks;
        this.func_77655_b("HotShot");
        this.setRegistryName("aoa3:hot_shot");
    }

    @Override
    @Nullable
    public SoundEvent getFiringSound() {
        return SoundsRegister.MINI_PISTOL_FIRE;
    }

    @Override
    public BaseBullet findAndConsumeAmmo(EntityPlayer player, ItemStack gunStack, EnumHand hand) {
        if (ItemUtil.findInventoryItem(player, new ItemStack((Item)ItemRegister.METAL_SLUG), true, 1 + EnchantmentHelper.func_77506_a((Enchantment)EnchantmentsRegister.GREED, (ItemStack)gunStack))) {
            return new EntityHotShot((EntityLivingBase)player, (BaseGun)gunStack.func_77973_b(), hand, 120, 0);
        }
        return null;
    }

    @Override
    protected void doImpactEffect(Entity target, EntityLivingBase shooter, BaseBullet bullet, float bulletDmgMultiplier) {
        EntityAreaEffectCloud cloud = new EntityAreaEffectCloud(bullet.field_70170_p, (target.field_70165_t + bullet.field_70165_t) / 2.0, (target.field_70163_u + bullet.field_70163_u) / 2.0, (target.field_70161_v + bullet.field_70161_v) / 2.0);
        cloud.func_184481_a(shooter);
        cloud.func_184491_a(EnumParticleTypes.FLAME);
        cloud.func_184483_a(1.0f);
        cloud.func_184486_b(5);
        cloud.func_184487_c(0.4f);
        cloud.func_184485_d(0);
        bullet.field_70170_p.func_72838_d((Entity)cloud);
        for (EntityLivingBase entity : bullet.field_70170_p.func_175647_a(EntityLivingBase.class, cloud.func_174813_aQ().func_72314_b(2.0, 1.0, 2.0), PredicateUtil.IS_HOSTILE_MOB)) {
            entity.func_70015_d(4);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(ItemUtil.getFormattedDescriptionText("item.HotShot.desc.1", Enums.ItemDescriptionType.POSITIVE));
        tooltip.add(1, ItemUtil.getFormattedDescriptionText("items.description.damage.gun", Enums.ItemDescriptionType.ITEM_DAMAGE, Double.toString(this.dmg)));
        tooltip.add(StringUtil.getLocaleStringWithArguments("items.description.gun.speed", Double.toString((double)(2000 / this.firingDelay) / 100.0)));
        tooltip.add(ItemUtil.getFormattedDescriptionText("items.description.ammo.other", Enums.ItemDescriptionType.ITEM_AMMO_COST, StringUtil.getLocaleString("item.MetalSlug.name")));
    }
}

