/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.gun;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Tuple;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.projectiles.gun.BaseBullet;
import net.tslat.aoa3.item.weapon.gun.BaseGun;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.library.scheduling.async.EchoGullTask;
import net.tslat.aoa3.utils.ItemUtil;
import net.tslat.aoa3.utils.ModUtil;
import net.tslat.aoa3.utils.PredicateUtil;

public class EchoGull
extends BaseGun {
    public EchoGull(double dmg, int durability, int firingDelayTicks, float recoil) {
        super(dmg, durability, firingDelayTicks, recoil);
        this.func_77655_b("EchoGull");
        this.setRegistryName("aoa3:echo_gull");
    }

    @Override
    @Nullable
    public SoundEvent getFiringSound() {
        return SoundsRegister.FAST_RIFLE_FIRE;
    }

    @Override
    protected void doImpactEffect(Entity target, EntityLivingBase shooter, BaseBullet bullet, float bulletDmgMultiplier) {
        ArrayList<Tuple<EntityLivingBase, Integer>> entityList = new ArrayList<Tuple<EntityLivingBase, Integer>>();
        block0: for (EntityLivingBase entity : bullet.field_70170_p.func_175647_a(EntityLivingBase.class, bullet.func_174813_aQ().func_186662_g(30.0), PredicateUtil.IS_HOSTILE_MOB)) {
            int distance = (int)entity.func_70032_d((Entity)bullet);
            if (entityList.isEmpty()) {
                entityList.add((Tuple<EntityLivingBase, Integer>)new Tuple((Object)entity, (Object)distance));
                continue;
            }
            for (int i = 0; i < entityList.size(); ++i) {
                int dist = (Integer)entityList.get(i).func_76340_b();
                if (dist != distance && dist <= distance) continue;
                entityList.add(i, (Tuple<EntityLivingBase, Integer>)new Tuple((Object)entity, (Object)distance));
                continue block0;
            }
        }
        ModUtil.scheduleSyncronisedTask(new EchoGullTask(bullet.field_70170_p, entityList), 1);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(ItemUtil.getFormattedDescriptionText("item.EchoGull.desc.1", Enums.ItemDescriptionType.POSITIVE));
        super.func_77624_a(stack, world, tooltip, flag);
    }
}

