/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.gun;

import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.common.packet.PacketRecoil;
import net.tslat.aoa3.common.registration.CreativeTabsRegister;
import net.tslat.aoa3.common.registration.EnchantmentsRegister;
import net.tslat.aoa3.common.registration.ItemRegister;
import net.tslat.aoa3.entity.projectiles.gun.BaseBullet;
import net.tslat.aoa3.entity.projectiles.gun.EntityLimoniteBullet;
import net.tslat.aoa3.item.weapon.AdventWeapon;
import net.tslat.aoa3.item.weapon.sniper.BaseSniper;
import net.tslat.aoa3.item.weapon.staff.BaseStaff;
import net.tslat.aoa3.item.weapon.thrown.BaseThrownWeapon;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.library.misc.AoAAttributes;
import net.tslat.aoa3.utils.ConfigurationUtil;
import net.tslat.aoa3.utils.EntityUtil;
import net.tslat.aoa3.utils.ItemUtil;
import net.tslat.aoa3.utils.PacketUtil;
import net.tslat.aoa3.utils.StringUtil;

public abstract class BaseGun
extends Item
implements AdventWeapon {
    protected final double dmg;
    protected final int firingDelay;
    protected final float recoil;
    protected double holsterMod;

    public BaseGun(double dmg, int durability, int fireDelayTicks, float recoil) {
        this.dmg = dmg;
        this.firingDelay = fireDelayTicks;
        this.recoil = recoil;
        this.holsterMod = this.getDamage() == 0.0 ? 0.85 : (this instanceof BaseThrownWeapon ? 0.5 : 0.8 + 0.17 * Math.min(20.0 / (double)this.getFiringDelay() * this.getDamage() / 55.0, 0.85));
        this.func_77656_e(durability);
        this.func_77637_a(CreativeTabsRegister.GUNS);
        this.func_77625_d(1);
        this.func_77664_n();
    }

    public double getDamage() {
        return this.dmg * (double)(ConfigurationUtil.MainConfig.funOptions.hardcoreMode ? 1.25f : 1.0f);
    }

    public float getRecoil() {
        return this.recoil;
    }

    public int getFiringDelay() {
        return this.firingDelay;
    }

    public double getDrawTime() {
        return this.holsterMod;
    }

    @Nullable
    public SoundEvent getFiringSound() {
        return null;
    }

    public float getRecoilForShot(ItemStack stack, EntityLivingBase shooter) {
        return this.getRecoil();
    }

    public boolean func_82789_a(ItemStack stack, ItemStack repairMaterial) {
        return false;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || oldStack.func_77973_b() != newStack.func_77973_b();
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        Item mainItem;
        ItemStack stack = player.func_184586_b(hand);
        if (hand != this.getGunHand(stack)) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)stack);
        }
        if (player.func_184587_cr() && player.func_184585_cz()) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
        }
        if (hand == EnumHand.OFF_HAND && player.func_70093_af() && ((mainItem = player.func_184586_b(EnumHand.MAIN_HAND).func_77973_b()) instanceof BaseSniper || mainItem instanceof BaseStaff)) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)stack);
        }
        if (player.func_184825_o(0.0f) < 1.0f) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)stack);
        }
        BaseBullet ammo = null;
        if (!world.field_72995_K) {
            ammo = this.findAndConsumeAmmo(player, stack, hand);
        }
        if (ammo != null) {
            world.func_72838_d(ammo);
            player.func_71029_a(StatList.func_188057_b((Item)this));
            player.func_184811_cZ().func_185145_a((Item)this, this.getFiringDelay());
            stack.func_77972_a(1, (EntityLivingBase)player);
            if (this.getFiringSound() != null) {
                player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, this.getFiringSound(), SoundCategory.PLAYERS, 1.0f, 1.0f);
            }
            if (player instanceof EntityPlayerMP) {
                int control = EnchantmentHelper.func_77506_a((Enchantment)EnchantmentsRegister.CONTROL, (ItemStack)stack);
                float recoiling = this.getRecoilForShot(stack, (EntityLivingBase)player) * (1.0f - (float)control * 0.15f);
                PacketUtil.network.sendTo((IMessage)new PacketRecoil(hand == EnumHand.OFF_HAND ? recoiling * 2.5f : recoiling, this.getFiringDelay()), (EntityPlayerMP)player);
            }
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
        }
        if (player instanceof EntityPlayerMP) {
            ((EntityPlayerMP)player).func_71120_a(player.field_71069_bz);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
    }

    public EnumHand getGunHand(ItemStack stack) {
        return EnchantmentHelper.func_77506_a((Enchantment)EnchantmentsRegister.BRACE, (ItemStack)stack) > 0 ? EnumHand.OFF_HAND : EnumHand.MAIN_HAND;
    }

    public void doImpactDamage(Entity target, EntityLivingBase shooter, BaseBullet bullet, float bulletDmgMultiplier) {
        if (target != null) {
            float shellMod = 1.0f;
            if (bullet.getHand() != null) {
                shellMod = (float)((double)shellMod + 0.1 * (double)EnchantmentHelper.func_77506_a((Enchantment)EnchantmentsRegister.SHELL, (ItemStack)shooter.func_184586_b(bullet.getHand())));
            }
            System.out.println(target);
            if (EntityUtil.dealGunDamage(target, shooter, bullet, (float)this.getDamage() * bulletDmgMultiplier * shellMod)) {
                this.doImpactEffect(target, shooter, bullet, bulletDmgMultiplier);
            } else if (!(target instanceof EntityLivingBase)) {
                target.func_70097_a(new EntityDamageSourceIndirect("gun", (Entity)bullet, (Entity)shooter).func_76349_b(), (float)this.getDamage() * bulletDmgMultiplier * shellMod);
            }
        }
    }

    protected void doImpactEffect(Entity target, EntityLivingBase shooter, BaseBullet bullet, float bulletDmgMultiplier) {
    }

    public BaseBullet findAndConsumeAmmo(EntityPlayer player, ItemStack gunStack, EnumHand hand) {
        if (ItemUtil.findInventoryItem(player, new ItemStack((Item)ItemRegister.LIMONITE_BULLET), true, 1 + EnchantmentHelper.func_77506_a((Enchantment)EnchantmentsRegister.GREED, (ItemStack)gunStack))) {
            return new EntityLimoniteBullet((EntityLivingBase)player, (BaseGun)gunStack.func_77973_b(), hand, 120, 0);
        }
        return null;
    }

    public boolean func_77662_d() {
        return true;
    }

    public int func_77619_b() {
        return 8;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74774_a("HideFlags", (byte)2);
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(1, ItemUtil.getFormattedDescriptionText("items.description.damage.gun", Enums.ItemDescriptionType.ITEM_DAMAGE, StringUtil.roundToNthDecimalPlace((float)this.getDamage() * (1.0f + 0.1f * (float)EnchantmentHelper.func_77506_a((Enchantment)EnchantmentsRegister.SHELL, (ItemStack)stack)), 2)));
        tooltip.add(StringUtil.getLocaleStringWithArguments("items.description.gun.speed", Double.toString((double)(2000 / this.firingDelay) / 100.0)));
        tooltip.add(ItemUtil.getFormattedDescriptionText("items.description.ammo.bullets", Enums.ItemDescriptionType.ITEM_AMMO_COST));
    }

    private double getHolsterSpeed() {
        return this.holsterMod;
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot equipmentSlot, ItemStack stack) {
        Multimap multimap = super.getAttributeModifiers(equipmentSlot, stack);
        if (equipmentSlot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)AoAAttributes.gunMainHandSpeedModifier(-this.getHolsterSpeed()));
        } else if (equipmentSlot == EntityEquipmentSlot.OFFHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)AoAAttributes.gunOffHandSpeedModifier(-this.getHolsterSpeed()));
            multimap.put((Object)SharedMonsterAttributes.field_111263_d.func_111108_a(), (Object)AoAAttributes.BRACE_DEBUFF);
        }
        return multimap;
    }
}

