/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.greatblade;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.item.weapon.greatblade.BaseGreatblade;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.library.misc.AoAAttributes;
import net.tslat.aoa3.utils.ItemUtil;

public class LunarGreatblade
extends BaseGreatblade {
    private final double baseDmg;
    private final double maxDmg;

    public LunarGreatblade(double dmg, double speed, int durability) {
        super(dmg, speed, durability);
        this.func_77655_b("LunarGreatblade");
        this.setRegistryName("aoa3:lunar_greatblade");
        this.baseDmg = this.getDamage() - this.getDamage() / 2.0;
        this.maxDmg = this.getDamage() + this.getDamage() / 2.0;
    }

    @Override
    protected double getDamageForAttack(ItemStack stack, Entity target, EntityLivingBase attacker, double baseDmg) {
        return (float)((double)field_77697_d.nextFloat() * (this.maxDmg - baseDmg) + baseDmg);
    }

    @Override
    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot equipmentSlot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (equipmentSlot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)EntityPlayer.REACH_DISTANCE.func_111108_a(), (Object)this.REACH_MODIFIER);
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)AoAAttributes.vanillaWeaponSpeedModifier(this.speed));
        }
        return multimap;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(ItemUtil.getFormattedDescriptionText("items.description.damage.random", Enums.ItemDescriptionType.ITEM_DAMAGE, Double.toString(this.baseDmg), Double.toString(this.maxDmg)));
    }
}

