/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.greatblade;

import com.google.common.collect.Multimap;
import java.util.UUID;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.tslat.aoa3.common.registration.CreativeTabsRegister;
import net.tslat.aoa3.common.registration.EnchantmentsRegister;
import net.tslat.aoa3.common.registration.ItemRegister;
import net.tslat.aoa3.item.weapon.AdventWeapon;
import net.tslat.aoa3.item.weapon.LongReachWeapon;
import net.tslat.aoa3.library.misc.AoAAttributes;
import net.tslat.aoa3.utils.ConfigurationUtil;

public abstract class BaseGreatblade
extends Item
implements AdventWeapon,
LongReachWeapon {
    protected double dmg;
    protected double speed;
    protected final AttributeModifier REACH_MODIFIER = new AttributeModifier(UUID.fromString("93bb7485-ce86-4e78-ab50-26f53d78ad9d"), "AoAGreatbladeReach", (double)(this.getReach() - 3.5f), 0);

    public BaseGreatblade(double dmg, double speed, int durability) {
        this.func_77637_a(CreativeTabsRegister.GREATBLADES);
        this.dmg = dmg;
        this.speed = speed == 0.0 ? -3.2400001287460327 : speed;
        this.func_77656_e(durability);
        this.func_77625_d(1);
        this.func_77664_n();
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BLOCK;
    }

    public boolean canDestroyBlockInCreative(World world, BlockPos pos, ItemStack stack, EntityPlayer player) {
        return false;
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        return true;
    }

    public int func_77619_b() {
        return 8;
    }

    @Override
    public float getReach() {
        return 5.0f;
    }

    public double getDamage() {
        return this.dmg * (double)(ConfigurationUtil.MainConfig.funOptions.hardcoreMode ? 1.25f : 1.0f);
    }

    public double getAttackSpeed() {
        return this.speed;
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        Material material = state.func_185904_a();
        if (material == Material.field_151569_G) {
            return 25.0f;
        }
        if (material == Material.field_151585_k || material == Material.field_151582_l || material == Material.field_151589_v || material == Material.field_151584_j || material == Material.field_151572_C) {
            return 2.0f;
        }
        return 1.0f;
    }

    public boolean func_179218_a(ItemStack stack, World world, IBlockState state, BlockPos pos, EntityLivingBase holder) {
        if (!world.field_72995_K && (double)state.func_185887_b(world, pos) != 0.0) {
            stack.func_77972_a(2, holder);
        }
        return true;
    }

    public boolean onEntitySwing(EntityLivingBase holder, ItemStack stack) {
        return false;
    }

    protected double getDamageForAttack(ItemStack stack, Entity target, EntityLivingBase attacker, double baseDmg) {
        return this.getDamage();
    }

    @Override
    public boolean attackEntity(ItemStack stack, Entity target, EntityLivingBase attacker, float dmg) {
        float damageDealt = 0.0f;
        if (dmg < 0.0f) {
            dmg = (float)this.getDamageForAttack(stack, target, attacker, this.getDamage()) + 1.0f;
        }
        if (attacker instanceof EntityPlayer) {
            if (target instanceof EntityFireball) {
                if (target.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)attacker)), dmg)) {
                    damageDealt = dmg;
                }
            } else {
                PotionEffect str = attacker.func_70660_b(MobEffects.field_76420_g);
                PotionEffect weak = attacker.func_70660_b(MobEffects.field_76437_t);
                float targetHealth = 0.0f;
                if (target instanceof EntityLivingBase) {
                    targetHealth = ((EntityLivingBase)target).func_110143_aJ();
                }
                if (str != null) {
                    dmg += (float)((str.func_76458_c() + 1) * 3);
                }
                if (weak != null) {
                    dmg -= (float)((weak.func_76458_c() + 1) * 4);
                }
                float cooldownMultiplier = ((EntityPlayer)attacker).func_184825_o(0.0f);
                int severModifier = EnchantmentHelper.func_77506_a((Enchantment)EnchantmentsRegister.SEVER, (ItemStack)stack);
                float finalDmg = (dmg + (float)severModifier * 1.5f) * (cooldownMultiplier + 0.01f);
                if (target instanceof EntityDragon ? ((EntityDragon)target).func_70965_a((MultiPartEntityPart)target.func_70021_al()[0], DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)attacker)), finalDmg) : target.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)attacker)), finalDmg)) {
                    if (attacker.field_70170_p instanceof WorldServer) {
                        if ((double)cooldownMultiplier >= 1.0) {
                            double d0 = -MathHelper.func_76126_a((float)(attacker.field_70177_z * ((float)Math.PI / 180)));
                            double d1 = MathHelper.func_76134_b((float)(attacker.field_70177_z * ((float)Math.PI / 180)));
                            ((WorldServer)attacker.field_70170_p).func_175739_a(EnumParticleTypes.SWEEP_ATTACK, target.field_70165_t + d0, target.field_70163_u + (double)target.field_70131_O * 0.5, target.field_70161_v + d1, 0, d0, 0.0, d1, 0.0, new int[0]);
                            attacker.field_70170_p.func_184148_a(null, attacker.field_70165_t, attacker.field_70163_u, attacker.field_70161_v, SoundEvents.field_187730_dW, SoundCategory.PLAYERS, 1.0f, 1.0f);
                        }
                        int hearts = 0;
                        if (target instanceof EntityLivingBase) {
                            damageDealt = targetHealth - ((EntityLivingBase)target).func_110143_aJ();
                            hearts = (int)(damageDealt / 2.0f);
                        } else {
                            damageDealt = dmg;
                        }
                        if (hearts > 0) {
                            ((WorldServer)attacker.field_70170_p).func_175739_a(EnumParticleTypes.DAMAGE_INDICATOR, target.field_70165_t, target.field_70163_u + (double)(target.field_70131_O * 0.5f), target.field_70161_v, hearts, 0.1, 0.0, 0.1, 0.2, new int[0]);
                        }
                    }
                    stack.func_77972_a(1, attacker);
                }
            }
        } else {
            double health;
            if (dmg < 0.0f) {
                dmg = (float)this.getDamageForAttack(stack, target, attacker, this.getDamage());
            }
            PotionEffect str = attacker.func_70660_b(MobEffects.field_76420_g);
            PotionEffect weak = attacker.func_70660_b(MobEffects.field_76437_t);
            double d = health = target instanceof EntityLivingBase ? (double)((EntityLivingBase)target).func_110143_aJ() : 0.0;
            if (str != null) {
                dmg += (float)((str.func_76458_c() + 1) * 3);
            }
            if (weak != null) {
                dmg -= (float)((weak.func_76458_c() + 1) * 4);
            }
            if (target.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)attacker), dmg += (float)EnchantmentHelper.func_77506_a((Enchantment)EnchantmentsRegister.SEVER, (ItemStack)stack)) && health > 0.0) {
                damageDealt = (float)health - ((EntityLivingBase)target).func_110143_aJ();
            }
        }
        if (damageDealt > 0.0f) {
            this.doMeleeEffect(stack, attacker, target, damageDealt);
            return true;
        }
        return false;
    }

    protected void doMeleeEffect(ItemStack stack, EntityLivingBase attacker, Entity target, float dmgDealt) {
    }

    public boolean func_82789_a(ItemStack stack, ItemStack repairMaterial) {
        return repairMaterial.func_77973_b() != Items.field_151134_bR && OreDictionary.itemMatches((ItemStack)repairMaterial, (ItemStack)new ItemStack((Item)ItemRegister.MAGIC_REPAIR_DUST), (boolean)false);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot equipmentSlot, ItemStack stack) {
        Multimap multimap = super.getAttributeModifiers(equipmentSlot, stack);
        if (equipmentSlot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)EntityPlayer.REACH_DISTANCE.func_111108_a(), (Object)this.REACH_MODIFIER);
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)AoAAttributes.vanillaWeaponDamageModifier(this.getDamage()));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)AoAAttributes.vanillaWeaponSpeedModifier(this.getAttackSpeed()));
        }
        return multimap;
    }
}

