/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.cannon;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.common.registration.EnchantmentsRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.common.registration.WeaponRegister;
import net.tslat.aoa3.entity.projectiles.cannon.EntityRPG;
import net.tslat.aoa3.entity.projectiles.gun.BaseBullet;
import net.tslat.aoa3.item.weapon.cannon.BaseCannon;
import net.tslat.aoa3.item.weapon.gun.BaseGun;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.EntityUtil;
import net.tslat.aoa3.utils.ItemUtil;
import net.tslat.aoa3.utils.ModUtil;
import net.tslat.aoa3.utils.StringUtil;

public class RPG
extends BaseCannon {
    private double dmg;
    private int firingDelay;

    public RPG(double dmg, int durability, int firingDelayTicks, float recoil) {
        super(dmg, durability, firingDelayTicks, recoil);
        this.func_77655_b("RPG");
        this.setRegistryName("aoa3:rpg");
        this.dmg = dmg;
        this.firingDelay = firingDelayTicks;
    }

    @Override
    @Nullable
    public SoundEvent getFiringSound() {
        return SoundsRegister.RPG_FIRE;
    }

    @Override
    public BaseBullet findAndConsumeAmmo(EntityPlayer player, ItemStack gunStack, EnumHand hand) {
        if (ItemUtil.findInventoryItem(player, new ItemStack((Item)WeaponRegister.GRENADE), true, 1 + EnchantmentHelper.func_77506_a((Enchantment)EnchantmentsRegister.GREED, (ItemStack)gunStack))) {
            return new EntityRPG((EntityLivingBase)player, (BaseGun)gunStack.func_77973_b(), hand, 120, 0);
        }
        return null;
    }

    @Override
    public void doImpactDamage(Entity target, EntityLivingBase shooter, BaseBullet bullet, float bulletDmgMultiplier) {
        if (target != null) {
            if (target instanceof EntityLivingBase) {
                bulletDmgMultiplier = (float)((double)bulletDmgMultiplier * (1.0 + ((EntityLivingBase)target).func_110148_a(SharedMonsterAttributes.field_188791_g).func_111126_e() * 6.66 / 100.0));
            }
            if (EntityUtil.dealGunDamage(target, shooter, bullet, (float)this.dmg * bulletDmgMultiplier) && shooter instanceof EntityPlayerMP && target instanceof EntityLivingBase && ((EntityLivingBase)target).func_110143_aJ() == 0.0f && target.field_70160_al && target.field_70170_p.func_175623_d(target.func_180425_c().func_177977_b()) && target.field_70170_p.func_175623_d(target.func_180425_c().func_177979_c(2))) {
                ModUtil.completeAdvancement((EntityPlayerMP)shooter, "overworld/surface_to_air", "rpg_air_kill");
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(1, ItemUtil.getFormattedDescriptionText("items.description.damage.gun", Enums.ItemDescriptionType.ITEM_DAMAGE, Double.toString(this.dmg)));
        tooltip.add(ItemUtil.getFormattedDescriptionText("item.RPG.desc.1", Enums.ItemDescriptionType.POSITIVE));
        tooltip.add(ItemUtil.getFormattedDescriptionText("items.description.cannon.damage", Enums.ItemDescriptionType.ITEM_TYPE_INFO));
        tooltip.add(StringUtil.getLocaleStringWithArguments("items.description.gun.speed", Double.toString((double)(2000 / this.firingDelay) / 100.0)));
        tooltip.add(ItemUtil.getFormattedDescriptionText("items.description.ammo.grenades", Enums.ItemDescriptionType.ITEM_AMMO_COST));
    }
}

