/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.bow;

import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.common.registration.ItemRegister;
import net.tslat.aoa3.entity.projectiles.arrow.EntityHollyArrow;
import net.tslat.aoa3.item.weapon.bow.BaseBow;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.ItemUtil;
import net.tslat.aoa3.utils.StringUtil;

public class SpectralBow
extends BaseBow {
    public SpectralBow(double damage, float drawSpeedMultiplier, int durability) {
        super(damage, drawSpeedMultiplier, durability);
        this.func_77655_b("SpectralBow");
        this.setRegistryName("aoa3:spectral_bow");
    }

    @Override
    protected ItemStack func_185060_a(EntityPlayer player) {
        return new ItemStack((Item)ItemRegister.HOLLY_ARROW);
    }

    @Override
    protected EntityHollyArrow makeArrow(EntityLivingBase shooter, ItemStack bowStack, ItemStack ammoStack, float velocity, boolean consumeAmmo) {
        return super.makeArrow(shooter, bowStack, ammoStack, velocity, false);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(ItemUtil.getFormattedDescriptionText("item.SpectralBow.desc.1", Enums.ItemDescriptionType.POSITIVE));
        tooltip.add(1, StringUtil.getColourLocaleStringWithArguments("items.description.damage.arrows", TextFormatting.DARK_RED, Double.toString(this.getDamage())));
        tooltip.add(StringUtil.getLocaleStringWithArguments("items.description.bow.drawSpeed", Double.toString((double)((int)(72000.0f / this.getDrawSpeedMultiplier()) / 720) / 100.0)));
    }
}

