/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.blaster;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.capabilities.handlers.AdventMiscStackCapability;
import net.tslat.aoa3.capabilities.providers.AdventMiscStackProvider;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.projectiles.blaster.EntityIroMinerShot;
import net.tslat.aoa3.entity.projectiles.staff.BaseEnergyShot;
import net.tslat.aoa3.item.weapon.blaster.BaseBlaster;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.EntityUtil;
import net.tslat.aoa3.utils.ItemUtil;

public class IroMiner
extends BaseBlaster {
    public IroMiner(double dmg, int durability, int fireDelayTicks, float energyCost) {
        super(dmg, durability, fireDelayTicks, energyCost);
        this.func_77655_b("IroMiner");
        this.setRegistryName("aoa3:iro_miner");
    }

    @Override
    @Nullable
    public SoundEvent getFiringSound() {
        return SoundsRegister.MOON_SHINER_FIRE;
    }

    @Override
    public void fire(ItemStack blaster, EntityLivingBase shooter) {
        shooter.field_70170_p.func_72838_d((Entity)new EntityIroMinerShot(shooter, this, 60));
    }

    @Override
    public boolean doEntityImpact(BaseEnergyShot shot, Entity target, EntityLivingBase shooter) {
        AdventMiscStackCapability cap;
        ItemStack heldStack = shooter.func_184614_ca();
        float damageMod = 1.0f;
        if (heldStack.func_77973_b() == this && (cap = (AdventMiscStackCapability)heldStack.getCapability(AdventMiscStackProvider.MISC_STACK, null)) != null) {
            if (target.func_110124_au().equals(cap.getObject())) {
                damageMod = cap.getValue() + 0.02f;
                cap.setValue(damageMod);
            } else {
                cap.setObject(target.func_110124_au());
                cap.setValue(1.0f);
            }
        }
        return EntityUtil.dealBlasterDamage(shooter, target, (Entity)shot, (float)this.baseDmg * damageMod, false);
    }

    @Override
    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74774_a("HideFlags", (byte)2);
        return new AdventMiscStackProvider();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(ItemUtil.getFormattedDescriptionText("item.IroMiner.desc.1", Enums.ItemDescriptionType.POSITIVE));
        super.func_77624_a(stack, world, tooltip, flag);
    }
}

